/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartReportItemConstants;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartItemUtil
extends ChartExpressionUtil
implements ChartReportItemConstants {
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public static ReportItemHandle getBindingHolder(DesignElementHandle handle) {
        if (handle instanceof ReportElementHandle) {
            if (handle instanceof ReportItemHandle && (((ReportItemHandle)handle).getDataBindingReference() != null || ((ReportItemHandle)handle).getCube() != null || ((ReportItemHandle)handle).getDataSet() != null)) {
                return (ReportItemHandle)handle;
            }
            return ChartItemUtil.getBindingHolder(handle.getContainer());
        }
        return null;
    }

    public static DataSetHandle getBindingDataSet(DesignElementHandle element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ReportItemHandle) {
            DataSetHandle dataSet = ((ReportItemHandle)element).getDataSet();
            if (dataSet != null) {
                return dataSet;
            }
            if (((ReportItemHandle)element).getDataBindingType() == 2) {
                return ChartItemUtil.getBindingDataSet((DesignElementHandle)((ReportItemHandle)element).getDataBindingReference());
            }
            if (((ReportItemHandle)element).getDataBindingType() == 1) {
                return null;
            }
        }
        if (element.getContainer() != null) {
            return ChartItemUtil.getBindingDataSet(element.getContainer());
        }
        return null;
    }

    public static boolean isRtl() {
        boolean rtl = false;
        String eclipseCommands = SecurityUtil.getSysProp((String)"eclipse.commands");
        if (eclipseCommands != null) {
            String[] options = eclipseCommands.split("-");
            String regex = "[\\s]*[dD][iI][rR][\\s]*[rR][tT][lL][\\s]*";
            Pattern pattern = Pattern.compile(regex);
            int i = 0;
            while (i < options.length) {
                String option = options[i];
                if (pattern.matcher(option).matches()) {
                    rtl = true;
                    break;
                }
                ++i;
            }
        }
        return rtl;
    }

    public static Iterator<ComputedColumnHandle> getColumnDataBindings(ReportItemHandle itemHandle) {
        return ChartItemUtil.getColumnDataBindings(itemHandle, false);
    }

    public static Iterator<ComputedColumnHandle> getColumnDataBindings(ReportItemHandle itemHandle, boolean unique) {
        ComputedColumnHandle cch;
        if (itemHandle.getDataSet() != null || itemHandle.getCube() != null) {
            return itemHandle.columnBindingsIterator();
        }
        ReportItemHandle handle = ChartItemUtil.getBindingHolder((DesignElementHandle)itemHandle);
        if (handle == null) {
            return null;
        }
        LinkedHashMap<String, ComputedColumnHandle> bindingMap = new LinkedHashMap<String, ComputedColumnHandle>();
        ArrayList<ComputedColumnHandle> list = new ArrayList<ComputedColumnHandle>();
        Iterator i = handle.columnBindingsIterator();
        while (i.hasNext()) {
            cch = (ComputedColumnHandle)i.next();
            list.add(cch);
            bindingMap.put(cch.getName(), cch);
        }
        if (handle != itemHandle) {
            i = itemHandle.columnBindingsIterator();
            while (i.hasNext()) {
                cch = (ComputedColumnHandle)i.next();
                list.add(cch);
                bindingMap.put(cch.getName(), cch);
            }
        }
        if (unique) {
            return bindingMap.values().iterator();
        }
        return list.iterator();
    }

    public static int convertToDtEGroupUnit(DataType dataType, GroupingUnitType groupUnitType, double intervalRange) {
        if (dataType == DataType.NUMERIC_LITERAL) {
            if (intervalRange == 0.0) {
                return 0;
            }
            return 99;
        }
        if (dataType == DataType.DATE_TIME_LITERAL) {
            switch (groupUnitType.getValue()) {
                case 0: {
                    return 8;
                }
                case 1: {
                    return 7;
                }
                case 2: {
                    return 6;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 3;
                }
                case 7: {
                    return 1;
                }
            }
        } else if (dataType == DataType.TEXT_LITERAL) {
            switch (groupUnitType.getValue()) {
                case 9: {
                    return 100;
                }
            }
            return 0;
        }
        return 0;
    }

    public static int convertToChartGroupUnit(int groupInterval) {
        switch (groupInterval) {
            case 0: 
            case 99: {
                return -1;
            }
            case 8: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 1: {
                return 7;
            }
            case 100: {
                return 9;
            }
        }
        return -1;
    }

    public static double convertToDtEIntervalRange(DataType dataType, GroupingUnitType groupUnitType, double intervalRange) {
        double range = intervalRange;
        if (Double.isNaN(intervalRange)) {
            range = 0.0;
        }
        if (dataType == DataType.DATE_TIME_LITERAL && range <= 0.0) {
            range = 1.0;
        } else if (dataType == DataType.TEXT_LITERAL) {
            return (long)range;
        }
        return range;
    }

    public static int convertToDtESortDirection(SortOption sortOption) {
        if (sortOption == SortOption.ASCENDING_LITERAL) {
            return 0;
        }
        if (sortOption == SortOption.DESCENDING_LITERAL) {
            return 1;
        }
        return -1;
    }

    public static String convertToDtEAggFunction(String agg) {
        if ("Sum".equals(agg)) {
            return "SUM";
        }
        if ("Average".equals(agg)) {
            return "AVE";
        }
        if ("Count".equals(agg)) {
            return "COUNT";
        }
        if ("DistinctCount".equals(agg)) {
            return "COUNTDISTINCT";
        }
        if ("First".equals(agg)) {
            return "FIRST";
        }
        if ("Last".equals(agg)) {
            return "LAST";
        }
        if ("Min".equals(agg)) {
            return "MIN";
        }
        if ("Max".equals(agg)) {
            return "MAX";
        }
        if ("WeightedAverage".equals(agg)) {
            return "WEIGHTEDAVE";
        }
        if ("Median".equals(agg)) {
            return "MEDIAN";
        }
        if ("Mode".equals(agg)) {
            return "MODE";
        }
        if ("STDDEV".equals(agg)) {
            return "STDDEV";
        }
        if ("Variance".equals(agg)) {
            return "VARIANCE";
        }
        if ("Irr".equals(agg)) {
            return "IRR";
        }
        if ("Mirr".equals(agg)) {
            return "MIRR";
        }
        if ("NPV".equals(agg)) {
            return "NPV";
        }
        if ("Percentile".equals(agg)) {
            return "PERCENTILE";
        }
        if ("Quartile".equals(agg)) {
            return "QUARTILE";
        }
        if ("MovingAverage".equals(agg)) {
            return "MOVINGAVE";
        }
        if ("RunningSum".equals(agg)) {
            return "RUNNINGSUM";
        }
        if ("RunningNPV".equals(agg)) {
            return "RUNNINGNPV";
        }
        if ("Rank".equals(agg)) {
            return "RANK";
        }
        if ("Top".equals(agg)) {
            return "ISTOPN";
        }
        if ("TopPercent".equals(agg)) {
            return "ISTOPNPERCENT";
        }
        if ("Bottom".equals(agg)) {
            return "ISBOTTOMN";
        }
        if ("BottomPercent".equals(agg)) {
            return "ISBOTTOMNPERCENT";
        }
        if ("PercentRank".equals(agg)) {
            return "PERCENTRANK";
        }
        if ("PercentSum".equals(agg)) {
            return "PERCENTSUM";
        }
        if ("RunningCount".equals(agg)) {
            return "RUNNINGCOUNT";
        }
        return null;
    }

    public static boolean isYGroupingDefined(SeriesDefinition orthSeriesDefinition) {
        if (orthSeriesDefinition == null) {
            return false;
        }
        String yGroupExpr = null;
        if (orthSeriesDefinition.getQuery() != null) {
            yGroupExpr = orthSeriesDefinition.getQuery().getDefinition();
        }
        return yGroupExpr != null && !"".equals(yGroupExpr);
    }

    public static boolean isBaseGroupingDefined(SeriesDefinition baseSD) {
        return baseSD != null && !baseSD.getDesignTimeSeries().getDataDefinition().isEmpty() && baseSD.getGrouping() != null && baseSD.getGrouping().isEnabled();
    }

    public static boolean isGroupingDefined(Chart cm) {
        SeriesDefinition baseSD = null;
        SeriesDefinition orthSD = null;
        Object[] orthAxisArray = null;
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            baseSD = (SeriesDefinition)cwa.getBaseAxes()[0].getSeriesDefinitions().get(0);
            orthAxisArray = cwa.getOrthogonalAxes(cwa.getBaseAxes()[0], true);
            orthSD = (SeriesDefinition)((Axis)orthAxisArray[0]).getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            baseSD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
            orthSD = (SeriesDefinition)baseSD.getSeriesDefinitions().get(0);
        }
        return ChartItemUtil.isBaseGroupingDefined(baseSD) || ChartItemUtil.isYGroupingDefined(orthSD);
    }

    public static boolean isBaseGroupingDefined(Chart cm) {
        SeriesDefinition baseSD = null;
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            baseSD = (SeriesDefinition)cwa.getBaseAxes()[0].getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            baseSD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
        }
        return ChartItemUtil.isBaseGroupingDefined(baseSD);
    }

    public static boolean isSetRunningAggregation(Chart cm) throws ChartException {
        SeriesDefinition baseSD = (SeriesDefinition)ChartUtil.getBaseSeriesDefinitions((Chart)cm).get(0);
        for (SeriesDefinition orthoSD : ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm)) {
            for (Query query : orthoSD.getDesignTimeSeries().getDataDefinition()) {
                IAggregateFunction aFunc;
                String aggrFunc = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthoSD, (SeriesDefinition)baseSD, (Query)query);
                if (aggrFunc == null || (aFunc = PluginSettings.instance().getAggregateFunction(aggrFunc)) == null || aFunc.getType() != 1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSetSummaryAggregation(Chart cm) throws ChartException {
        SeriesDefinition baseSD = (SeriesDefinition)ChartUtil.getBaseSeriesDefinitions((Chart)cm).get(0);
        for (SeriesDefinition orthoSD : ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm)) {
            for (Query query : orthoSD.getDesignTimeSeries().getDataDefinition()) {
                IAggregateFunction aFunc;
                String aggrFunc = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthoSD, (SeriesDefinition)baseSD, (Query)query);
                if (aggrFunc == null || (aFunc = PluginSettings.instance().getAggregateFunction(aggrFunc)) == null || aFunc.getType() != 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAggregation(Chart cm) {
        SeriesDefinition baseSD = null;
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            baseSD = (SeriesDefinition)cwa.getBaseAxes()[0].getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            baseSD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
        }
        if (ChartItemUtil.isBaseGroupingDefined(baseSD) && !ChartUtil.isEmpty((String)baseSD.getGrouping().getAggregateExpression())) {
            return true;
        }
        try {
            if (cm instanceof ChartWithAxes) {
                EList axisList = ((Axis)((ChartWithAxes)cm).getAxes().get(0)).getAssociatedAxes();
                for (Axis a : axisList) {
                    for (SeriesDefinition orthSD : a.getSeriesDefinitions()) {
                        for (Query query : orthSD.getDesignTimeSeries().getDataDefinition()) {
                            if (ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)query) == null) continue;
                            return true;
                        }
                    }
                }
            } else if (cm instanceof ChartWithoutAxes) {
                for (SeriesDefinition orthSD : ((SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0)).getSeriesDefinitions()) {
                    for (Query query : orthSD.getDesignTimeSeries().getDataDefinition()) {
                        if (ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)query) == null) continue;
                        return true;
                    }
                }
            }
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
        return false;
    }

    public static IReportItem getChartReportItemFromHandle(ExtendedItemHandle eih) {
        IReportItem item = null;
        if (!ChartItemUtil.isChartHandle(eih)) {
            return null;
        }
        try {
            item = eih.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log((Exception)((Object)e));
        }
        if (item == null) {
            try {
                eih.loadExtendedElement();
                item = eih.getReportItem();
            }
            catch (ExtendedElementException eeex) {
                logger.log((Exception)((Object)eeex));
            }
            if (item == null) {
                logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.UnableToLocateWrapper"));
            }
        }
        return item;
    }

    public static boolean isChartHandle(Object content) {
        return content instanceof ExtendedItemHandle && "Chart".equals(((ExtendedItemHandle)content).getExtensionName());
    }

    public static Chart getChartFromHandle(ExtendedItemHandle handle) {
        IReportItem item = ChartItemUtil.getChartReportItemFromHandle(handle);
        if (item == null) {
            return null;
        }
        return (Chart)item.getProperty("chart.instance");
    }

    public static Iterator<ComputedColumnHandle> getAllColumnBindingsIterator(ReportItemHandle itemHandle) {
        ReportItemHandle container = ChartItemUtil.getBindingHolder((DesignElementHandle)itemHandle);
        if (container != null && container != itemHandle) {
            ArrayList<ComputedColumnHandle> allBindings = new ArrayList<ComputedColumnHandle>();
            Iterator ownBindings = itemHandle.columnBindingsIterator();
            while (ownBindings.hasNext()) {
                allBindings.add((ComputedColumnHandle)ownBindings.next());
            }
            Iterator containerBindings = container.columnBindingsIterator();
            while (containerBindings.hasNext()) {
                allBindings.add((ComputedColumnHandle)containerBindings.next());
            }
            return allBindings.iterator();
        }
        return itemHandle.columnBindingsIterator();
    }

    public static double convertToPoints(DimensionHandle handle, int dpi) {
        double retValue = 0.0;
        if (handle.getMeasure() > 0.0 && handle.getUnits().trim().length() > 0) {
            retValue = handle.getUnits() == "pt" ? handle.getMeasure() : (handle.getUnits() == "px" ? handle.getMeasure() * 72.0 / (double)dpi : DimensionUtil.convertTo((double)handle.getMeasure(), (String)handle.getUnits(), (String)"pt").getMeasure());
        }
        return retValue;
    }

    public static String convertToChartAggExpression(String agg) {
        if ("sum".equalsIgnoreCase(agg)) {
            return "Sum";
        }
        if ("average".equalsIgnoreCase(agg)) {
            return "Average";
        }
        if ("count".equalsIgnoreCase(agg)) {
            return "Count";
        }
        if ("count-distinct".equalsIgnoreCase(agg)) {
            return "DistinctCount";
        }
        if ("first".equalsIgnoreCase(agg)) {
            return "First";
        }
        if ("last".equalsIgnoreCase(agg)) {
            return "Last";
        }
        if ("min".equalsIgnoreCase(agg)) {
            return "Min";
        }
        if ("max".equalsIgnoreCase(agg)) {
            return "Max";
        }
        if ("weighted-avg".equalsIgnoreCase(agg)) {
            return "WeightedAverage";
        }
        if ("median".equalsIgnoreCase(agg)) {
            return "Median";
        }
        if ("mode".equalsIgnoreCase(agg)) {
            return "Mode";
        }
        if ("stddev".equalsIgnoreCase(agg)) {
            return "STDDEV";
        }
        if ("variance".equalsIgnoreCase(agg)) {
            return "Variance";
        }
        if ("irr".equalsIgnoreCase(agg)) {
            return "Irr";
        }
        if ("mirr".equalsIgnoreCase(agg)) {
            return "Mirr";
        }
        if ("npv".equalsIgnoreCase(agg)) {
            return "NPV";
        }
        if ("percentile".equalsIgnoreCase(agg)) {
            return "Percentile";
        }
        if ("quartile".equalsIgnoreCase(agg)) {
            return "Quartile";
        }
        if ("moving-ave".equalsIgnoreCase(agg)) {
            return "MovingAverage";
        }
        if ("running-sum".equalsIgnoreCase(agg)) {
            return "RunningSum";
        }
        if ("running-npv".equalsIgnoreCase(agg)) {
            return "RunningNPV";
        }
        if ("rank".equalsIgnoreCase(agg)) {
            return "Rank";
        }
        if ("is-top-n".equalsIgnoreCase(agg)) {
            return "Top";
        }
        if ("is-top-n-percent".equalsIgnoreCase(agg)) {
            return "TopPercent";
        }
        if ("is-bottom-n".equalsIgnoreCase(agg)) {
            return "Bottom";
        }
        if ("is-bottom-n-percent".equalsIgnoreCase(agg)) {
            return "BottomPercent";
        }
        if ("percent-rank".equalsIgnoreCase(agg)) {
            return "PercentRank";
        }
        if ("percent-sum".equalsIgnoreCase(agg)) {
            return "PercentSum";
        }
        if ("running-count".equalsIgnoreCase(agg)) {
            return "RunningCount";
        }
        return null;
    }

    public static boolean isChildOfMultiViewsHandle(DesignElementHandle handle) {
        return handle != null && handle.getContainer() instanceof MultiViewsHandle;
    }

    public static ReportItemHandle getReportItemReference(ReportItemHandle itemHandle) {
        return ChartItemUtil.getReportItemReferenceImpl(itemHandle, itemHandle);
    }

    private static ReportItemHandle getReportItemReferenceImpl(ReportItemHandle currentItemHandle, ReportItemHandle itemHandle) {
        ReportItemHandle handle = currentItemHandle.getDataBindingReference();
        if (handle == null) {
            if (currentItemHandle.getContainer() instanceof MultiViewsHandle) {
                return ChartItemUtil.getReportItemReferenceImpl((ReportItemHandle)currentItemHandle.getContainer().getContainer(), itemHandle);
            }
            if (currentItemHandle == itemHandle) {
                return null;
            }
            return currentItemHandle;
        }
        return ChartItemUtil.getReportItemReferenceImpl(handle, itemHandle);
    }

    public static boolean isChartReportItemHandle(ReportItemHandle handle) {
        return handle instanceof ExtendedItemHandle && ChartItemUtil.getChartFromHandle((ExtendedItemHandle)handle) != null;
    }

    public static boolean isChartInheritGroups(ReportItemHandle handle) {
        return handle.getDataSet() == null && ChartItemUtil.isContainerInheritable(handle) && !handle.getBooleanProperty("inheritColumns");
    }

    public static boolean isChartInheritColumnsOnly(ReportItemHandle handle) {
        return handle.getDataSet() != null && ChartItemUtil.isContainerInheritable(handle) && handle.getBooleanProperty("inheritColumns");
    }

    public static boolean isContainerInheritable(ReportItemHandle itemHandle) {
        DesignElementHandle container = itemHandle.getContainer();
        if (container instanceof CellHandle || container instanceof ListHandle || container instanceof ListGroupHandle) {
            while (container != null) {
                if (container instanceof ListingHandle) {
                    return true;
                }
                container = container.getContainer();
            }
        }
        return false;
    }

    public static ExtendedItemHandle getChartReferenceItemHandle(ReportItemHandle handle) {
        ReportItemHandle refHandle = handle.getDataBindingReference();
        if (refHandle == null || !ChartItemUtil.isChartHandle(refHandle)) {
            return null;
        }
        return ChartItemUtil.getChartReferenceItemHandleImpl((ExtendedItemHandle)refHandle);
    }

    private static ExtendedItemHandle getChartReferenceItemHandleImpl(ExtendedItemHandle chartHandle) {
        ReportItemHandle refHandle = chartHandle.getDataBindingReference();
        if (refHandle != null && ChartItemUtil.isChartHandle(refHandle)) {
            return ChartItemUtil.getChartReferenceItemHandleImpl((ExtendedItemHandle)chartHandle.getDataBindingReference());
        }
        return chartHandle;
    }

    public static boolean checkChartBindingComplete(Chart cm) {
        Series bs = ((SeriesDefinition)ChartUtil.getBaseSeriesDefinitions((Chart)cm).get(0)).getDesignTimeSeries();
        if (bs.getDataDefinition().size() == 0 || ChartUtil.isEmpty((String)((Query)bs.getDataDefinition().get(0)).getDefinition())) {
            return false;
        }
        for (SeriesDefinition vsd : ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm)) {
            Series vs = vsd.getDesignTimeSeries();
            if (vs.getDataDefinition().size() != 0 && !ChartUtil.isEmpty((String)((Query)vs.getDataDefinition().get(0)).getDefinition())) continue;
            return false;
        }
        return true;
    }

    public static Bounds createDefaultChartBounds(ExtendedItemHandle eih, Chart cm) {
        if (ChartCubeUtil.isAxisChart((DesignElementHandle)eih)) {
            ChartWithAxes cmWA = (ChartWithAxes)cm;
            if (cmWA.isTransposed()) {
                return BoundsImpl.create((double)0.0, (double)0.0, (double)212.0, (double)22.0);
            }
            return BoundsImpl.create((double)0.0, (double)0.0, (double)22.0, (double)130.0);
        }
        return BoundsImpl.create((double)0.0, (double)0.0, (double)212.0, (double)130.0);
    }

    public static boolean checkBindingsUsed(ExtendedItemHandle handle, List<String> bindingNames) {
        if (bindingNames != null && !bindingNames.isEmpty()) {
            Chart cm = ChartItemUtil.getChartFromHandle(handle);
            if (cm == null) {
                return false;
            }
            HashSet<String> usedBindings = new HashSet<String>();
            SeriesDefinition bsd = (SeriesDefinition)ChartUtil.getBaseSeriesDefinitions((Chart)cm).get(0);
            Series xSeries = bsd.getDesignTimeSeries();
            usedBindings.add(((Query)xSeries.getDataDefinition().get(0)).getDefinition());
            for (SeriesDefinition vsd : ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm)) {
                usedBindings.add(vsd.getQuery().getDefinition());
                Series vs = vsd.getDesignTimeSeries();
                for (Query query : vs.getDataDefinition()) {
                    usedBindings.add(query.getDefinition());
                }
            }
            ChartExpressionUtil.ExpressionCodec ec = ChartModelHelper.instance().createExpressionCodec();
            for (String strQuery : usedBindings) {
                if (strQuery.trim().length() <= 0) continue;
                ec.decode(strQuery);
                Collection names = ec.getRowBindingNameSet();
                if (names.isEmpty()) {
                    names = ec.getCubeBindingNameList();
                }
                if (names.isEmpty()) continue;
                for (String bindingName : bindingNames) {
                    if (!names.contains(bindingName)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

