/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.wizards.datatransfer.IFileExporter;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarOutputStream;

public class TarFileExporter
implements IFileExporter {
    private TarOutputStream outputStream;
    private GZIPOutputStream gzipOutputStream;

    public TarFileExporter(String filename, boolean compress) throws IOException {
        if (compress) {
            this.gzipOutputStream = new GZIPOutputStream(new FileOutputStream(filename));
            this.outputStream = new TarOutputStream(new BufferedOutputStream(this.gzipOutputStream));
        } else {
            this.outputStream = new TarOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        }
    }

    public void finished() throws IOException {
        this.outputStream.close();
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.close();
        }
    }

    private void write(TarEntry entry, IFile contents) throws IOException, CoreException {
        URI location = contents.getLocationURI();
        if (location == null) {
            throw new FileNotFoundException(contents.getFullPath().toOSString());
        }
        InputStream contentStream = contents.getContents(false);
        entry.setSize(EFS.getStore((URI)location).fetchInfo().getLength());
        this.outputStream.putNextEntry(entry);
        try {
            int n;
            byte[] readBuffer = new byte[4096];
            while ((n = contentStream.read(readBuffer)) > 0) {
                this.outputStream.write(readBuffer, 0, n);
            }
        }
        finally {
            if (contentStream != null) {
                contentStream.close();
            }
        }
        this.outputStream.closeEntry();
    }

    public void write(IContainer container, String destinationPath) throws IOException {
        ResourceAttributes attributes;
        TarEntry newEntry = new TarEntry(destinationPath);
        if (container.getLocalTimeStamp() != -1L) {
            newEntry.setTime(container.getLocalTimeStamp() / 1000L);
        }
        if ((attributes = container.getResourceAttributes()) != null && attributes.isExecutable()) {
            newEntry.setMode(newEntry.getMode() | 0x49L);
        }
        if (attributes != null && attributes.isReadOnly()) {
            newEntry.setMode(newEntry.getMode() & 0xFFFFFFFFFFFFFF6DL);
        }
        newEntry.setFileType(53);
        this.outputStream.putNextEntry(newEntry);
    }

    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        ResourceAttributes attributes;
        TarEntry newEntry = new TarEntry(destinationPath);
        if (resource.getLocalTimeStamp() != -1L) {
            newEntry.setTime(resource.getLocalTimeStamp() / 1000L);
        }
        if ((attributes = resource.getResourceAttributes()) != null && attributes.isExecutable()) {
            newEntry.setMode(newEntry.getMode() | 0x49L);
        }
        if (attributes != null && attributes.isReadOnly()) {
            newEntry.setMode(newEntry.getMode() & 0xFFFFFFFFFFFFFF6DL);
        }
        this.write(newEntry, resource);
    }
}

