/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.IChartObject;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainterBase;
import org.eclipse.birt.chart.ui.swt.ColorPalette;
import org.eclipse.birt.chart.ui.swt.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartDataSheet;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartWizardContext;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.interfaces.ISeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskPreviewable;
import org.eclipse.birt.chart.ui.swt.series.BubbleSeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.BaseDataDefinitionComponent;
import org.eclipse.birt.chart.ui.swt.wizard.preview.ChartLivePreviewThread;
import org.eclipse.birt.chart.ui.swt.wizard.preview.LivePreviewTask;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.SimpleTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TaskSelectData
extends SimpleTask
implements ITaskChangeListener,
ITaskPreviewable,
Listener {
    private static final int CENTER_WIDTH_HINT = 400;
    protected IChartPreviewPainter previewPainter = null;
    private Canvas previewCanvas = null;
    private ISelectDataCustomizeUI dynamicArea;
    private SashForm foSashForm;
    private Point fLeftSize;
    private Point fRightSize;
    private static final int DEFAULT_HEIGHT = 580;
    private Composite fHeaderArea;
    private ScrolledComposite fDataArea;

    public TaskSelectData() {
        super(Messages.getString("TaskSelectData.TaskExp"));
        this.setDescription(Messages.getString("TaskSelectData.Task.Description"));
    }

    public void createControl(Composite parent) {
        this.getDataSheet().setChartModel(this.getChartModel());
        this.getDataSheet().addListener((Listener)this);
        if (this.topControl == null || this.topControl.isDisposed()) {
            this.topControl = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(3, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            this.topControl.setLayout((Layout)gridLayout);
            this.topControl.setLayoutData((Object)new GridData(1536));
            this.dynamicArea = this.createDataComponentsUI();
            this.getCustomizeUI().init();
            ScrolledComposite sc = new ScrolledComposite(this.topControl, 256);
            GridLayout layout = new GridLayout();
            sc.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            sc.setLayoutData((Object)gridData);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            Composite cmp = new Composite((Composite)sc, 0);
            cmp.setLayout((Layout)new GridLayout());
            cmp.setLayoutData((Object)new GridData(1808));
            sc.setContent((Control)cmp);
            sc.setMinWidth(800);
            this.foSashForm = new SashForm(cmp, 512);
            GridLayout layout2 = new GridLayout();
            this.foSashForm.setLayout((Layout)layout2);
            GridData gridData2 = new GridData(1808);
            gridData2.widthHint = 800;
            this.foSashForm.setLayoutData((Object)gridData2);
            this.foSashForm.addListener(11, (Listener)this);
            this.placeComponents();
            this.previewPainter = this.createPreviewPainter();
        } else {
            this.customizeUI();
        }
        this.resize();
        if (this.getChartModel() instanceof ChartWithAxes) {
            this.checkDataTypeForChartWithAxes();
        }
        this.doPreview();
        DataDefinitionTextManager.getInstance().refreshAll();
        DataDefinitionTextManager.getInstance().setContext((IChartWizardContext)this.getContext());
        ChartUIUtil.checkGroupType((ChartWizardContext)((ChartWizardContext)this.getContext()), (Chart)this.getChartModel());
        ChartUIUtil.checkAggregateType((ChartWizardContext)((ChartWizardContext)this.getContext()));
        this.bindHelp();
    }

    protected void bindHelp() {
        ChartUIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.chart.cshelp.SelectChartData_ID");
    }

    protected void customizeUI() {
        this.getCustomizeUI().init();
        this.refreshLeftArea();
        this.refreshRightArea();
        this.refreshBottomArea();
        this.resize();
        this.getCustomizeUI().layoutAll();
    }

    protected ISelectDataCustomizeUI createDataComponentsUI() {
        return this.getDataSheet().createCustomizeUI((ITask)this);
    }

    private void resize() {
        Point headerSize = this.computeHeaderAreaSize();
        int[] weight = this.foSashForm.getWeights();
        if (headerSize.y > 290) {
            weight[0] = headerSize.y;
            weight[1] = 290;
            ((GridData)this.foSashForm.getLayoutData()).heightHint = weight[0] + weight[1];
        } else {
            weight[0] = 200;
            weight[1] = 200;
            ((GridData)this.foSashForm.getLayoutData()).heightHint = 580;
        }
    }

    private void refreshLeftArea() {
        this.getCustomizeUI().refreshLeftBindingArea();
        this.getCustomizeUI().selectLeftBindingArea(true, null);
    }

    private void refreshRightArea() {
        this.getCustomizeUI().refreshRightBindingArea();
        this.getCustomizeUI().selectRightBindingArea(true, null);
    }

    private void refreshBottomArea() {
        this.getCustomizeUI().refreshBottomBindingArea();
        this.getCustomizeUI().selectBottomBindingArea(true, null);
    }

    private void placeComponents() {
        ChartAdapter.beginIgnoreNotifications();
        try {
            this.createHeadArea();
            this.createDataArea();
        }
        finally {
            ChartAdapter.endIgnoreNotifications();
        }
    }

    private void createDataArea() {
        this.fDataArea = new ScrolledComposite((Composite)this.foSashForm, 512);
        GridLayout gl = new GridLayout();
        this.fDataArea.setLayout((Layout)gl);
        GridData gd = new GridData(1040);
        this.fDataArea.setLayoutData((Object)gd);
        this.fDataArea.setExpandHorizontal(true);
        this.fDataArea.setExpandVertical(true);
        Composite dataComposite = new Composite((Composite)this.fDataArea, 0);
        GridLayout gl2 = new GridLayout(2, false);
        gl2.marginLeft = this.fLeftSize.x;
        dataComposite.setLayout((Layout)gl2);
        GridData gd2 = new GridData(1808);
        dataComposite.setLayoutData((Object)gd2);
        this.fDataArea.setContent((Control)dataComposite);
        this.getDataSheet().createDataSelector(dataComposite);
        gd = new GridData();
        gd.widthHint = this.fRightSize.x - 40;
        new Label(dataComposite, 0).setLayoutData((Object)gd);
        this.getDataSheet().createDataDragSource(dataComposite);
        this.getDataSheet().createActionButtons(dataComposite);
        new Label(dataComposite, 0);
        this.fDataArea.setMinHeight(this.fDataArea.computeSize((int)-1, (int)-1).y);
    }

    private void createHeadArea() {
        this.fHeaderArea = new Composite((Composite)this.foSashForm, 0);
        GridLayout layout = new GridLayout(3, false);
        this.fHeaderArea.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.fHeaderArea.setLayoutData((Object)gd);
        Composite cmpLeftContainer = ChartUIUtil.createCompositeWrapper((Composite)this.fHeaderArea);
        GridData gridData = new GridData(772);
        gridData.verticalSpan = 2;
        cmpLeftContainer.setLayoutData((Object)gridData);
        this.getCustomizeUI().createLeftBindingArea(cmpLeftContainer);
        this.fLeftSize = cmpLeftContainer.computeSize(-1, -1);
        this.createPreviewArea(this.fHeaderArea);
        Composite cmpRightContainer = ChartUIUtil.createCompositeWrapper((Composite)this.fHeaderArea);
        gridData = new GridData(772);
        gridData.verticalSpan = 2;
        cmpRightContainer.setLayoutData((Object)gridData);
        this.getCustomizeUI().createRightBindingArea(cmpRightContainer);
        this.fRightSize = cmpRightContainer.computeSize(-1, -1);
        Composite cmpBottomContainer = ChartUIUtil.createCompositeWrapper((Composite)this.fHeaderArea);
        gridData = new GridData(770);
        cmpBottomContainer.setLayoutData((Object)gridData);
        this.getCustomizeUI().createBottomBindingArea(cmpBottomContainer);
    }

    private Point computeHeaderAreaSize() {
        return this.fHeaderArea.computeSize(-1, -1);
    }

    private Point computeDataAreaSize() {
        return this.fDataArea.computeSize(-1, -1);
    }

    private void createPreviewArea(Composite parent) {
        Composite cmpPreview = ChartUIUtil.createCompositeWrapper((Composite)parent);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.heightHint = 200;
        cmpPreview.setLayoutData((Object)gridData);
        Label label = new Label(cmpPreview, 0);
        label.setFont(JFaceResources.getBannerFont());
        label.setText(Messages.getString("TaskSelectData.Label.ChartPreview"));
        this.previewCanvas = new Canvas(cmpPreview, 2048);
        GridData gd = new GridData(1808);
        this.previewCanvas.setLayoutData((Object)gd);
        this.previewCanvas.setBackground(Display.getDefault().getSystemColor(22));
    }

    public IChartPreviewPainter createPreviewPainter() {
        ChartPreviewPainter painter = new ChartPreviewPainter((ChartWizardContext)this.getContext());
        this.getPreviewCanvas().addPaintListener((PaintListener)painter);
        this.getPreviewCanvas().addControlListener((ControlListener)painter);
        painter.setPreview(this.getPreviewCanvas());
        return painter;
    }

    protected Chart getChartModel() {
        if (this.getContext() == null) {
            return null;
        }
        return ((ChartWizardContext)this.getContext()).getModel();
    }

    protected IDataServiceProvider getDataServiceProvider() {
        return ((ChartWizardContext)this.getContext()).getDataServiceProvider();
    }

    public void dispose() {
        super.dispose();
        if (this.previewPainter != null) {
            this.previewPainter.dispose();
        }
        this.previewPainter = null;
        if (this.dynamicArea != null) {
            this.dynamicArea.dispose();
        }
        this.dynamicArea = null;
        ColorPalette.getInstance().restore();
        DataDefinitionTextManager.getInstance().removeAll();
        DataDefinitionTextManager.getInstance().setContext(null);
    }

    private ISelectDataCustomizeUI getCustomizeUI() {
        return this.dynamicArea;
    }

    public void handleEvent(Event event) {
        if (event.data == this.getDataSheet() || event.data instanceof BaseDataDefinitionComponent) {
            if (event.type == 1) {
                if (this.getChartModel() instanceof ChartWithAxes) {
                    this.checkDataTypeForChartWithAxes();
                }
                this.doPreview();
                this.updateApplyButton();
            } else if (event.type == 2) {
                this.getCustomizeUI().refreshBottomBindingArea();
                this.getCustomizeUI().refreshLeftBindingArea();
                this.getCustomizeUI().refreshRightBindingArea();
                DataDefinitionTextManager.getInstance().refreshAll();
            }
        }
        if (event.type == 2) {
            if ("category".equals(event.data)) {
                this.getCustomizeUI().refreshBottomBindingArea();
            } else if ("optional".equals(event.data)) {
                this.getCustomizeUI().refreshRightBindingArea();
            } else if ("value".equals(event.data)) {
                this.getCustomizeUI().refreshLeftBindingArea();
            }
            DataDefinitionTextManager.getInstance().refreshAll();
        } else if (event.type == 11) {
            this.autoSash();
        }
    }

    private void autoSash() {
        int headerHeight = this.computeHeaderAreaSize().y;
        int dataHeight = this.computeDataAreaSize().y;
        int height = this.foSashForm.getClientArea().height;
        int[] weight = this.foSashForm.getWeights();
        if (height > headerHeight && height > dataHeight) {
            if (height > headerHeight + dataHeight) {
                weight[0] = height - dataHeight;
                weight[1] = dataHeight + 1;
            } else {
                weight[0] = headerHeight;
                weight[1] = height - headerHeight;
            }
        }
        this.foSashForm.setWeights(weight);
    }

    public void changeTask(Notification notification) {
        if (this.previewPainter != null) {
            if (notification == null) {
                if (this.getChartModel() instanceof ChartWithAxes) {
                    this.checkDataTypeForChartWithAxes();
                }
                return;
            }
            if (notification.getEventType() == 4 && notification.getNotifier() instanceof Axis) {
                ChartWizard.removeAllExceptions((String)("" + notification.getOldValue().hashCode()));
            }
            if (notification.getNotifier() instanceof Query && ((Query)notification.getNotifier()).eContainer() instanceof Series) {
                this.checkDataType((Query)notification.getNotifier(), (Series)((Query)notification.getNotifier()).eContainer());
            }
            if (notification.getNotifier() instanceof SeriesDefinition && this.getChartModel() instanceof ChartWithAxes) {
                this.checkDataTypeForChartWithAxes();
            }
            this.getCustomizeUI().notifyChange(notification);
            if (notification.getNotifier() instanceof Query || notification.getNotifier() instanceof Axis || notification.getNotifier() instanceof SeriesDefinition || notification.getNotifier() instanceof SeriesGrouping) {
                this.doPreview();
            } else if (ChartPreviewPainterBase.isLivePreviewActive()) {
                ChartAdapter.beginIgnoreNotifications();
                ChartUIUtil.syncRuntimeSeries((Chart)this.getChartModel());
                ChartAdapter.endIgnoreNotifications();
                this.doPreview();
            } else {
                this.doPreview();
            }
        }
    }

    private void checkDataType(Query query, Series series) {
        String expression = query.getDefinition();
        Axis axis = null;
        Query o = query;
        while (o != null) {
            if (!((o = o.eContainer()) instanceof Axis)) continue;
            axis = (Axis)o;
            break;
        }
        Collection cRegisteredEntries = ChartUIExtensionsImpl.instance().getSeriesUIComponents(this.getContext().getClass().getSimpleName());
        Iterator iterEntries = cRegisteredEntries.iterator();
        String sSeries = null;
        while (iterEntries.hasNext()) {
            ISeriesUIProvider provider = (ISeriesUIProvider)iterEntries.next();
            sSeries = provider.getSeriesClass();
            if (!sSeries.equals(series.getClass().getName())) continue;
            boolean isMagicAgg = false;
            if (this.getChartModel() instanceof ChartWithAxes) {
                DataType dataType = this.getDataServiceProvider().getDataType(expression);
                SeriesDefinition baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.getChartModel()).get(0);
                SeriesDefinition orthSD = null;
                orthSD = (SeriesDefinition)series.eContainer();
                String aggFunc = null;
                try {
                    aggFunc = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)query);
                    ChartWizard.removeException((String)"PluginSettings.getAggregateFunc");
                }
                catch (ChartException e) {
                    ChartWizard.showException((String)"PluginSettings.getAggregateFunc", (String)e.getLocalizedMessage());
                }
                if (baseSD != orthSD && baseSD.eContainer() != axis && ChartUtil.isMagicAggregate((String)aggFunc)) {
                    dataType = DataType.NUMERIC_LITERAL;
                    isMagicAgg = true;
                }
                if (!this.isValidatedAxis(dataType, axis.getType())) {
                    AxisType[] axisTypes = provider.getCompatibleAxisType(series);
                    int[] validationIndex = provider instanceof BubbleSeriesUIProvider ? new int[1] : provider.validationIndex(series);
                    boolean needValidate = false;
                    int i = 0;
                    while (i < validationIndex.length) {
                        if (query == series.getDataDefinition().get(i)) {
                            needValidate = true;
                            break;
                        }
                        ++i;
                    }
                    SeriesDefinition sd = (SeriesDefinition)series.eContainer();
                    if (((Axis)sd.eContainer()).getSeriesDefinitions().indexOf((Object)sd) > 0) {
                        needValidate = false;
                    }
                    if (needValidate) {
                        int i2 = 0;
                        while (i2 < axisTypes.length) {
                            if (this.isValidatedAxis(dataType, axisTypes[i2])) {
                                this.axisNotification(axis, axisTypes[i2]);
                                axis.setType(axisTypes[i2]);
                                break;
                            }
                            ++i2;
                        }
                    }
                }
            }
            try {
                if (!isMagicAgg) {
                    provider.validateSeriesBindingType(series, this.getDataServiceProvider());
                }
                ChartWizard.removeException((String)("CheckSeriesBindingType_" + series.eContainer().hashCode()));
            }
            catch (ChartException ce) {
                ChartWizard.showException((String)("CheckSeriesBindingType_" + series.eContainer().hashCode()), (String)Messages.getFormattedString("TaskSelectData.Warning.TypeCheck", new String[]{ce.getLocalizedMessage(), series.getDisplayName()}));
            }
            break;
        }
    }

    private boolean isValidatedAxis(DataType dataType, AxisType axisType) {
        if (dataType == null) {
            return true;
        }
        if (dataType == DataType.DATE_TIME_LITERAL && axisType == AxisType.DATE_TIME_LITERAL) {
            return true;
        }
        if (dataType == DataType.NUMERIC_LITERAL && (axisType == AxisType.LINEAR_LITERAL || axisType == AxisType.LOGARITHMIC_LITERAL)) {
            return true;
        }
        return dataType == DataType.TEXT_LITERAL && axisType == AxisType.TEXT_LITERAL;
    }

    private void axisNotification(Axis axis, AxisType type) {
        ChartAdapter.beginIgnoreNotifications();
        this.convertSampleData(axis, type);
        axis.setFormatSpecifier(null);
        EList markerLines = axis.getMarkerLines();
        int i = 0;
        while (i < markerLines.size()) {
            ((MarkerLine)markerLines.get(i)).setFormatSpecifier(null);
            ++i;
        }
        EList markerRanges = axis.getMarkerRanges();
        int i2 = 0;
        while (i2 < markerRanges.size()) {
            ((MarkerRange)markerRanges.get(i2)).setFormatSpecifier(null);
            ++i2;
        }
        ChartAdapter.endIgnoreNotifications();
    }

    private void convertSampleData(Axis axis, AxisType axisType) {
        if (axis.getAssociatedAxes() != null && axis.getAssociatedAxes().size() != 0) {
            BaseSampleData bsd = (BaseSampleData)this.getChartModel().getSampleData().getBaseSampleData().get(0);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation(), (int)0));
        } else {
            int iStartIndex = this.getFirstSeriesDefinitionIndexForAxis(axis);
            int iEndIndex = iStartIndex + axis.getSeriesDefinitions().size();
            int iOSDSize = this.getChartModel().getSampleData().getOrthogonalSampleData().size();
            int i = 0;
            while (i < iOSDSize) {
                OrthogonalSampleData osd = (OrthogonalSampleData)this.getChartModel().getSampleData().getOrthogonalSampleData().get(i);
                if (osd.getSeriesDefinitionIndex() >= iStartIndex && osd.getSeriesDefinitionIndex() < iEndIndex) {
                    osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)osd.getDataSetRepresentation(), (int)i));
                }
                ++i;
            }
        }
    }

    private int getFirstSeriesDefinitionIndexForAxis(Axis axis) {
        EList axisList = ((Axis)((ChartWithAxes)this.getChartModel()).getAxes().get(0)).getAssociatedAxes();
        int index = 0;
        int i = 0;
        while (i < axisList.size()) {
            if (axis.equals(axisList.get(i))) {
                index = i;
                break;
            }
            ++i;
        }
        int iTmp = 0;
        int i2 = 0;
        while (i2 < index) {
            iTmp += ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.getChartModel()), (int)i2).getSeriesDefinitions().size();
            ++i2;
        }
        return iTmp;
    }

    private void updateApplyButton() {
        if (this.container != null && this.container instanceof ChartWizard) {
            ((ChartWizard)this.container).updateApplyButton();
        }
    }

    private void checkDataTypeForChartWithAxes() {
        List osds = ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.getChartModel());
        int i = 0;
        while (i < osds.size()) {
            SeriesDefinition sd = (SeriesDefinition)osds.get(i);
            Series series = sd.getDesignTimeSeries();
            this.checkDataType(ChartUIUtil.getDataQuery((SeriesDefinition)sd, (int)0), series);
            ++i;
        }
    }

    public Image getImage() {
        return UIHelper.getImage((String)"icons/obj16/selectdata.gif");
    }

    private IChartDataSheet getDataSheet() {
        return ((ChartWizardContext)this.getContext()).getDataSheet();
    }

    public void doPreview() {
        if (this.getChartModel() instanceof ChartWithAxes) {
            this.checkDataTypeForChartWithAxes();
        } else {
            ChartWizard.removeAllExceptions((String)"CheckSeriesBindingType_");
        }
        LivePreviewTask lpt = new LivePreviewTask(Messages.getString("TaskFormatChart.LivePreviewTask.BindData"), null);
        lpt.addTask(new LivePreviewTask(){

            public void run() {
                if (TaskSelectData.this.previewPainter != null) {
                    this.setParameter("Chart Model", ChartUIUtil.prepareLivePreview((Chart)TaskSelectData.this.getChartModel(), (IDataServiceProvider)TaskSelectData.this.getDataServiceProvider(), (IActionEvaluator)((ChartWizardContext)TaskSelectData.this.context).getActionEvaluator()));
                }
            }
        });
        lpt.addTask(new LivePreviewTask(){

            public void run() {
                if (TaskSelectData.this.previewCanvas != null && TaskSelectData.this.previewCanvas.getDisplay() != null && !TaskSelectData.this.previewCanvas.getDisplay().isDisposed()) {
                    TaskSelectData.this.previewCanvas.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if ((this).TaskSelectData.this.previewPainter != null) {
                                Chart cm = (Chart)this.getParameter("Chart Model");
                                (this).TaskSelectData.this.previewPainter.renderModel((IChartObject)cm);
                            }
                        }
                    });
                }
            }
        });
        ((ChartLivePreviewThread)((ChartWizardContext)this.context).getLivePreviewThread()).setParentShell(this.getPreviewCanvas().getShell());
        ((ChartLivePreviewThread)((ChartWizardContext)this.context).getLivePreviewThread()).add(lpt);
    }

    public Canvas getPreviewCanvas() {
        return this.previewCanvas;
    }

    public boolean isPreviewable() {
        return true;
    }
}

