/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.FragmentResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.PathResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class NewResourceFileDialog
extends ElementTreeSelectionDialog {
    private Text text;
    private ISelectionStatusValidator fValidator = null;
    private String fileName;
    private String parentPath;

    public NewResourceFileDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setDoubleClickSelects(false);
        this.setSorter(new FileViewerSorter());
    }

    protected Control createDialogArea(Composite parent) {
        Composite rt = (Composite)super.createDialogArea(parent);
        Composite pane = new Composite(rt, 0);
        pane.setLayout((Layout)new GridLayout(2, false));
        pane.setLayoutData((Object)new GridData(768));
        Label lb = new Label(pane, 0);
        lb.setText(Messages.getString((String)"NewResourceFileDialog.label.NewFile"));
        this.text = new Text(pane, 2048);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewResourceFileDialog.this.fileName = NewResourceFileDialog.this.text.getText();
                NewResourceFileDialog.this.updateOKStatus();
            }
        });
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection stsel;
                Object obj;
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection && (obj = (stsel = (IStructuredSelection)sel).getFirstElement()) instanceof IResource) {
                    NewResourceFileDialog.this.text.setText(((IResource)obj).getName());
                }
            }
        });
        return rt;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    private Object[] getExistItems() {
        TreeItem[] items = this.getTreeViewer().getTree().getItems();
        Object[] objs = new Object[items.length];
        int i = 0;
        while (i < items.length) {
            objs[i] = items[i].getData();
            ++i;
        }
        return objs;
    }

    protected void updateOKStatus() {
        Object fCurrStatus = this.fValidator != null ? this.fValidator.validate(this.getExistItems()) : new Status(0, "org.eclipse.ui", 0, "", null);
        this.updateStatus((IStatus)fCurrStatus);
        Button okButton = this.getOkButton();
        if (okButton.getEnabled() && fCurrStatus.getCode() == 4) {
            okButton.setEnabled(false);
        }
    }

    public int open() {
        int rt = super.open();
        if (rt == 0 && this.parentPath != null) {
            File file = new File(String.valueOf(this.parentPath) + File.separator + this.fileName);
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
        }
        return rt;
    }

    public void setParentPath(String path) {
        this.parentPath = path;
    }

    protected static class FileViewerSorter
    extends ViewerSorter {
        protected FileViewerSorter() {
        }

        public int category(Object element) {
            if (element instanceof File) {
                if (((File)element).isDirectory()) {
                    return 0;
                }
                return 1;
            }
            if (element instanceof ResourceEntry) {
                if (((ResourceEntry)element).isFile()) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }

        public void sort(final Viewer viewer, Object[] elements) {
            Arrays.sort(elements, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    if (a instanceof FragmentResourceEntry) {
                        if (b instanceof FragmentResourceEntry) {
                            return FileViewerSorter.this.compare(viewer, a, b);
                        }
                        return -1;
                    }
                    if (a instanceof PathResourceEntry) {
                        if (b instanceof FragmentResourceEntry) {
                            return 1;
                        }
                        if (b instanceof PathResourceEntry) {
                            return FileViewerSorter.this.compare(viewer, a, b);
                        }
                        return -1;
                    }
                    return FileViewerSorter.this.compare(viewer, a, b);
                }
            });
        }
    }
}

