/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dnd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.designer.util.IVirtualValidator;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class InsertInLayoutUtil {
    public static DesignElementHandle performInsert(Object insertObj, Object target, Object targetParent) throws SemanticException {
        Assert.isNotNull((Object)insertObj);
        Assert.isNotNull((Object)target);
        if (insertObj instanceof DataSetHandle) {
            return InsertInLayoutUtil.performInsertDataSet((DataSetHandle)insertObj);
        }
        if (insertObj instanceof ResultSetColumnHandle) {
            return InsertInLayoutUtil.performInsertDataSetColumn((ResultSetColumnHandle)insertObj, target, targetParent);
        }
        if (insertObj instanceof ScalarParameterHandle) {
            return InsertInLayoutUtil.performInsertParameter((ScalarParameterHandle)insertObj);
        }
        if (insertObj instanceof VariableElementHandle) {
            return InsertInLayoutUtil.performInsertVariable((VariableElementHandle)insertObj);
        }
        if (insertObj instanceof String) {
            return InsertInLayoutUtil.performInsertString((String)insertObj, target);
        }
        if (insertObj instanceof Object[]) {
            return InsertInLayoutUtil.performMultiInsert((Object[])insertObj, target, targetParent);
        }
        if (insertObj instanceof IStructuredSelection) {
            return InsertInLayoutUtil.performMultiInsert(((IStructuredSelection)insertObj).toArray(), target, targetParent);
        }
        return null;
    }

    public static DesignElementHandle performInsert(Object insertObj, EditPart editPart) throws SemanticException {
        Assert.isNotNull((Object)insertObj);
        Assert.isNotNull((Object)editPart);
        return InsertInLayoutUtil.performInsert(insertObj, editPart.getModel(), editPart.getParent().getModel());
    }

    protected static DesignElementHandle performMultiInsert(Object[] array, Object target, Object targetParent) throws SemanticException {
        DesignElementHandle result = null;
        MultiItemsExpandRule rule = new MultiItemsExpandRule(array, target);
        if (rule.canInsert()) {
            Object[] positions = (Object[])rule.getInsertPosition();
            if (positions != null) {
                int i = 0;
                while (i < array.length) {
                    DesignElementHandle newObj = InsertInLayoutUtil.performInsert(array[i], positions[i], targetParent);
                    if (i == rule.getFocusIndex()) {
                        result = newObj;
                    } else {
                        DNDUtil.addElementHandle((Object)positions[i], (DesignElementHandle)newObj);
                    }
                    ++i;
                }
            }
        } else if (array.length != 0) {
            result = InsertInLayoutUtil.performInsert(array[0], target, targetParent);
        }
        return result;
    }

    public static DataItemHandle performInsertParameter(ScalarParameterHandle model) throws SemanticException {
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)dataHandle, (String)model.getName());
        ExpressionUtility.setBindingColumnExpression(model, bindingColumn);
        String paramType = model.getDataType();
        if ("dateTime".equals(paramType)) {
            paramType = "date-time";
        }
        bindingColumn.setDataType(paramType);
        dataHandle.addColumnBinding(bindingColumn, false);
        dataHandle.setResultSetColumn(bindingColumn.getName());
        return dataHandle;
    }

    public static DataItemHandle performInsertVariable(VariableElementHandle model) throws SemanticException {
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)dataHandle, (String)model.getName());
        bindingColumn.setExpression(DEUtil.getExpression((Object)model));
        String paramType = "string";
        bindingColumn.setDataType(paramType);
        dataHandle.addColumnBinding(bindingColumn, false);
        dataHandle.setResultSetColumn(bindingColumn.getName());
        return dataHandle;
    }

    protected static DesignElementHandle performInsertDataSetColumn(ResultSetColumnHandle model, Object target, Object targetParent) throws SemanticException {
        InsertInLayoutRule rule;
        TableHandle tableHandle;
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        DataSetHandle dataSet = (DataSetHandle)model.getElementHandle();
        if (targetParent instanceof TableHandle && (tableHandle = (TableHandle)targetParent).isSummaryTable()) {
            tableHandle.setDataSet(dataSet);
            if ("dimension".equals(UIUtil.getColumnAnalysis(model))) {
                ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)model.getColumnName());
                bindingColumn.setDataType(model.getDataType());
                ExpressionUtility.setBindingColumnExpression(model, bindingColumn);
                bindingColumn.setDisplayName(UIUtil.getColumnDisplayName(model));
                String displayKey = UIUtil.getColumnDisplayNameKey(model);
                if (displayKey != null) {
                    bindingColumn.setDisplayNameID(displayKey);
                }
                tableHandle.addColumnBinding(bindingColumn, false);
                dataHandle.setResultSetColumn(model.getColumnName());
                SlotHandle slotHandle = tableHandle.getGroups();
                for (Object o : slotHandle.getContents()) {
                    GroupHandle group = (GroupHandle)o;
                    if (!group.getName().equals(model.getColumnName())) continue;
                    return null;
                }
                DesignElementFactory factory = DesignElementFactory.getInstance(tableHandle.getModuleHandle());
                TableGroupHandle groupHandle = factory.newTableGroup();
                int columnCount = tableHandle.getColumnCount();
                groupHandle.getHeader().add((DesignElementHandle)factory.newTableRow(columnCount));
                groupHandle.getFooter().add((DesignElementHandle)factory.newTableRow(columnCount));
                groupHandle.setName(model.getColumnName());
                Expression newKeyExpr = new Expression((Object)ExpressionUtility.getColumnExpression(model.getColumnName(), ExpressionUtility.getExpressionConverter("javascript")), "javascript");
                groupHandle.setExpressionProperty("keyExpr", newKeyExpr);
                TOC toc = StructureFactory.createTOC();
                toc.setExpression(ExpressionUtility.getColumnExpression(model.getColumnName(), ExpressionUtility.getExpressionConverter("javascript")));
                groupHandle.addTOC(toc);
                slotHandle.add((DesignElementHandle)groupHandle, slotHandle.getCount());
                RowHandle rowHandle = (RowHandle)groupHandle.getHeader().get(0);
                CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(0);
                cellHandle.getContent().add((DesignElementHandle)dataHandle);
                return groupHandle;
            }
            if (("measure".equals(UIUtil.getColumnAnalysis(model)) || "attribute".equals(UIUtil.getColumnAnalysis(model))) && target instanceof CellHandle && ((CellHandle)target).getContainer().getContainer() instanceof GroupHandle) {
                CellHandle cellHandle = (CellHandle)target;
                GroupHandle group = (GroupHandle)cellHandle.getContainer().getContainer();
                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)model.getColumnName());
                ComputedColumnHandle binding = DEUtil.addColumn((DesignElementHandle)tableHandle, (ComputedColumn)column, (boolean)true);
                binding.setAggregateOn(group.getName());
                if ("measure".equals(UIUtil.getColumnAnalysis(model))) {
                    binding.setAggregateFunction("sum");
                } else {
                    binding.setAggregateFunction("max");
                }
                binding.setExpression(ExpressionUtil.createJSRowExpression((String)model.getColumnName()));
                dataHandle.setResultSetColumn(binding.getName());
                InsertInLayoutRule rule2 = new LabelAddRule(target);
                if (rule2.canInsert()) {
                    LabelHandle label = DesignElementFactory.getInstance().newLabel(null);
                    label.setText(UIUtil.getColumnDisplayName(model));
                    rule2.insert(label);
                }
                if ((rule2 = new GroupKeySetRule(target, model)).canInsert()) {
                    rule2.insert(model);
                }
                return dataHandle;
            }
        }
        dataHandle.setResultSetColumn(model.getColumnName());
        boolean wordWrap = UIUtil.isWordWrap(model);
        if (wordWrap) {
            dataHandle.getPrivateStyle().setWhiteSpace("normal");
        } else {
            dataHandle.getPrivateStyle().setWhiteSpace("nowrap");
        }
        if (targetParent instanceof ReportItemHandle) {
            ComputedColumn bindingColumn;
            ReportItemHandle container = (ReportItemHandle)targetParent;
            ReportItemHandle root = DEUtil.getBindingRoot((DesignElementHandle)container);
            if (root == null) {
                if ((container = DEUtil.getListingContainer((DesignElementHandle)container)) == null) {
                    bindingColumn = InsertInLayoutUtil.createBindingColumn(target, (ReportItemHandle)dataHandle, model);
                    dataHandle.setDataSet(dataSet);
                    dataHandle.addColumnBinding(bindingColumn, false);
                } else {
                    bindingColumn = InsertInLayoutUtil.createBindingColumn(target, container, model);
                    container.setDataSet(dataSet);
                    container.addColumnBinding(bindingColumn, false);
                }
            } else if (root.getDataSet() == dataSet) {
                container = DEUtil.getBindingHolder((DesignElementHandle)container);
                bindingColumn = InsertInLayoutUtil.createBindingColumn(target, container, model);
                container.addColumnBinding(bindingColumn, false);
            } else {
                ListingHandle listingHandle = DEUtil.getListingContainer((DesignElementHandle)container);
                if (listingHandle != null && DEUtil.getBindingRoot((DesignElementHandle)listingHandle) == root && DEUtil.getBindingHolder((DesignElementHandle)listingHandle) != listingHandle) {
                    ComputedColumn bindingColumn2 = InsertInLayoutUtil.createBindingColumn(target, (ReportItemHandle)listingHandle, model);
                    listingHandle.setDataSet(dataSet);
                    listingHandle.addColumnBinding(bindingColumn2, false);
                }
            }
        } else {
            ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)dataHandle, (String)model.getColumnName());
            bindingColumn.setDataType(model.getDataType());
            ExpressionUtility.setBindingColumnExpression(model, bindingColumn);
            bindingColumn.setDisplayName(UIUtil.getColumnDisplayName(model));
            String displayKey = UIUtil.getColumnDisplayNameKey(model);
            if (displayKey != null) {
                bindingColumn.setDisplayNameID(displayKey);
            }
            if (target instanceof DesignElementHandle && ExpressionUtil.hasAggregation((String)bindingColumn.getExpression())) {
                String groupType = DEUtil.getGroupControlType((DesignElementHandle)((DesignElementHandle)target));
                if (groupType.equals("group")) {
                    bindingColumn.setAggregateOn(((GroupHandle)DEUtil.getGroups((DesignElementHandle)((DesignElementHandle)target)).get(0)).getName());
                } else if (groupType.equals("listing")) {
                    bindingColumn.setAggregateOn(null);
                }
            }
            dataHandle.addColumnBinding(bindingColumn, false);
            dataHandle.setDataSet(dataSet);
        }
        ActionHandle actionHandle = UIUtil.getColumnAction(model);
        if (actionHandle != null) {
            ArrayList<IStructure> source = new ArrayList<IStructure>();
            source.add(actionHandle.getStructure());
            ArrayList newAction = ModelUtil.cloneStructList(source);
            dataHandle.setAction((Action)newAction.get(0));
        }
        if ((rule = new LabelAddRule(target)).canInsert()) {
            LabelHandle label = DesignElementFactory.getInstance().newLabel(null);
            label.setText(UIUtil.getColumnDisplayName(model));
            String displayKey = UIUtil.getColumnDisplayNameKey(model);
            if (displayKey != null) {
                label.setTextKey(displayKey);
            }
            rule.insert(label);
        }
        if ((rule = new GroupKeySetRule(target, model)).canInsert()) {
            rule.insert(model);
        }
        return dataHandle;
    }

    private static ComputedColumn createBindingColumn(Object target, ReportItemHandle bindingHolder, ResultSetColumnHandle model) {
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)bindingHolder, (String)model.getColumnName());
        bindingColumn.setDataType(model.getDataType());
        ExpressionUtility.setBindingColumnExpression(model, bindingColumn);
        bindingColumn.setDisplayName(UIUtil.getColumnDisplayName(model));
        String displayKey = UIUtil.getColumnDisplayNameKey(model);
        if (displayKey != null) {
            bindingColumn.setDisplayNameID(displayKey);
        }
        if (target instanceof DesignElementHandle && ExpressionUtil.hasAggregation((String)bindingColumn.getExpression())) {
            String groupType = DEUtil.getGroupControlType((DesignElementHandle)((DesignElementHandle)target));
            if (groupType.equals("group")) {
                bindingColumn.setAggregateOn(((GroupHandle)DEUtil.getGroups((DesignElementHandle)((DesignElementHandle)target)).get(0)).getName());
            } else if (groupType.equals("listing")) {
                bindingColumn.setAggregateOn(null);
            }
        }
        return bindingColumn;
    }

    protected static DesignElementHandle performInsertString(String expression, Object target) throws SemanticException {
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        dataHandle.setResultSetColumn(expression);
        LabelAddRule rule = new LabelAddRule(target);
        if (rule.canInsert()) {
            LabelHandle label = DesignElementFactory.getInstance().newLabel(null);
            label.setText(expression);
            rule.insert(label);
        }
        return dataHandle;
    }

    protected static TableHandle performInsertDataSet(DataSetHandle model) throws SemanticException {
        CachedMetaDataHandle cachedMetadata = DataSetUIUtil.getCachedMetaDataHandle(model);
        ArrayList<ResultSetColumnHandle> columList = new ArrayList<ResultSetColumnHandle>();
        for (ResultSetColumnHandle element : cachedMetadata.getResultSet()) {
            columList.add(element);
        }
        ResultSetColumnHandle[] columns = columList.toArray(new ResultSetColumnHandle[columList.size()]);
        TableHandle tableHandle = DesignElementFactory.getInstance().newTableItem(null, columns.length);
        InsertInLayoutUtil.setInitWidth(tableHandle);
        InsertInLayoutUtil.insertToCell(model, tableHandle, tableHandle.getHeader(), columns, true);
        InsertInLayoutUtil.insertToCell(model, tableHandle, tableHandle.getDetail(), columns, false);
        tableHandle.setDataSet(model);
        return tableHandle;
    }

    public static boolean handleValidateInsertToLayout(Object insertObj, EditPart targetPart) {
        if (targetPart == null) {
            return false;
        }
        if (insertObj instanceof Object[]) {
            Object[] array = (Object[])insertObj;
            if (!InsertInLayoutUtil.checkSameDataSetInMultiColumns(array)) {
                return false;
            }
            if (!InsertInLayoutUtil.checkContainContainMulitItem(array, targetPart.getModel())) {
                return false;
            }
            int i = 0;
            while (i < array.length) {
                if (!InsertInLayoutUtil.handleValidateInsertToLayout(array[i], targetPart)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (insertObj instanceof IStructuredSelection) {
            return InsertInLayoutUtil.handleValidateInsertToLayout(((IStructuredSelection)insertObj).toArray(), targetPart);
        }
        if (insertObj instanceof DataSetHandle) {
            return InsertInLayoutUtil.isHandleValid((DesignElementHandle)((DataSetHandle)insertObj)) && InsertInLayoutUtil.handleValidateDataSet(targetPart);
        }
        if (insertObj instanceof ResultSetColumnHandle) {
            return InsertInLayoutUtil.handleValidateDataSetColumn((ResultSetColumnHandle)insertObj, targetPart);
        }
        if (insertObj instanceof LabelHandle) {
            return InsertInLayoutUtil.handleValidateLabel((LabelHandle)insertObj, targetPart);
        }
        if (insertObj instanceof ResultSetColumnHandle) {
            return InsertInLayoutUtil.handleValidateDataSetColumn((ResultSetColumnHandle)insertObj, targetPart);
        }
        if (insertObj instanceof ScalarParameterHandle) {
            return InsertInLayoutUtil.isHandleValid((DesignElementHandle)((ScalarParameterHandle)insertObj)) && InsertInLayoutUtil.handleValidateParameter(targetPart);
        }
        return false;
    }

    private static boolean handleValidateLabel(LabelHandle handle, EditPart targetPart) {
        Object obj;
        if (targetPart.getModel() instanceof IAdaptable && (obj = ((IAdaptable)targetPart.getModel()).getAdapter(DesignElementHandle.class)) instanceof ExtendedItemHandle) {
            return ((ExtendedItemHandle)obj).canContain(DEUtil.getDefaultContentName((Object)obj), (DesignElementHandle)handle);
        }
        return false;
    }

    private static boolean checkContainContainMulitItem(Object[] objects, Object slotHandle) {
        SlotHandle handle = null;
        if (slotHandle instanceof SlotHandle) {
            handle = (SlotHandle)slotHandle;
        }
        return handle == null || objects == null || objects.length <= 1 || handle.getDefn().isMultipleCardinality();
    }

    protected static boolean checkSameDataSetInMultiColumns(Object[] array) {
        if (array == null) {
            return false;
        }
        DesignElementHandle dataSet = null;
        int i = 0;
        while (i < array.length) {
            if (array[i] instanceof ResultSetColumnHandle) {
                DesignElementHandle currDataSet = ((ResultSetColumnHandle)array[i]).getElementHandle();
                if (currDataSet == null) {
                    return false;
                }
                if (dataSet == null) {
                    dataSet = currDataSet;
                } else if (dataSet != currDataSet) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected static boolean handleValidateDataSetDropContainer(EditPart dropPart) {
        if (dropPart.getParent() == null) {
            return false;
        }
        Object container = dropPart.getParent().getModel();
        return container instanceof GridHandle || container instanceof TableHandle || container instanceof FreeFormHandle || container instanceof ListHandle || dropPart.getModel() instanceof ModuleHandle;
    }

    protected static boolean handleValidateDataSetColumnDropContainer(EditPart dropPart) {
        if (dropPart.getParent() == null) {
            return false;
        }
        Object container = dropPart.getParent().getModel();
        return container instanceof GridHandle || container instanceof TableHandle || container instanceof FreeFormHandle || container instanceof ListHandle || container instanceof MasterPageHandle || dropPart.getModel() instanceof ModuleHandle;
    }

    protected static boolean handleValidateMeasureDropContainer(MeasureHandle measure, EditPart dropPart) {
        if (dropPart.getModel() instanceof IVirtualValidator) {
            return ((IVirtualValidator)dropPart.getModel()).handleValidate((Object)measure);
        }
        return false;
    }

    protected static boolean handleValidateDimensionDropContainer(DimensionHandle dimension, EditPart dropPart) {
        if (dropPart.getModel() instanceof IVirtualValidator) {
            return ((IVirtualValidator)dropPart.getModel()).handleValidate((Object)dimension);
        }
        return false;
    }

    protected static boolean handleValidateParameterDropContainer(EditPart dropPart) {
        if (dropPart.getParent() == null) {
            return false;
        }
        Object container = dropPart.getParent().getModel();
        return container instanceof GridHandle || container instanceof TableHandle || container instanceof FreeFormHandle || container instanceof ListHandle || dropPart.getModel() instanceof ModuleHandle;
    }

    protected static boolean handleValidateDataSet(EditPart target) {
        return InsertInLayoutUtil.handleValidateDataSetDropContainer(target) && DNDUtil.handleValidateTargetCanContainType((Object)target.getModel(), (String)"Table");
    }

    protected static boolean handleValidateDimension(DimensionHandle insertObj, EditPart target) {
        return InsertInLayoutUtil.handleValidateDimensionDropContainer(insertObj, target);
    }

    protected static boolean handleValidateMeasure(MeasureHandle insertObj, EditPart target) {
        return InsertInLayoutUtil.handleValidateMeasureDropContainer(insertObj, target);
    }

    protected static boolean handleValidateDataSetColumn(ResultSetColumnHandle insertObj, EditPart target) {
        if (InsertInLayoutUtil.handleValidateDataSetColumnDropContainer(target) && DNDUtil.handleValidateTargetCanContainType((Object)target.getModel(), (String)"Data")) {
            if (target.getModel() instanceof ModuleHandle || InsertInLayoutUtil.isMasterPageHeaderOrFooter(target.getModel())) {
                return true;
            }
            DesignElementHandle handle = (DesignElementHandle)target.getParent().getModel();
            if (handle instanceof ReportItemHandle) {
                ListingHandle bindingHolder = DEUtil.getListingContainer((DesignElementHandle)handle);
                DataSetHandle itsDataSet = ((ReportItemHandle)handle).getDataSet();
                DataSetHandle dataSet = null;
                ReportItemHandle bindingRoot = DEUtil.getBindingRoot((DesignElementHandle)handle);
                if (bindingRoot != null) {
                    dataSet = bindingRoot.getDataSet();
                }
                return itsDataSet == null && (bindingHolder == null || !bindingHolder.getColumnBindings().iterator().hasNext()) || insertObj.getElementHandle().equals(dataSet);
            }
        }
        return false;
    }

    private static boolean isMasterPageHeaderOrFooter(Object obj) {
        if (!(obj instanceof SlotHandle)) {
            return false;
        }
        return ((SlotHandle)obj).getElementHandle() instanceof MasterPageHandle;
    }

    protected static boolean handleValidateParameter(EditPart target) {
        return InsertInLayoutUtil.handleValidateParameterDropContainer(target) && DNDUtil.handleValidateTargetCanContainType((Object)target.getModel(), (String)"Data");
    }

    public static boolean handleValidateInsert(Object insertObj) {
        if (insertObj instanceof Object[]) {
            Object[] array = (Object[])insertObj;
            if (array.length == 0) {
                return false;
            }
            int i = 0;
            while (i < array.length) {
                if (!InsertInLayoutUtil.handleValidateInsert(array[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (insertObj instanceof IStructuredSelection) {
            return InsertInLayoutUtil.handleValidateInsert(((IStructuredSelection)insertObj).toArray());
        }
        if (insertObj instanceof DataSetHandle) {
            return DataSetUIUtil.hasMetaData((DataSetHandle)insertObj);
        }
        return insertObj instanceof ResultSetColumnHandle || insertObj instanceof ScalarParameterHandle || insertObj instanceof DimensionHandle || insertObj instanceof MeasureHandle;
    }

    protected static void insertToCell(DataSetHandle model, TableHandle tableHandle, SlotHandle slot, ResultSetColumnHandle[] columns, boolean isLabel) {
        int i = 0;
        while (i < slot.getCount()) {
            SlotHandle cells = ((RowHandle)slot.get(i)).getCells();
            int j = 0;
            while (j < cells.getCount()) {
                CellHandle cell = (CellHandle)cells.get(j);
                try {
                    if (isLabel) {
                        String displayKey;
                        LabelHandle labelItemHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().getElementFactory().newLabel(null);
                        String labelText = UIUtil.getColumnDisplayName(columns[j]);
                        if (labelText != null) {
                            labelItemHandle.setText(labelText);
                        }
                        if ((displayKey = UIUtil.getColumnDisplayNameKey(columns[j])) != null) {
                            labelItemHandle.setTextKey(displayKey);
                        }
                        cell.addElement((DesignElementHandle)labelItemHandle, cells.getSlotID());
                    } else {
                        DataItemHandle dataHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().getElementFactory().newDataItem(null);
                        dataHandle.setResultSetColumn(columns[j].getColumnName());
                        boolean wordWrap = UIUtil.isWordWrap(columns[j]);
                        if (wordWrap) {
                            dataHandle.getPrivateStyle().setWhiteSpace("normal");
                        } else {
                            dataHandle.getPrivateStyle().setWhiteSpace("nowrap");
                        }
                        cell.addElement((DesignElementHandle)dataHandle, cells.getSlotID());
                        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)columns[j].getColumnName());
                        bindingColumn.setDataType(columns[j].getDataType());
                        ExpressionUtility.setBindingColumnExpression(columns[j], bindingColumn);
                        bindingColumn.setDisplayName(UIUtil.getColumnDisplayName(columns[j]));
                        String displayKey = UIUtil.getColumnDisplayNameKey(columns[j]);
                        if (displayKey != null) {
                            bindingColumn.setDisplayNameID(displayKey);
                        }
                        tableHandle.addColumnBinding(bindingColumn, false);
                        ActionHandle actionHandle = UIUtil.getColumnAction(columns[j]);
                        if (actionHandle != null) {
                            ArrayList<IStructure> source = new ArrayList<IStructure>();
                            source.add(actionHandle.getStructure());
                            ArrayList newAction = ModelUtil.cloneStructList(source);
                            dataHandle.setAction((Action)newAction.get(0));
                        }
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void setInitWidth(Object object) {
    }

    protected static boolean isHandleValid(DesignElementHandle handle) {
        if (handle instanceof DataSetHandle && (!(handle instanceof JointDataSetHandle) && !(handle instanceof DerivedDataSetHandle) && ((DataSetHandle)handle).getDataSource() == null || !DataSetUIUtil.hasMetaData((DataSetHandle)handle))) {
            return false;
        }
        return handle.isValid() && handle.getSemanticErrors().isEmpty();
    }

    public static IStructuredSelection editPart2Model(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return new StructuredSelection(Collections.EMPTY_LIST);
        }
        List list = ((IStructuredSelection)selection).toList();
        ArrayList<Object> resultList = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof ReportElementEditPart) {
                Object model = ((ReportElementEditPart)((Object)obj)).getModel();
                if (model instanceof ListBandProxy) {
                    model = ((ListBandProxy)model).getSlotHandle();
                }
                resultList.add(model);
            }
            ++i;
        }
        return new StructuredSelection(resultList);
    }

    public static IStructuredSelection editPart2Model(List selection) {
        if (selection == null || selection.size() == 0) {
            return new StructuredSelection(Collections.EMPTY_LIST);
        }
        List list = selection;
        ArrayList<Object> resultList = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof ReportElementEditPart) {
                Object model = ((ReportElementEditPart)((Object)obj)).getModel();
                if (model instanceof ListBandProxy) {
                    model = ((ListBandProxy)model).getSlotHandle();
                }
                resultList.add(model);
            }
            ++i;
        }
        return new StructuredSelection(resultList);
    }

    static class GroupKeySetRule
    implements InsertInLayoutRule {
        private Object container;
        private ResultSetColumnHandle dataSetColumn;

        public GroupKeySetRule(Object container, ResultSetColumnHandle dataSetColumn) {
            this.container = container;
            this.dataSetColumn = dataSetColumn;
        }

        public boolean canInsert() {
            return this.getGroupContainer(this.container) != null && this.getGroupHandle(this.container).getKeyExpr() == null && (this.getGroupContainer(this.container).getDataSet() == this.getDataSetHandle(this.dataSetColumn) || this.getGroupContainer(this.container).getDataSet() == null);
        }

        public Object getInsertPosition() {
            return null;
        }

        public void insert(Object object) throws SemanticException {
            Assert.isTrue((boolean)(object instanceof ResultSetColumnHandle));
            Assert.isTrue((object == this.dataSetColumn || object == null ? 1 : 0) != 0);
            ReportItemHandle groupContainer = this.getGroupContainer(this.container);
            DataSetHandle dataSetHandle = null;
            dataSetHandle = groupContainer.getDataSet();
            if (dataSetHandle == null) {
                ReportItemHandle elementHandle = groupContainer;
                while (elementHandle != null) {
                    if (elementHandle instanceof ListingHandle && (dataSetHandle = ((ListingHandle)elementHandle).getDataSet()) != null && dataSetHandle == this.getDataSetHandle(this.dataSetColumn)) break;
                    elementHandle = elementHandle.getContainer();
                }
            }
            if (dataSetHandle == null || dataSetHandle != this.getDataSetHandle(this.dataSetColumn)) {
                this.getGroupContainer(this.container).setDataSet(this.getDataSetHandle(this.dataSetColumn));
            }
            this.getGroupHandle(this.container).setKeyExpr(DEUtil.getColumnExpression((String)this.dataSetColumn.getColumnName()));
        }

        protected DataSetHandle getDataSetHandle(ResultSetColumnHandle model) {
            return (DataSetHandle)model.getElementHandle();
        }

        protected GroupHandle getGroupHandle(Object target) {
            DesignElementHandle handle = null;
            if (target instanceof CellHandle) {
                handle = ((CellHandle)target).getContainer().getContainer();
            } else if (target instanceof ListBandProxy) {
                handle = ((ListBandProxy)target).getElemtHandle();
            }
            if (handle instanceof GroupHandle) {
                return (GroupHandle)handle;
            }
            return null;
        }

        protected ReportItemHandle getGroupContainer(Object target) {
            GroupHandle group = this.getGroupHandle(target);
            if (group != null && group.getContainer() instanceof ReportItemHandle) {
                return (ReportItemHandle)group.getContainer();
            }
            return null;
        }
    }

    static interface InsertInLayoutRule {
        public boolean canInsert();

        public Object getInsertPosition();

        public void insert(Object var1) throws SemanticException;
    }

    static class LabelAddRule
    implements InsertInLayoutRule {
        private Object container;
        private CellHandle newTarget;

        public LabelAddRule(Object container) {
            this.container = container;
        }

        public boolean canInsert() {
            if (this.container instanceof SlotHandle) {
                this.container = ((SlotHandle)this.container).getElementHandle();
            }
            if (!(this.container instanceof CellHandle)) {
                return false;
            }
            CellHandle cell = (CellHandle)this.container;
            boolean canInsert = false;
            if (cell.getContainer().getContainer() instanceof TableGroupHandle) {
                canInsert = true;
            } else if (cell.getContainer().getContainerSlotHandle().getSlotID() == 2) {
                canInsert = true;
            }
            if (canInsert) {
                TableHandle table = null;
                table = cell.getContainer().getContainer() instanceof TableHandle ? (TableHandle)cell.getContainer().getContainer() : (TableHandle)cell.getContainer().getContainer().getContainer();
                SlotHandle header = table.getHeader();
                if (header != null && header.getCount() > 0) {
                    int columnNum = HandleAdapterFactory.getInstance().getCellHandleAdapter((Object)cell).getColumnNumber();
                    this.newTarget = (CellHandle)HandleAdapterFactory.getInstance().getTableHandleAdapter((Object)table).getCell(1, columnNum, false);
                    return this.newTarget != null && this.newTarget.getContent().getCount() == 0;
                }
            }
            return false;
        }

        public Object getInsertPosition() {
            return this.newTarget;
        }

        public void insert(Object object) throws SemanticException {
            Assert.isTrue((boolean)(object instanceof DesignElementHandle));
            this.newTarget.addElement((DesignElementHandle)object, 0);
        }
    }

    static class MultiItemsExpandRule
    implements InsertInLayoutRule {
        private Object[] items;
        private Object target;
        private int focusIndex = 0;

        public MultiItemsExpandRule(Object[] items, Object target) {
            this.items = items;
            this.target = target;
        }

        public boolean canInsert() {
            return this.items != null && this.items.length > 1 && this.target != null && (this.target instanceof DesignElementHandle || this.target instanceof ListBandProxy);
        }

        public Object getInsertPosition() {
            Object[] positions = new Object[this.items.length];
            if (this.target instanceof CellHandle) {
                CellHandle firstCell = (CellHandle)this.target;
                TableHandleAdapter tableAdapter = HandleAdapterFactory.getInstance().getTableHandleAdapter((Object)this.getTableHandle(firstCell));
                int currentColumn = HandleAdapterFactory.getInstance().getCellHandleAdapter((Object)firstCell).getColumnNumber();
                int currentRow = HandleAdapterFactory.getInstance().getCellHandleAdapter((Object)firstCell).getRowNumber();
                int columnDiff = currentColumn + this.items.length - tableAdapter.getColumnCount() - 1;
                if (columnDiff > 0) {
                    int insertColumn = tableAdapter.getColumnCount();
                    try {
                        tableAdapter.insertColumns(columnDiff, insertColumn);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                        return null;
                    }
                }
                int i = 0;
                while (i < positions.length) {
                    positions[i] = tableAdapter.getCell(currentRow, currentColumn++);
                    ++i;
                }
                this.focusIndex = 0;
            } else {
                int i = 0;
                while (i < positions.length) {
                    positions[i] = this.target;
                    ++i;
                }
                this.focusIndex = this.items.length - 1;
            }
            return positions;
        }

        protected TableHandle getTableHandle(CellHandle firstCell) {
            DesignElementHandle tableContainer = firstCell.getContainer().getContainer();
            if (tableContainer instanceof TableHandle) {
                return (TableHandle)tableContainer;
            }
            return (TableHandle)tableContainer.getContainer();
        }

        public int getFocusIndex() {
            return this.focusIndex;
        }

        public void insert(Object object) throws SemanticException {
        }
    }
}

