/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.expressions.ExpressionSupportManager;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionSupport;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

public class ExpressionUtility {
    private static final String STRING_ROW = "row";
    private static final int EXPR_CACHE_SIZE = 50;
    private static Map compiledExprCache = Collections.synchronizedMap(new LinkedHashMap(50, 0.75f, true){
        private static final long serialVersionUID = 54331232145454L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 50;
        }
    });

    public static boolean isColumnExpression(String expression) {
        ScriptOrFnNode tree;
        boolean isColumn = false;
        if (expression == null || expression.trim().length() == 0) {
            return isColumn;
        }
        if (compiledExprCache.containsKey(expression)) {
            return (Boolean)compiledExprCache.get(expression);
        }
        Context context = Context.enter();
        try {
            try {
                CompilerEnvirons m_compilerEnv = new CompilerEnvirons();
                m_compilerEnv.initFromContext(context);
                Parser p = new Parser(m_compilerEnv, context.getErrorReporter());
                tree = p.parse(expression, null, 0);
            }
            catch (Exception exception) {
                compiledExprCache.put(expression, false);
                Context.exit();
                return false;
            }
        }
        finally {
            Context.exit();
        }
        if (tree.getFirstChild() == tree.getLastChild()) {
            if (tree.getFirstChild().getType() != 133 && tree.getFirstChild().getType() != 132 && tree.getFirstChild().getType() != 128) {
                isColumn = false;
            }
            Node exprNode = tree.getFirstChild();
            Node child = exprNode.getFirstChild();
            assert (child != null);
            isColumn = child.getType() == 36 || child.getType() == 33 ? ExpressionUtility.getDirectColRefExpr(child) : false;
        } else {
            isColumn = false;
        }
        compiledExprCache.put(expression, isColumn);
        return isColumn;
    }

    public static String getReplacedColRefExpr(String columnStr) {
        if (ExpressionUtility.isColumnExpression(columnStr)) {
            return columnStr.replaceFirst("\\Qrow\\E", "dataSetRow");
        }
        return columnStr;
    }

    private static boolean getDirectColRefExpr(Node refNode) {
        assert (refNode.getType() == 33 || refNode.getType() == 36);
        Node rowName = refNode.getFirstChild();
        assert (rowName != null);
        if (rowName.getType() != 39) {
            return false;
        }
        String str = rowName.getString();
        assert (str != null);
        if (!str.equals(STRING_ROW)) {
            return false;
        }
        Node rowColumn = rowName.getNext();
        assert (rowColumn != null);
        if (refNode.getType() == 33 && rowColumn.getType() == 41) {
            return true;
        }
        return refNode.getType() == 36 && (rowColumn.getType() == 40 || rowColumn.getType() == 41);
    }

    public static String getExpression(Object model, IExpressionConverter converter) {
        if (model instanceof ComputedColumnHandle) {
            if (DEUtil.isBindingCube((DesignElementHandle)((ComputedColumnHandle)model).getElementHandle())) {
                return ExpressionUtility.getDataExpression(((ComputedColumnHandle)model).getName(), converter);
            }
            return ExpressionUtility.getColumnExpression(((ComputedColumnHandle)model).getName(), converter);
        }
        if (model instanceof ResultSetColumnHandle) {
            return ExpressionUtility.getDataSetRowExpression(((ResultSetColumnHandle)model).getColumnName(), converter);
        }
        if (model instanceof ParameterHandle) {
            return ExpressionUtility.getParameterExpression(((ParameterHandle)model).getQualifiedName(), converter);
        }
        return null;
    }

    public static String getFilterExpression(Object model, String value, IExpressionConverter converter) {
        if (model instanceof CubeHandle) {
            return ExpressionUtility.getDataSetRowExpression(value, converter);
        }
        return ExpressionUtility.getColumnExpression(value, converter);
    }

    public static String getDataSetRowExpression(String columnName, IExpressionConverter converter) {
        if (StringUtil.isBlank((String)columnName) || converter == null) {
            return null;
        }
        return converter.getResultSetColumnExpression(columnName);
    }

    public static String getParameterExpression(String columnName, IExpressionConverter converter) {
        if (StringUtil.isBlank((String)columnName) || converter == null) {
            return null;
        }
        return converter.getParameterExpression(columnName);
    }

    public static String getColumnExpression(String columnName, IExpressionConverter converter) {
        if (StringUtil.isBlank((String)columnName) || converter == null) {
            return null;
        }
        return converter.getBindingExpression(columnName);
    }

    public static String getDataExpression(String columnName, IExpressionConverter converter) {
        if (StringUtil.isBlank((String)columnName) || converter == null) {
            return null;
        }
        return converter.getCubeBindingExpression(columnName);
    }

    public static String getResultSetColumnExpression(String columnName, IExpressionConverter converter) {
        if (StringUtil.isBlank((String)columnName) || converter == null) {
            return null;
        }
        return converter.getResultSetColumnExpression(columnName);
    }

    public static IExpressionConverter getExpressionConverter(String scriptType) {
        IExpressionSupport[] exts = ExpressionSupportManager.getExpressionSupports();
        if (exts != null) {
            IExpressionSupport[] iExpressionSupportArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExpressionSupport ex = iExpressionSupportArray[n2];
                if (ex != null && ex.getName() != null && ex.getName().equals(scriptType)) {
                    return ex.getConverter();
                }
                ++n2;
            }
        }
        return null;
    }

    public static void setBindingColumnExpression(Object element, ComputedColumn bindingColumn) {
        ExpressionUtility.setBindingColumnExpression(element, bindingColumn, false);
    }

    public static void setBindingColumnExpression(Object element, ComputedColumn bindingColumn, boolean isOnlySupportJS) {
        String defaultScriptType = UIUtil.getDefaultScriptType();
        IExpressionConverter converter = ExpressionUtility.getExpressionConverter(defaultScriptType);
        String expression = null;
        if (converter != null && !isOnlySupportJS) {
            expression = ExpressionUtility.getExpression(element, converter);
        } else {
            defaultScriptType = "javascript";
            expression = DEUtil.getExpression((Object)element);
        }
        Expression bindingExpression = new Expression((Object)expression, defaultScriptType);
        bindingColumn.setExpressionProperty("expression", bindingExpression);
    }
}

