/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util.graphics;

import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.TransformUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class ImageCanvas
extends Canvas {
    private static final float ZOOMIN_RATE = 1.1f;
    private static final float ZOOMOUT_RATE = 0.9f;
    private Image sourceImage;
    private Image screenImage;
    private AffineTransform transform = new AffineTransform();

    public ImageCanvas(Composite parent) {
        this(parent, 0);
        this.initAccessible();
    }

    public ImageCanvas(Composite parent, int style) {
        super(parent, style);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ImageCanvas.this.syncScrollBars();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ImageCanvas.this.paint(event.gc);
            }
        });
        this.initScrollBars();
        this.initAccessible();
    }

    void initAccessible() {
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = ImageCanvas.this.toControl(e.x, e.y);
                if (ImageCanvas.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ImageCanvas.this.getBounds();
                Point pt = ImageCanvas.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = "Preview Image";
            }
        });
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = "Preview Image";
            }

            public void getName(AccessibleEvent e) {
                e.result = "Preview Image";
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
    }

    public void dispose() {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
        }
        if (this.screenImage != null && !this.screenImage.isDisposed()) {
            this.screenImage.dispose();
        }
    }

    private void paint(GC gc) {
        Rectangle clientRect = this.getClientArea();
        if (this.sourceImage != null) {
            Rectangle imageRect = TransformUtil.inverseTransformRect(this.transform, clientRect);
            int gap = 2;
            imageRect.x -= gap;
            imageRect.y -= gap;
            imageRect.width += 2 * gap;
            imageRect.height += 2 * gap;
            Rectangle imageBound = this.sourceImage.getBounds();
            imageRect = imageRect.intersection(imageBound);
            Rectangle destRect = TransformUtil.transformRect(this.transform, imageRect);
            if (this.screenImage != null) {
                this.screenImage.dispose();
            }
            this.screenImage = new Image((Device)this.getDisplay(), clientRect.width, clientRect.height);
            GC newGC = new GC((Drawable)this.screenImage);
            newGC.setClipping(clientRect);
            newGC.drawImage(this.sourceImage, imageRect.x, imageRect.y, imageRect.width, imageRect.height, destRect.x, destRect.y, destRect.width, destRect.height);
            newGC.dispose();
            gc.drawImage(this.screenImage, 0, 0);
        } else {
            gc.setClipping(clientRect);
            gc.fillRectangle(clientRect);
            this.initScrollBars();
        }
    }

    private void initScrollBars() {
        ScrollBar vertical;
        ScrollBar horizontal = this.getHorizontalBar();
        if (horizontal != null) {
            horizontal.setEnabled(false);
            horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ImageCanvas.this.scrollHorizontally((ScrollBar)event.widget);
                }
            });
        }
        if ((vertical = this.getVerticalBar()) != null) {
            vertical.setEnabled(false);
            vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ImageCanvas.this.scrollVertically((ScrollBar)event.widget);
                }
            });
        }
    }

    private void scrollHorizontally(ScrollBar scrollBar) {
        if (this.sourceImage == null) {
            return;
        }
        AffineTransform af = this.transform;
        double tx = af.getTranslateX();
        double select = -scrollBar.getSelection();
        af.preConcatenate(AffineTransform.getTranslateInstance(select - tx, 0.0));
        this.transform = af;
        this.syncScrollBars();
    }

    private void scrollVertically(ScrollBar scrollBar) {
        if (this.sourceImage == null) {
            return;
        }
        AffineTransform af = this.transform;
        double ty = af.getTranslateY();
        double select = -scrollBar.getSelection();
        af.preConcatenate(AffineTransform.getTranslateInstance(0.0, select - ty));
        this.transform = af;
        this.syncScrollBars();
    }

    public Image getSourceImage() {
        return this.sourceImage;
    }

    public void syncScrollBars() {
        ScrollBar vertical;
        if (this.sourceImage == null) {
            this.redraw();
            return;
        }
        AffineTransform af = this.transform;
        double sx = af.getScaleX();
        double sy = af.getScaleY();
        double tx = af.getTranslateX();
        double ty = af.getTranslateY();
        if (tx > 0.0) {
            tx = 0.0;
        }
        if (ty > 0.0) {
            ty = 0.0;
        }
        Rectangle imageBound = this.sourceImage.getBounds();
        int cw = this.getClientArea().width;
        int ch = this.getClientArea().height;
        ScrollBar horizontal = this.getHorizontalBar();
        if (horizontal != null) {
            horizontal.setIncrement(this.getClientArea().width / 100);
            horizontal.setPageIncrement(this.getClientArea().width);
            if ((double)imageBound.width * sx > (double)cw) {
                horizontal.setMaximum((int)((double)imageBound.width * sx));
                horizontal.setEnabled(true);
                if ((int)(-tx) > horizontal.getMaximum() - cw) {
                    tx = -horizontal.getMaximum() + cw;
                }
            } else {
                horizontal.setEnabled(false);
                tx = ((double)cw - (double)imageBound.width * sx) / 2.0;
            }
            horizontal.setSelection((int)(-tx));
            horizontal.setThumb(this.getClientArea().width);
        }
        if ((vertical = this.getVerticalBar()) != null) {
            vertical.setIncrement(this.getClientArea().height / 100);
            vertical.setPageIncrement(this.getClientArea().height);
            if ((double)imageBound.height * sy > (double)ch) {
                vertical.setMaximum((int)((double)imageBound.height * sy));
                vertical.setEnabled(true);
                if ((int)(-ty) > vertical.getMaximum() - ch) {
                    ty = -vertical.getMaximum() + ch;
                }
            } else {
                vertical.setEnabled(false);
                ty = ((double)ch - (double)imageBound.height * sy) / 2.0;
            }
            vertical.setSelection((int)(-ty));
            vertical.setThumb(this.getClientArea().height);
        }
        af = AffineTransform.getScaleInstance(sx, sy);
        af.preConcatenate(AffineTransform.getTranslateInstance(tx, ty));
        this.transform = af;
        this.redraw();
    }

    public Image loadImage(String filename) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        this.sourceImage = new Image((Device)this.getDisplay(), filename);
        if (this.sourceImage.getBounds().width > this.getBounds().width || this.sourceImage.getBounds().height > this.getBounds().height) {
            this.fitCanvas();
        } else {
            this.showOriginal();
        }
        return this.sourceImage;
    }

    public Image loadImage(byte[] data) {
        return this.loadImage(new ByteArrayInputStream(data));
    }

    public Image loadImage(Image img) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        if (img == null) {
            this.sourceImage = null;
            this.redraw();
            return null;
        }
        this.sourceImage = new Image((Device)this.getDisplay(), img.getImageData());
        if (this.sourceImage.getBounds().width > this.getBounds().width || this.sourceImage.getBounds().height > this.getBounds().height) {
            this.fitCanvas();
        } else {
            this.showOriginal();
        }
        return this.sourceImage;
    }

    public Image loadImage(InputStream is) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        this.sourceImage = new Image((Device)this.getDisplay(), is);
        if (this.sourceImage.getBounds().width > this.getBounds().width || this.sourceImage.getBounds().height > this.getBounds().height) {
            this.fitCanvas();
        } else {
            this.showOriginal();
        }
        return this.sourceImage;
    }

    public Image loadImage(URL url) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        this.sourceImage = ImageDescriptor.createFromURL((URL)url).createImage();
        if (this.sourceImage.getBounds().width > this.getBounds().width || this.sourceImage.getBounds().height > this.getBounds().height) {
            this.fitCanvas();
        } else {
            this.showOriginal();
        }
        return this.sourceImage;
    }

    public void setImageData(ImageData data) {
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        if (data != null) {
            this.sourceImage = new Image((Device)this.getDisplay(), data);
        }
        this.syncScrollBars();
    }

    public void fitCanvas() {
        if (this.sourceImage == null) {
            return;
        }
        Rectangle imageBound = this.sourceImage.getBounds();
        Rectangle destRect = this.getClientArea();
        double sx = (double)destRect.width / (double)imageBound.width;
        double sy = (double)destRect.height / (double)imageBound.height;
        double s = Math.min(sx, sy);
        double dx = 0.5 * (double)destRect.width;
        double dy = 0.5 * (double)destRect.height;
        this.centerZoom(dx, dy, s, new AffineTransform());
    }

    public void showOriginal() {
        if (this.sourceImage == null) {
            return;
        }
        this.transform = new AffineTransform();
        this.syncScrollBars();
    }

    public void clear() {
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        GC clearGC = new GC((Drawable)this);
        this.paint(clearGC);
        clearGC.dispose();
    }

    public void centerZoom(double dx, double dy, double scale, AffineTransform af) {
        af.preConcatenate(AffineTransform.getTranslateInstance(-dx, -dy));
        af.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
        af.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
        this.transform = af;
        this.syncScrollBars();
    }

    public void zoomIn() {
        if (this.sourceImage == null) {
            return;
        }
        Rectangle rect = this.getClientArea();
        int w = rect.width;
        int h = rect.height;
        double dx = (double)w / 2.0;
        double dy = (double)h / 2.0;
        this.centerZoom(dx, dy, 1.1f, this.transform);
    }

    public void zoomOut() {
        if (this.sourceImage == null) {
            return;
        }
        Rectangle rect = this.getClientArea();
        int w = rect.width;
        int h = rect.height;
        double dx = (double)w / 2.0;
        double dy = (double)h / 2.0;
        this.centerZoom(dx, dy, 0.9f, this.transform);
    }
}

