/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.validation.caret;

import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.DefaultPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.w3c.dom.Node;

class BasicPositionRule
extends DefaultPositionRule {
    private final IPositionMediator _mediator;

    public BasicPositionRule(IPositionMediator mediator, ActionData actionData) {
        super(actionData);
        this._mediator = mediator;
    }

    public boolean hasEditableArea(Target target) {
        if (target == null || target.getPart() == null) {
            return false;
        }
        if (!EditValidateUtil.validNode(target.getNode())) {
            return false;
        }
        return !DefaultPositionRule.isWidget(target.getPart());
    }

    public boolean isEditable(Target target) {
        if (target.getPart() == null) {
            return false;
        }
        Node node = target.getNode();
        if (EditModelQuery.isText(node)) {
            return this._mediator.isEditable(new Target(node.getParentNode()));
        }
        String name = node.getLocalName();
        if (name == null && !EditModelQuery.isDocument(node) && !EditModelQuery.isText(node)) {
            return false;
        }
        return !DefaultPositionRule.isWidget(target.getPart());
    }

    public boolean canReference(Target target, boolean atRight) {
        Node node = target.getNode();
        return target.getPart() != null && (node.getNodeType() == 1 || EditModelQuery.isText(node));
    }
}

