/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.editor;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.wst.sse.core.internal.util.JarUtilities;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CMImageUtil {
    public static String SMALL_ICON_URL = "small-icon";

    public static CMNode getDeclaration(Node node) {
        CMElementDeclaration decl = null;
        ModelQuery mq = null;
        switch (node.getNodeType()) {
            case 2: {
                mq = ModelQueryUtil.getModelQuery((Document)((Attr)node).getOwnerDocument());
                decl = mq.getCMAttributeDeclaration((Attr)node);
                break;
            }
            case 1: {
                mq = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
                decl = mq.getCMElementDeclaration((Element)node);
            }
        }
        return decl;
    }

    public static Image getImage(CMNode cmnode) {
        if (cmnode == null) {
            return null;
        }
        Image image = null;
        ImageDescriptor descriptor = CMImageUtil.getImageDescriptor(cmnode);
        if (descriptor != null) {
            image = descriptor.createImage(false);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(CMNode cmnode) {
        if (cmnode == null) {
            return null;
        }
        String imageURLString = (String)cmnode.getProperty(SMALL_ICON_URL);
        ImageDescriptor descriptor = null;
        if (imageURLString != null && imageURLString.length() > 0 && (descriptor = XMLUIPlugin.getInstance().getImageRegistry().getDescriptor(imageURLString)) == null) {
            try {
                URL imageURL = new URL(imageURLString);
                InputStream inputStream = JarUtilities.getInputStream((URL)imageURL);
                try {
                    ImageData data = new ImageData(inputStream);
                    descriptor = ImageDescriptor.createFromImageData((ImageData)data);
                    XMLUIPlugin.getInstance().getImageRegistry().put(imageURLString, descriptor);
                }
                catch (SWTException sWTException) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                descriptor = null;
            }
            catch (IOException iOException) {
                descriptor = null;
            }
        }
        return descriptor;
    }

    private CMImageUtil() {
    }
}

