/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.MetaDataPopulator;
import org.eclipse.birt.report.data.adapter.impl.QueryExecutionHelper;
import org.eclipse.birt.report.data.adapter.impl.ResultMetaData;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.CompatibilityUtil;

public class DataSetMetaDataHelper {
    private DataEngine dataEngine;
    private IModelAdapter modelAdaptor;
    private DataSessionContext sessionContext;
    private DataRequestSession session;

    DataSetMetaDataHelper(DataEngine dataEngine, IModelAdapter modelAdaptor, DataSessionContext sessionContext, DataRequestSession session) {
        this.dataEngine = dataEngine;
        this.modelAdaptor = modelAdaptor;
        this.sessionContext = sessionContext;
        this.session = session;
    }

    IResultMetaData getDataSetMetaData(DataSetHandle dataSetHandle, boolean useCache) throws BirtException {
        if (dataSetHandle == null) {
            throw new AdapterException("datasethandle.null.error");
        }
        if (useCache) {
            return this.getCachedMetaData(dataSetHandle.getCachedMetaDataHandle());
        }
        return this.getRealMetaData(dataSetHandle);
    }

    private IResultMetaData getCachedMetaData(CachedMetaDataHandle cmdHandle) throws BirtException {
        if (cmdHandle == null) {
            return null;
        }
        Iterator it = cmdHandle.getResultSet().iterator();
        ArrayList<ColumnDefinition> columnMeta = new ArrayList<ColumnDefinition>();
        while (it.hasNext()) {
            ResultSetColumnHandle rsColumn = (ResultSetColumnHandle)it.next();
            ColumnDefinition cd = this.modelAdaptor.ColumnAdaptor(rsColumn);
            columnMeta.add(cd);
        }
        return new ResultMetaData(columnMeta);
    }

    private IResultMetaData getRealMetaData(DataSetHandle dataSetHandle) throws BirtException {
        IResultMetaData metaData = MetaDataPopulator.retrieveResultMetaData(dataSetHandle);
        if (metaData == null) {
            metaData = this.getRuntimeMetaData(dataSetHandle);
        }
        if (metaData != null && !(dataSetHandle instanceof ScriptDataSetHandle)) {
            this.clearUnusedData(dataSetHandle, metaData);
        }
        return metaData;
    }

    private IResultMetaData getRuntimeMetaData(DataSetHandle dataSetHandle) throws BirtException {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataSetHandle.getQualifiedName());
        query.setMaxRows(1);
        query.setAutoBinding(true);
        IResultMetaData metaData = new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.sessionContext, false, this.session).executeQuery((IQueryDefinition)query).getResultMetaData();
        this.addResultSetColumn(dataSetHandle, metaData);
        if (MetaDataPopulator.needsUseResultHint(dataSetHandle, metaData)) {
            metaData = new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.sessionContext, true, this.session).executeQuery((IQueryDefinition)query).getResultMetaData();
        }
        return metaData;
    }

    private void addResultSetColumn(DataSetHandle dataSetHandle, IResultMetaData meta) throws BirtException {
        if (meta == null || !(dataSetHandle instanceof OdaDataSetHandle)) {
            return;
        }
        HashSet<String> computedColumnNameSet = new HashSet<String>();
        Iterator computedIter = dataSetHandle.computedColumnsIterator();
        while (computedIter.hasNext()) {
            ComputedColumnHandle handle = (ComputedColumnHandle)computedIter.next();
            computedColumnNameSet.add(handle.getName());
        }
        ArrayList<OdaResultSetColumn> columnList = new ArrayList<OdaResultSetColumn>();
        HashSet orgColumnNameSet = new HashSet();
        HashSet<String> uniqueColumnNameSet = new HashSet<String>();
        int i = 1;
        while (i <= meta.getColumnCount()) {
            OdaResultSetColumn rsColumn = new OdaResultSetColumn();
            if (!computedColumnNameSet.contains(meta.getColumnName(i))) {
                String uniqueName = MetaDataPopulator.getUniqueName(orgColumnNameSet, uniqueColumnNameSet, meta.getColumnName(i), i - 1);
                rsColumn.setColumnName(uniqueName);
                if (meta.getColumnType(i) != 0) {
                    rsColumn.setDataType(DataAdapterUtil.adapterToModelDataType(meta.getColumnType(i)));
                }
                rsColumn.setNativeName(meta.getColumnName(i));
                rsColumn.setPosition(new Integer(i));
                columnList.add(rsColumn);
                uniqueColumnNameSet.add(uniqueName);
            }
            ++i;
        }
        CompatibilityUtil.addResultSetColumn((DataSetHandle)dataSetHandle, columnList);
    }

    private final void clearUnusedData(DataSetHandle dataSetHandle, IResultMetaData metaData) throws BirtException {
        this.clearUnusedColumnHints(dataSetHandle, metaData);
    }

    private final void clearUnusedColumnHints(DataSetHandle dataSetHandle, IResultMetaData metaData) throws BirtException {
        PropertyHandle handle = dataSetHandle.getPropertyHandle("columnHints");
        if (handle != null && handle.getListValue() != null) {
            ArrayList list = handle.getListValue();
            int count = list.size();
            int n = count - 1;
            while (n >= 0) {
                ColumnHint hint = (ColumnHint)list.get(n);
                String columnName = (String)hint.getProperty(handle.getModule(), "columnName");
                boolean found = false;
                if (!this.isEmpty(hint, handle.getModule().getModuleHandle())) {
                    int m = 0;
                    while (m < metaData.getColumnCount() && !found) {
                        found = columnName.equals(metaData.getColumnName(m + 1));
                        ++m;
                    }
                }
                if (!found) {
                    try {
                        handle.removeItem((Object)hint);
                    }
                    catch (PropertyValueException propertyValueException) {}
                }
                --n;
            }
        }
    }

    private boolean isEmpty(ColumnHint hint, ModuleHandle designHandle) {
        String alias = (String)hint.getProperty(designHandle.getModule(), "alias");
        String displayName = (String)hint.getProperty(designHandle.getModule(), "displayName");
        String displayNameKey = (String)hint.getProperty(designHandle.getModule(), "displayNameID");
        String helpText = (String)hint.getProperty(designHandle.getModule(), "helpText");
        String analysis = (String)hint.getProperty(designHandle.getModule(), "analysis");
        return !(alias != null && alias.trim().length() != 0 || displayName != null && displayName.trim().length() != 0 || displayNameKey != null && displayNameKey.trim().length() != 0 || helpText != null && helpText.trim().length() != 0 || analysis != null && analysis.trim().length() != 0);
    }

    IResultMetaData refreshMetaData(DataSetHandle dataSetHandle) throws BirtException {
        return this.refreshMetaData(dataSetHandle, false);
    }

    IResultMetaData refreshMetaData(DataSetHandle dataSetHandle, boolean holdEvent) throws BirtException {
        IResultMetaData rsMeta = null;
        try {
            rsMeta = this.getDataSetMetaData(dataSetHandle, false);
        }
        catch (BirtException e1) {
            if (holdEvent || !dataSetHandle.canEdit()) {
                CompatibilityUtil.updateResultSetinCachedMetaData((DataSetHandle)dataSetHandle, new ArrayList());
            } else if (dataSetHandle.getCachedMetaDataHandle() != null) {
                dataSetHandle.getCachedMetaDataHandle().getResultSet().clearValue();
            } else {
                dataSetHandle.setCachedMetaData(StructureFactory.createCachedMetaData());
            }
            throw e1;
        }
        if (this.needsSetCachedMetaData(dataSetHandle, rsMeta)) {
            int i;
            ArrayList<ResultSetColumn> columnList = new ArrayList<ResultSetColumn>();
            if (rsMeta != null && rsMeta.getColumnCount() != 0) {
                i = 1;
                while (i <= rsMeta.getColumnCount()) {
                    ResultSetColumn rsc = StructureFactory.createResultSetColumn();
                    rsc.setColumnName(this.getColumnName(rsMeta, i));
                    if (rsMeta.getColumnType(i) != 0) {
                        rsc.setDataType(DataAdapterUtil.adapterToModelDataType(rsMeta.getColumnType(i)));
                    }
                    rsc.setPosition(new Integer(i));
                    columnList.add(rsc);
                    ++i;
                }
            }
            if (holdEvent || !dataSetHandle.canEdit()) {
                CompatibilityUtil.updateResultSetinCachedMetaData((DataSetHandle)dataSetHandle, columnList);
            } else if (dataSetHandle.getCachedMetaDataHandle() != null) {
                List resultSetColumnHandles = this.getResultSetColumnHandles(dataSetHandle.getCachedMetaDataHandle());
                int i2 = 0;
                while (i2 < columnList.size()) {
                    ResultSetColumn rsc = (ResultSetColumn)columnList.get(i2);
                    if (i2 < resultSetColumnHandles.size()) {
                        ResultSetColumnHandle rsh = (ResultSetColumnHandle)resultSetColumnHandles.get(i2);
                        if (!rsh.getColumnName().equals(rsc.getColumnName())) {
                            rsh.setColumnName(rsc.getColumnName());
                        }
                        if (!rsh.getDataType().equals(rsc.getDataType())) {
                            rsh.setDataType(rsc.getDataType());
                        }
                    } else {
                        dataSetHandle.getCachedMetaDataHandle().getResultSet().addItem((IStructure)rsc);
                    }
                    ++i2;
                }
                if (i2 < resultSetColumnHandles.size()) {
                    List toRemoved = resultSetColumnHandles.subList(i2, resultSetColumnHandles.size());
                    dataSetHandle.getCachedMetaDataHandle().getResultSet().removeItems(toRemoved);
                }
            } else {
                dataSetHandle.setCachedMetaData(StructureFactory.createCachedMetaData());
                i = 0;
                while (i < columnList.size()) {
                    dataSetHandle.getCachedMetaDataHandle().getResultSet().addItem((IStructure)((ResultSetColumn)columnList.get(i)));
                    ++i;
                }
            }
        }
        return rsMeta;
    }

    private boolean needsSetCachedMetaData(DataSetHandle dataSetHandle, IResultMetaData rsMeta) throws BirtException {
        if (dataSetHandle.getCachedMetaDataHandle() == null || rsMeta == null || rsMeta.getColumnCount() == 0) {
            return true;
        }
        List list = this.getResultSetColumnHandles(dataSetHandle.getCachedMetaDataHandle());
        if (list.size() != rsMeta.getColumnCount()) {
            return true;
        }
        int i = 1;
        while (i <= rsMeta.getColumnCount()) {
            ResultSetColumnHandle handle = (ResultSetColumnHandle)list.get(i - 1);
            if (handle.getColumnName() == null || !handle.getColumnName().equals(this.getColumnName(rsMeta, i)) || !handle.getDataType().equals(DataAdapterUtil.adapterToModelDataType(rsMeta.getColumnType(i)))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List getResultSetColumnHandles(CachedMetaDataHandle cmdh) {
        ArrayList list = new ArrayList();
        Iterator iter = cmdh.getResultSet().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    private String getColumnName(IResultMetaData rsMeta, int index) throws BirtException {
        return rsMeta.getColumnAlias(index) == null || rsMeta.getColumnAlias(index).trim().length() == 0 ? rsMeta.getColumnName(index) : rsMeta.getColumnAlias(index);
    }
}

