/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class GermanAnalyzer
extends Analyzer {
    public static final String[] GERMAN_STOP_WORDS = new String[]{"einer", "eine", "eines", "einem", "einen", "der", "die", "das", "dass", "da\u00df", "du", "er", "sie", "es", "was", "wer", "wie", "wir", "und", "oder", "ohne", "mit", "am", "im", "in", "aus", "auf", "ist", "sein", "war", "wird", "ihr", "ihre", "ihres", "als", "f\u00fcr", "von", "mit", "dich", "dir", "mich", "mir", "mein", "sein", "kein", "durch", "wegen", "wird"};
    private Set stopSet = new HashSet();
    private Set exclusionSet = new HashSet();

    public GermanAnalyzer() {
        this.stopSet = StopFilter.makeStopSet((String[])GERMAN_STOP_WORDS);
    }

    public GermanAnalyzer(String[] stopwords) {
        this.stopSet = StopFilter.makeStopSet((String[])stopwords);
    }

    public GermanAnalyzer(Hashtable stopwords) {
        this.stopSet = new HashSet(stopwords.keySet());
    }

    public GermanAnalyzer(File stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet((File)stopwords);
    }

    public void setStemExclusionTable(String[] exclusionlist) {
        this.exclusionSet = StopFilter.makeStopSet((String[])exclusionlist);
    }

    public void setStemExclusionTable(Hashtable exclusionlist) {
        this.exclusionSet = new HashSet(exclusionlist.keySet());
    }

    public void setStemExclusionTable(File exclusionlist) throws IOException {
        this.exclusionSet = WordlistLoader.getWordSet((File)exclusionlist);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(reader);
        result = new StandardFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopSet);
        result = new GermanStemFilter((TokenStream)result, this.exclusionSet);
        return result;
    }
}

