/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetIterator<E>
implements Iterator<E> {
    private final ResultSet resultSet;
    private final Adapter<E> adapter;
    private E next;
    private boolean done;

    public ResultSetIterator(ResultSet resultSet, Adapter<E> adapter) {
        this.resultSet = resultSet;
        this.adapter = adapter;
        this.done = false;
        this.next = this.buildNext();
    }

    public ResultSetIterator(ResultSet resultSet) {
        this(resultSet, Adapter.Default.instance());
    }

    private E buildNext() {
        try {
            if (this.resultSet.next()) {
                return this.buildNext(this.resultSet);
            }
            this.resultSet.close();
            this.done = true;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    protected E buildNext(ResultSet rs) throws SQLException {
        return this.adapter.buildNext(rs);
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public E next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        E temp = this.next;
        this.next = this.buildNext();
        return temp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.resultSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Adapter<T> {
        public T buildNext(ResultSet var1) throws SQLException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Default<S>
        implements Adapter<S> {
            public static final Adapter INSTANCE = new Default();
            private static final long serialVersionUID = 1L;

            public static <R> Adapter<R> instance() {
                return INSTANCE;
            }

            private Default() {
            }

            @Override
            public S buildNext(ResultSet rs) throws SQLException {
                return (S)rs.getObject(1);
            }

            public String toString() {
                return "ResultSetIterator.Adapter.Default";
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }
    }
}

