/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MultiSelectionAttributeEditor
extends AbstractAttributeEditor {
    private String[] allValues;
    private Text text;
    private List list;

    public MultiSelectionAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        if (this.isReadOnly()) {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.SINGLE));
        } else {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.SINGLE));
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            this.text = new Text(parent, 0x800048);
            this.text.setFont(EditorUtil.TEXT_FONT);
            toolkit.adapt((Control)this.text, false, false);
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.select(this.getValues(), this.getValuesLabels());
            this.setControl((Control)this.text);
        } else {
            this.list = new List(parent, 0x800202);
            toolkit.adapt((Control)this.list, false, false);
            this.list.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            this.list.setFont(EditorUtil.TEXT_FONT);
            Map labelByValue = this.getAttributeMapper().getOptions(this.getTaskAttribute());
            if (labelByValue != null) {
                String[] stringArray = this.allValues = labelByValue.keySet().toArray(new String[0]);
                int n = this.allValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    this.list.add((String)labelByValue.get(value));
                    ++n2;
                }
            }
            this.select(this.getValues(), this.getValuesLabels());
            if (this.allValues != null) {
                this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Assert.isNotNull((Object)MultiSelectionAttributeEditor.this.allValues);
                        int[] indices = MultiSelectionAttributeEditor.this.list.getSelectionIndices();
                        String[] selectedValues = new String[indices.length];
                        int i = 0;
                        while (i < indices.length) {
                            int index = indices[i];
                            Assert.isLegal((index >= 0 && index <= MultiSelectionAttributeEditor.this.allValues.length - 1 ? 1 : 0) != 0);
                            selectedValues[i] = MultiSelectionAttributeEditor.this.allValues[index];
                            ++i;
                        }
                        MultiSelectionAttributeEditor.this.setValues(selectedValues);
                    }
                });
                this.list.showSelection();
            }
            this.setControl((Control)this.list);
        }
    }

    public String[] getValues() {
        return this.getAttributeMapper().getValues(this.getTaskAttribute()).toArray(new String[0]);
    }

    public String[] getValuesLabels() {
        return this.getAttributeMapper().getValueLabels(this.getTaskAttribute()).toArray(new String[0]);
    }

    private void select(String[] values, String[] labels) {
        if (this.text != null) {
            StringBuilder valueString = new StringBuilder();
            if (labels != null) {
                int i = 0;
                while (i < labels.length) {
                    valueString.append(labels[i]);
                    if (i != labels.length - 1) {
                        valueString.append(", ");
                    }
                    ++i;
                }
            }
            this.text.setText(valueString.toString());
        } else if (this.list != null) {
            if (values != null) {
                this.list.deselectAll();
                HashSet<String> selectedValues = new HashSet<String>(Arrays.asList(values));
                int i = 0;
                while (i < this.allValues.length) {
                    if (selectedValues.contains(this.allValues[i])) {
                        this.list.select(i);
                    }
                    ++i;
                }
            } else {
                this.list.setItems(labels);
                this.list.setSelection(labels);
            }
        }
    }

    public void setValues(String[] values) {
        this.getAttributeMapper().setValues(this.getTaskAttribute(), Arrays.asList(values));
        this.attributeChanged();
    }
}

