/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.Messages;
import org.eclipse.jst.jsf.validation.internal.el.operators.RelationalBinaryOperator;

abstract class LtGtRelationalBinaryOperator
extends RelationalBinaryOperator {
    LtGtRelationalBinaryOperator(DiagnosticFactory diagnosticFactory, String jsfVersion) {
        super(diagnosticFactory, jsfVersion);
    }

    protected abstract boolean doRealOperation(Number var1, Number var2);

    protected abstract boolean doRealOperation(String var1, String var2);

    public ValueType performOperation(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) || TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return BooleanLiteralType.FALSE;
        }
        String boxedFirstType = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondType = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDecimal;".equals(boxedFirstType) || "Ljava.math.BigDecimal;".equals(boxedSecondType)) {
            return this.handleNumericComparison(firstArg, secondArg, BigDecimal.class);
        }
        if ("Ljava.lang.Double;".equals(boxedFirstType) || "Ljava.lang.Float;".equals(boxedFirstType) || "Ljava.lang.Double;".equals(boxedSecondType) || "Ljava.lang.Float;".equals(boxedSecondType)) {
            return this.handleNumericComparison(firstArg, secondArg, Double.class);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstType) || "Ljava.math.BigInteger;".equals(boxedSecondType)) {
            return this.handleNumericComparison(firstArg, secondArg, BigInteger.class);
        }
        if ("Ljava.lang.Long;".equals(boxedFirstType) || "Ljava.lang.Long;".equals(boxedSecondType) || "Ljava.lang.Integer;".equals(boxedFirstType) || "Ljava.lang.Integer;".equals(boxedSecondType) || "Ljava.lang.Short;".equals(boxedFirstType) || "Ljava.lang.Short;".equals(boxedSecondType) || "Ljava.lang.Byte;".equals(boxedFirstType) || "Ljava.lang.Byte;".equals(boxedSecondType) || "Ljava.lang.Character".equals(boxedFirstType) || "Ljava.lang.Character".equals(boxedSecondType)) {
            return this.handleNumericComparison(firstArg, secondArg, Long.class);
        }
        if ("Ljava.lang.String;".equals(boxedFirstType) || "Ljava.lang.String;".equals(boxedSecondType)) {
            return this.handleStringComparison(firstArg, secondArg);
        }
        if (firstArg.isInstanceOf("Ljava.lang.Comparable;") || secondArg.isInstanceOf("Ljava.lang.Comparable;")) {
            if (this.checkIfIncompatibleEnums(firstArg, secondArg)) {
                return null;
            }
            return new ValueType("Z", 2);
        }
        return null;
    }

    public Diagnostic validate(ValueType firstArg, ValueType secondArg) {
        if ("Ljava.lang.Object;".equals(firstArg.getSignature()) || "Ljava.lang.Object;".equals(secondArg.getSignature())) {
            return Diagnostic.OK_INSTANCE;
        }
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) || TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return this._diagnosticFactory.create_BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME(Messages.getString("LtGtRelationalBinaryOperator.ConstantName.False"));
        }
        String boxedFirstType = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondType = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDecimal;".equals(boxedFirstType) || "Ljava.math.BigDecimal;".equals(boxedSecondType)) {
            return this.validateNumericComparison(firstArg, secondArg, BigDecimal.class);
        }
        if ("Ljava.lang.Double;".equals(boxedFirstType) || "Ljava.lang.Float;".equals(boxedFirstType) || "Ljava.lang.Double;".equals(boxedSecondType) || "Ljava.lang.Float;".equals(boxedSecondType)) {
            return this.validateNumericComparison(firstArg, secondArg, Double.class);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstType) || "Ljava.math.BigInteger;".equals(boxedSecondType)) {
            return this.validateNumericComparison(firstArg, secondArg, BigInteger.class);
        }
        if ("Ljava.lang.Long;".equals(boxedFirstType) || "Ljava.lang.Long;".equals(boxedSecondType) || "Ljava.lang.Integer;".equals(boxedFirstType) || "Ljava.lang.Integer;".equals(boxedSecondType) || "Ljava.lang.Short;".equals(boxedFirstType) || "Ljava.lang.Short;".equals(boxedSecondType) || "Ljava.lang.Byte;".equals(boxedFirstType) || "Ljava.lang.Byte;".equals(boxedSecondType) || "Ljava.lang.Character".equals(boxedFirstType) || "Ljava.lang.Character".equals(boxedSecondType)) {
            return this.validateNumericComparison(firstArg, secondArg, Long.class);
        }
        if ("Ljava.lang.String;".equals(boxedFirstType) || "Ljava.lang.String;".equals(boxedSecondType)) {
            return this.validateStringComparison(firstArg, secondArg);
        }
        if (firstArg.isInstanceOf("Ljava.lang.Comparable;") || secondArg.isInstanceOf("Ljava.lang.Comparable;")) {
            Diagnostic diag = Diagnostic.OK_INSTANCE;
            if (this.checkIfIncompatibleEnums(firstArg, secondArg)) {
                diag = this._diagnosticFactory.create_BINARY_OP_COMPARISON_OF_ENUMS_INCOMPATIBLE();
            }
            return diag;
        }
        return this._diagnosticFactory.create_BINARY_OP_NO_AVAILABLE_TYPE_COERCION();
    }

    private boolean checkIfIncompatibleEnums(ValueType firstArg, ValueType secondArg) {
        return firstArg.isEnumType() && secondArg.isEnumType() && !TypeUtil.isEnumsCompareCompatible((String)firstArg.getSignature(), (String)secondArg.getSignature());
    }
}

