/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.view;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.internal.shells.ui.view.SystemCommandsViewProvider;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.SystemTableView;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public class SystemCommandsView
extends SystemTableView
implements IPropertyChangeListener {
    private static int MAX_BUFFER = 20000;
    private Color _errColor;
    private Color _outColor;
    private Color _infColor;
    private Color _warColor;
    private Color _prmColor;
    private int _maxCharWidth = 256;

    public SystemCommandsView(Table table, ISystemMessageLine msgLine) {
        super(table, msgLine);
        this.addFilter(new CommandsViewFilter());
        this.updateTheme();
        int[] colWidths = new int[]{1000};
        this.setLastColumnWidths(colWidths);
    }

    protected SystemTableViewProvider getProvider() {
        if (this._provider == null) {
            this._provider = new SystemCommandsViewProvider();
        }
        return this._provider;
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.updateTheme();
    }

    public void updateTheme() {
        Table table = this.getTable();
        if (table != null) {
            IThemeManager mgr = PlatformUI.getWorkbench().getThemeManager();
            Color bg = mgr.getCurrentTheme().getColorRegistry().get("REMOTE_COMMANDS_VIEW_BG_COLOR");
            Color fg = mgr.getCurrentTheme().getColorRegistry().get("REMOTE_COMMANDS_VIEW_FG_COLOR");
            Font fFont = mgr.getCurrentTheme().getFontRegistry().get("REMOTE_COMMANDS_VIEW_FONT");
            table.setBackground(bg);
            table.setForeground(fg);
            table.setFont(fFont);
            if (this._errColor == null) {
                mgr.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this._errColor = mgr.getCurrentTheme().getColorRegistry().get("MESSAGE_ERROR_COLOR");
            this._outColor = mgr.getCurrentTheme().getColorRegistry().get("REMOTE_COMMANDS_VIEW_FG_COLOR");
            this._infColor = mgr.getCurrentTheme().getColorRegistry().get("MESSAGE_INFORMATION_COLOR");
            this._warColor = mgr.getCurrentTheme().getColorRegistry().get("MESSAGE_WARNING_COLOR");
            this._prmColor = mgr.getCurrentTheme().getColorRegistry().get("REMOTE_COMMANDS_VIEW_PROMPT_COLOR");
        }
    }

    public void refresh() {
        super.refresh();
        Table table = this.getTable();
        if (table != null && table.getItemCount() > 0) {
            TableItem lastItem = table.getItem(table.getItemCount() - 1);
            table.showItem(lastItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void updateChildren() {
        Object input = this.getInput();
        if (!(input instanceof IRemoteCommandShell)) return;
        SystemTableViewProvider provider = (SystemTableViewProvider)this.getContentProvider();
        Table table = this.getTable();
        Object[] children = provider.getChildren(input);
        if (children == null || children.length <= 0) return;
        boolean needsLayout = false;
        TableItem[] tableItems = table.getItems();
        if (tableItems == null || tableItems.length == 0) {
            needsLayout = true;
        } else {
            int widest = provider.getMaxCharsInColumnZero();
            if (widest > this._maxCharWidth) {
                needsLayout = true;
                this._maxCharWidth = widest;
            }
        }
        Object[] objectArray = children;
        synchronized (children) {
            int index = table.getItemCount();
            if (index > MAX_BUFFER) {
                table.setRedraw(false);
                this.clearFirstItems(children, index - MAX_BUFFER / 2);
                table.setRedraw(true);
                provider.flushCache();
                this.internalRefresh(input);
            } else {
                int i = index;
                while (i < children.length) {
                    boolean isVisible;
                    Object child = children[i];
                    if (child != null && (isVisible = true)) {
                        TableItem newItem = (TableItem)this.newItem((Widget)table, 0, index);
                        this.colorItem(newItem, child);
                        this.updateItem((Widget)newItem, child);
                        ++index;
                    }
                    ++i;
                }
                int y = table.getSize().y;
                int h = table.getItemHeight();
                int n = y / h - 1;
                table.setTopIndex(Math.max(0, index - n));
            }
            // ** MonitorExit[var7_8] (shouldn't be in output)
            if (!needsLayout) return;
            this.computeLayout(true);
            return;
        }
    }

    private void colorItem(TableItem newItem, Object child) {
        if (child instanceof IRemoteOutput) {
            IRemoteOutput rmtOutput = (IRemoteOutput)child;
            String type = rmtOutput.getType();
            if (type.equals("stderr") || type.equals("error")) {
                newItem.setForeground(this._errColor);
            } else if (type.equals("warning")) {
                newItem.setForeground(this._warColor);
            } else if (type.equals("informational")) {
                newItem.setForeground(this._infColor);
            } else if (type.equals("prompt")) {
                newItem.setForeground(this._prmColor);
            } else {
                newItem.setForeground(this._outColor);
            }
        }
    }

    public void clearAllItems() {
        Object input = this.getInput();
        SystemTableViewProvider provider = (SystemTableViewProvider)this.getContentProvider();
        Object[] children = provider.getChildren(input);
        this.clearFirstItems(children, children.length);
    }

    public void dispose() {
        IThemeManager mgr = PlatformUI.getWorkbench().getThemeManager();
        mgr.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFirstItems(Object[] children, int items) {
        Table table = this.getTable();
        table.setRedraw(false);
        Table table2 = table;
        synchronized (table2) {
            int count;
            if (items > 0 && (count = table.getItemCount()) >= items) {
                table.remove(0, items - 1);
                IRemoteCommandShell input = (IRemoteCommandShell)this.getInput();
                int i = 0;
                while (i < items && i < children.length) {
                    Object item = children[i];
                    input.removeOutput(item);
                    ++i;
                }
            }
        }
        table.setRedraw(true);
    }

    protected Item newItem(Widget parent, int flags, int ix) {
        if (parent instanceof Table) {
            return new TableItem((Table)parent, flags);
        }
        return null;
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        Object child = event.getSource();
        if (event.getType() == 82) {
            SystemTableViewProvider provider;
            if (child == this.getInput() && (provider = (SystemTableViewProvider)this.getContentProvider()) != null) {
                provider.flushCache();
                this.updateChildren();
                return;
            }
        } else if (event.getType() == 81) {
            try {
                Widget w = this.findItem(child);
                if (w != null) {
                    this.updateItem(w, child);
                }
            }
            catch (Exception exception) {}
        }
    }

    protected Object getParentForContent(Object element) {
        return this.getViewAdapter(element).getParent(element);
    }

    public class CommandsViewFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parent, Object element) {
            IRemoteOutput remoteOutput;
            return !(element instanceof IRemoteOutput) || (remoteOutput = (IRemoteOutput)element).getText().indexOf("BEGIN-END-TAG:") <= -1;
        }
    }
}

