/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemHostPool;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemClearAllPasswordsAction;
import org.eclipse.rse.internal.ui.actions.SystemConnectAllSubSystemsAction;
import org.eclipse.rse.internal.ui.actions.SystemCopyConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemDisconnectAllSubSystemsAction;
import org.eclipse.rse.internal.ui.actions.SystemExportConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemImportConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemMoveConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemMoveDownConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemMoveUpConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemWorkOfflineAction;
import org.eclipse.rse.internal.ui.view.SystemInheritablePropertyData;
import org.eclipse.rse.internal.ui.view.SystemInheritableTextPropertyDescriptor;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.ui.RSESystemTypeAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemConnectionForm;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorSpecialChar;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class SystemViewConnectionAdapter
extends AbstractSystemViewAdapter {
    private SystemNewConnectionAction anotherConnectionAction = null;
    private SystemMoveUpConnectionAction upAction = null;
    private SystemMoveDownConnectionAction downAction = null;
    private SystemDisconnectAllSubSystemsAction disconnectAction = null;
    private SystemConnectAllSubSystemsAction connectAction = null;
    private SystemClearAllPasswordsAction clearPasswordAction = null;
    private SystemCopyConnectionAction copyAction = null;
    private SystemMoveConnectionAction moveAction = null;
    private SystemExportConnectionAction exportAction = null;
    private SystemImportConnectionAction importAction = null;
    private SystemWorkOfflineAction offlineAction = null;
    private SystemInheritablePropertyData userIdData = new SystemInheritablePropertyData();
    private String translatedType = null;
    private String translatedHostname = null;
    private String translatedDescription = null;
    private String original_hostName;
    private String original_description;
    private SystemInheritablePropertyData original_userIdData = new SystemInheritablePropertyData();
    private boolean changed_hostName;
    private boolean changed_description;
    private boolean changed_userId;
    private boolean actionsCreated = false;
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    static /* synthetic */ Class class$0;

    private IRSESystemType getSystemTypeForHost(IHost host) {
        if (host != null) {
            return host.getSystemType();
        }
        return null;
    }

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        Object object;
        IHost host;
        IRSESystemType sysType;
        if (!this.actionsCreated) {
            this.createActions();
        }
        if ((sysType = this.getSystemTypeForHost(host = (IHost)selection.getFirstElement())) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = sysType.getAdapter((Class)clazz);
        } else {
            object = null;
        }
        Object adapter = object;
        RSESystemTypeAdapter sysTypeAdapter = adapter instanceof RSESystemTypeAdapter ? (RSESystemTypeAdapter)adapter : null;
        menu.add(menuGroup, this.anotherConnectionAction);
        menu.appendToGroup("group.new", (IContributionItem)new GroupMarker("group.new.noncascade"));
        menu.add(menuGroup, this.copyAction);
        menu.add(menuGroup, this.moveAction);
        menu.add(menuGroup, this.upAction);
        menu.add(menuGroup, this.downAction);
        menu.add(menuGroup, this.exportAction);
        menu.add(menuGroup, this.importAction);
        this.addConnectOrDisconnectAction(menu, menuGroup, selection);
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        IConnectorService[] connectorServices = registry.getConnectorServices(host);
        boolean passwordsSupported = false;
        int i = 0;
        while (i < connectorServices.length && !passwordsSupported) {
            passwordsSupported |= connectorServices[i].supportsPassword();
            ++i;
        }
        if (passwordsSupported) {
            menu.add(menuGroup, this.clearPasswordAction);
        }
        if (sysTypeAdapter != null && sysTypeAdapter.isEnableOffline(host.getSystemType())) {
            menu.add(menuGroup, this.offlineAction);
        }
    }

    private void addConnectOrDisconnectAction(SystemMenuManager menu, String menuGroup, IStructuredSelection selection) {
        IHost host = (IHost)selection.getFirstElement();
        ISystemRegistry sysReg = RSECorePlugin.getTheSystemRegistry();
        boolean anySupportsConnect = sysReg.isAnySubSystemSupportsConnect(host);
        if (anySupportsConnect) {
            boolean anyConnected = sysReg.isAnySubSystemConnected(host);
            boolean allConnected = sysReg.areAllSubSystemsConnected(host);
            if (!allConnected) {
                menu.add(menuGroup, this.connectAction);
            }
            if (anyConnected) {
                menu.add(menuGroup, this.disconnectAction);
            }
        }
    }

    private void createActions() {
        this.anotherConnectionAction = new SystemNewConnectionAction(null, SystemResources.ACTION_ANOTHERCONN_LABEL, SystemResources.ACTION_ANOTHERCONN_TOOLTIP, false, true, null);
        this.anotherConnectionAction.setHelp("org.eclipse.rse.ui.actn0015");
        this.upAction = new SystemMoveUpConnectionAction(null);
        this.downAction = new SystemMoveDownConnectionAction(null);
        this.disconnectAction = new SystemDisconnectAllSubSystemsAction(null);
        this.copyAction = new SystemCopyConnectionAction(null);
        this.moveAction = new SystemMoveConnectionAction(null);
        this.offlineAction = new SystemWorkOfflineAction(null);
        this.connectAction = new SystemConnectAllSubSystemsAction(null);
        this.clearPasswordAction = new SystemClearAllPasswordsAction(null);
        this.exportAction = new SystemExportConnectionAction();
        this.importAction = new SystemImportConnectionAction();
        this.actionsCreated = true;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        IHost connection = (IHost)element;
        boolean anyConnected = RSECorePlugin.getTheSystemRegistry().isAnySubSystemConnected(connection);
        ImageDescriptor descriptor = null;
        IRSESystemType systemType = this.getSystemTypeForHost(connection);
        if (systemType != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            RSESystemTypeAdapter sysTypeAdapter = (RSESystemTypeAdapter)systemType.getAdapter((Class)clazz);
            descriptor = anyConnected ? sysTypeAdapter.getLiveImageDescriptor(systemType) : sysTypeAdapter.getImageDescriptor(systemType);
        } else {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return descriptor;
    }

    public String getText(Object element) {
        IHost conn = (IHost)element;
        boolean qualifyNames = RSEUIPlugin.getTheSystemRegistryUI().getQualifiedHostNames();
        if (!qualifyNames) {
            return conn.getAliasName();
        }
        return String.valueOf(conn.getSystemProfileName()) + "." + conn.getAliasName();
    }

    public String getName(Object element) {
        IHost conn = (IHost)element;
        return conn.getAliasName();
    }

    public String getAbsoluteName(Object element) {
        IHost conn = (IHost)element;
        return String.valueOf(conn.getSystemProfileName()) + "." + conn.getAliasName();
    }

    public String getType(Object element) {
        if (this.translatedType == null) {
            this.translatedType = SystemViewResources.RESID_PROPERTY_CONNECTION_TYPE_VALUE;
        }
        return this.translatedType;
    }

    public String getStatusLineText(Object element) {
        IHost conn = (IHost)element;
        if (this.translatedHostname == null) {
            this.translatedHostname = SystemViewResources.RESID_PROPERTY_HOSTNAME_LABEL;
        }
        if (this.translatedDescription == null) {
            this.translatedDescription = SystemViewResources.RESID_PROPERTY_CONNDESCRIPTION_LABEL;
        }
        String statusText = String.valueOf(this.getType(element)) + ": " + conn.getAliasName() + "  -  " + this.translatedHostname + ": " + conn.getHostName();
        String text = conn.getDescription();
        if (text == null || text.length() == 0) {
            return statusText;
        }
        return String.valueOf(statusText) + "  -  " + this.translatedDescription + ": " + text;
    }

    public Object getParent(Object element) {
        return RSECorePlugin.getTheSystemRegistry();
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        IHost conn = (IHost)element;
        ISystemViewInputProvider input = this.getInput();
        if (input != null) {
            Object[] children = input.getConnectionChildren(conn);
            if (children != null) {
                Vector<Object> v = new Vector<Object>();
                boolean someSkipped = false;
                int idx = 0;
                while (idx < children.length) {
                    if (children[idx] instanceof ISubSystem && ((ISubSystem)children[idx]).isHidden()) {
                        someSkipped = true;
                    } else {
                        v.addElement(children[idx]);
                    }
                    ++idx;
                }
                if (someSkipped) {
                    children = new Object[v.size()];
                    idx = 0;
                    while (idx < children.length) {
                        children[idx] = v.elementAt(idx);
                        ++idx;
                    }
                }
            }
            return children;
        }
        System.out.println("SystemViewConnection.getChildren(): adapter has no input!");
        return null;
    }

    public boolean hasChildren(IAdaptable element) {
        IHost conn = (IHost)element;
        return this.getInput().hasConnectionChildren(conn);
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[6];
            int idx = -1;
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = SystemViewConnectionAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.profile", SystemViewResources.RESID_PROPERTY_PROFILE_LABEL, SystemViewResources.RESID_PROPERTY_PROFILE_TOOLTIP);
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = SystemViewConnectionAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.systemType", SystemViewResources.RESID_PROPERTY_SYSTEMTYPE_LABEL, SystemViewResources.RESID_PROPERTY_SYSTEMTYPE_TOOLTIP);
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = SystemViewConnectionAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.connected", SystemViewResources.RESID_PROPERTY_CONNECTIONSTATUS_LABEL, SystemViewResources.RESID_PROPERTY_CONNECTIONSTATUS_TOOLTIP);
            if (this.translatedHostname == null) {
                this.translatedHostname = SystemViewResources.RESID_PROPERTY_HOSTNAME_LABEL;
            }
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = new TextPropertyDescriptor((Object)"org.eclipse.rse.ui.hostname", this.translatedHostname);
            propertyDescriptorArray[idx].setDescription(SystemViewResources.RESID_PROPERTY_HOSTNAME_TOOLTIP);
            SystemInheritableTextPropertyDescriptor userIdDescriptor = new SystemInheritableTextPropertyDescriptor("org.eclipse.rse.ui.defaultuserid", SystemViewResources.RESID_PROPERTY_DEFAULTUSERID_LABEL);
            userIdDescriptor.setToggleButtonToolTipText(SystemResources.RESID_CONNECTION_DEFAULTUSERID_INHERITBUTTON_TIP);
            userIdDescriptor.setEntryFieldToolTipText(SystemResources.RESID_CONNECTION_DEFAULTUSERID_TIP);
            ValidatorSpecialChar userIdValidator = new ValidatorSpecialChar("=;", false, RSEUIPlugin.getPluginMessage("RSEG1026"), RSEUIPlugin.getPluginMessage("RSEG1025"));
            userIdDescriptor.setValidator(userIdValidator);
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = userIdDescriptor;
            propertyDescriptorArray[idx].setDescription(SystemViewResources.RESID_PROPERTY_DEFAULTUSERID_TOOLTIP);
            if (this.translatedDescription == null) {
                this.translatedDescription = SystemViewResources.RESID_PROPERTY_CONNDESCRIPTION_LABEL;
            }
            SystemViewConnectionAdapter.propertyDescriptorArray[++idx] = new TextPropertyDescriptor((Object)"org.eclipse.rse.ui.description", this.translatedDescription);
            propertyDescriptorArray[idx].setDescription(SystemViewResources.RESID_PROPERTY_CONNDESCRIPTION_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    protected Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        IHost conn = (IHost)this.propertySourceInput;
        if (name.equals("org.eclipse.rse.ui.systemType")) {
            return conn.getSystemType().getLabel();
        }
        if (name.equals("org.eclipse.rse.ui.hostname")) {
            return conn.getHostName();
        }
        if (name.equals("org.eclipse.rse.ui.defaultuserid")) {
            this.setDefaultUserIdPropertyData(this.userIdData, conn);
            return this.userIdData;
        }
        if (name.equals("org.eclipse.rse.ui.description")) {
            return conn.getDescription();
        }
        if (name.equals("org.eclipse.rse.ui.profile")) {
            return conn.getSystemProfile().getName();
        }
        if (name.equals("org.eclipse.rse.ui.connected")) {
            if (conn.isOffline()) {
                return SystemResources.RESID_OFFLINE_LABEL;
            }
            boolean anyConnected = RSECorePlugin.getTheSystemRegistry().isAnySubSystemConnected(conn);
            if (anyConnected) {
                return SystemViewResources.RESID_PROPERTY_CONNECTIONSTATUS_CONNECTED_VALUE;
            }
            return SystemViewResources.RESID_PROPERTY_CONNECTIONSTATUS_DISCONNECTED_VALUE;
        }
        return null;
    }

    private SystemInheritablePropertyData setDefaultUserIdPropertyData(SystemInheritablePropertyData data, IHost conn) {
        String localUserId = conn.getLocalDefaultUserId();
        data.setLocalValue(localUserId);
        String parentUserId = RSEPreferencesManager.getDefaultUserId((IRSESystemType)conn.getSystemType());
        data.setInheritedValue(parentUserId);
        data.setIsLocal(localUserId != null && localUserId.length() > 0);
        return data;
    }

    public void setPropertySourceInput(Object propertySourceInput) {
        if (this.propertySourceInput == propertySourceInput) {
            return;
        }
        super.setPropertySourceInput(propertySourceInput);
        IHost conn = (IHost)propertySourceInput;
        this.original_userIdData = this.setDefaultUserIdPropertyData(this.original_userIdData, conn);
        this.original_hostName = conn.getHostName();
        this.original_description = conn.getDescription();
        this.changed_description = false;
        this.changed_hostName = false;
        this.changed_userId = false;
    }

    public boolean isPropertySet(Object propertyObject) {
        String property = (String)propertyObject;
        boolean changed = false;
        if (property.equals("org.eclipse.rse.ui.defaultuserid")) {
            changed = this.changed_userId;
        } else if (property.equals("org.eclipse.rse.ui.hostname")) {
            changed = this.changed_hostName;
        } else if (property.equals("org.eclipse.rse.ui.description")) {
            changed = this.changed_description;
        }
        return changed;
    }

    public void resetPropertyValue(Object propertyObject) {
        String property = (String)propertyObject;
        IHost conn = (IHost)this.propertySourceInput;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        if (property.equals("org.eclipse.rse.ui.defaultuserid")) {
            this.updateDefaultUserId(conn, this.original_userIdData);
        } else if (property.equals("org.eclipse.rse.ui.hostname")) {
            sr.updateHost(conn, conn.getSystemType(), conn.getAliasName(), this.original_hostName, conn.getDescription(), conn.getDefaultUserId(), 0);
        } else if (property.equals("org.eclipse.rse.ui.description")) {
            sr.updateHost(conn, conn.getSystemType(), conn.getAliasName(), conn.getHostName(), this.original_description, conn.getDefaultUserId(), 0);
        }
    }

    private void updateDefaultUserId(IHost conn, SystemInheritablePropertyData data) {
        int whereToUpdate = 2;
        String userId = data.getLocalValue();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.updateHost(conn, conn.getSystemType(), conn.getAliasName(), conn.getHostName(), conn.getDescription(), userId, whereToUpdate);
    }

    public void setPropertyValue(Object property, Object value) {
        String name = (String)property;
        IHost conn = (IHost)this.propertySourceInput;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        if (name.equals("org.eclipse.rse.ui.defaultuserid")) {
            this.updateDefaultUserId(conn, (SystemInheritablePropertyData)value);
            this.changed_userId = true;
        } else if (name.equals("org.eclipse.rse.ui.hostname")) {
            if (!((String)value).equalsIgnoreCase(conn.getHostName())) {
                sr.updateHost(conn, conn.getSystemType(), conn.getAliasName(), (String)value, conn.getDescription(), conn.getDefaultUserId(), 0);
                this.changed_hostName = true;
            }
        } else if (name.equals("org.eclipse.rse.ui.description") && !((String)value).equalsIgnoreCase(conn.getDescription())) {
            sr.updateHost(conn, conn.getSystemType(), conn.getAliasName(), conn.getHostName(), (String)value, conn.getDefaultUserId(), 0);
            this.changed_description = true;
        }
    }

    public boolean canDelete(Object element) {
        if (element instanceof IHost) {
            IHost host = (IHost)element;
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            ISubSystem[] ss = sr.getSubSystems(host);
            int i = 0;
            while (i < ss.length) {
                if (ss[i].isConnected() && ss[i].getSubSystemConfiguration().supportsSubSystemConnect()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) {
        boolean ok = true;
        IHost conn = (IHost)element;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.deleteHost(conn);
        return ok;
    }

    public boolean canRename(Object element) {
        return true;
    }

    public boolean doRename(Shell shell, Object element, String name, IProgressMonitor monitor) throws Exception {
        boolean ok = true;
        IHost conn = (IHost)element;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.renameHost(conn, name);
        return ok;
    }

    public ISystemValidator getNameValidator(Object element) {
        IHost conn = (IHost)element;
        return SystemConnectionForm.getConnectionNameValidator(conn.getSystemProfile());
    }

    public String getCanonicalNewName(Object element, String newName) {
        IHost conn = (IHost)element;
        return (String.valueOf(conn.getSystemProfileName()) + "." + newName).toUpperCase();
    }

    public boolean canDrag(Object element) {
        return true;
    }

    public boolean canDrop(Object element) {
        return element instanceof IHost;
    }

    public Object doDrop(Object from, Object to, boolean sameSystemType, boolean sameSystem, int srcType, IProgressMonitor monitor) {
        if (from instanceof IHost) {
            IHost srcHost = (IHost)from;
            IHost tgtHost = (IHost)to;
            if (srcHost != null && tgtHost != null && srcHost != tgtHost) {
                ISystemProfile profile = tgtHost.getSystemProfile();
                ISystemHostPool pool = tgtHost.getHostPool();
                ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
                int tgtPosition = pool.getHostPosition(tgtHost);
                int srcPosition = pool.getHostPosition(srcHost);
                int delta = tgtPosition - srcPosition;
                IHost[] conns = new IHost[]{srcHost};
                sr.moveHosts(profile.getName(), conns, delta);
            }
            return srcHost;
        }
        return null;
    }

    public Object doDrag(Object element, boolean sameSystemType, IProgressMonitor monitor) {
        return element;
    }

    public boolean validateDrop(Object src, Object target, boolean sameSystem) {
        if (src instanceof IHost && target instanceof IHost && src != target) {
            ISystemProfile p2;
            ISystemProfile p1 = ((IHost)src).getSystemProfile();
            return p1 == (p2 = ((IHost)target).getSystemProfile());
        }
        return false;
    }

    public String getMementoHandle(Object element) {
        IHost conn = (IHost)element;
        return String.valueOf(conn.getSystemProfileName()) + "." + conn.getAliasName();
    }

    public String getMementoHandleKey(Object element) {
        return "Conn";
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

