/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.audio;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.audio.IMemento;
import org.eclipse.wst.server.ui.internal.audio.Sound;
import org.eclipse.wst.server.ui.internal.audio.XMLMemento;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioCore {
    protected static AudioCore instance;
    public static final String PREF_SOUND_ENABLED = "soundEnabled";
    public static final String PREF_VOLUME = "volume";
    public static final String SOUNDS_FILE = "sounds.xml";
    public static final String DISABLED_FILE = "disabled-sounds.xml";
    private Map<String, String> categories;
    private Map<String, Sound> sounds;
    private List<String> disabledSounds;
    private List<String> disabledCategories;
    private Map<String, IPath> userSoundMap;

    private AudioCore() {
        this.loadExtensionPoints();
        this.loadSoundMap();
        this.loadDisabledLists();
    }

    protected Map<String, String> getCategories() {
        return this.categories;
    }

    protected static Clip getClip(URL url) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(url);
            AudioFormat format = audioInputStream.getFormat();
            if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                audioInputStream = AudioSystem.getAudioInputStream(tmp, audioInputStream);
                format = tmp;
            }
            DataLine.Info info = new DataLine.Info(Clip.class, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength() * format.getFrameSize());
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
            return clip;
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Could not get clip: " + url, e);
            return null;
        }
    }

    protected static boolean isAudioSupported() {
        try {
            boolean sound = false;
            Mixer.Info[] info2 = AudioSystem.getMixerInfo();
            if (info2 != null) {
                int size = info2.length;
                int i = 0;
                while (i < size) {
                    Mixer mixer = AudioSystem.getMixer(info2[i]);
                    if (mixer != null) {
                        try {
                            Line.Info info = mixer.getLineInfo();
                            Line line = mixer.getLine(info);
                            if (line != null && line.toString().indexOf("Output") >= 0) {
                                sound = true;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
            }
            return sound;
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Could not verify audio status", e);
            return true;
        }
    }

    public boolean getDefaultSoundsEnabled() {
        return this.getPreferenceStore().getDefaultBoolean(PREF_SOUND_ENABLED);
    }

    public int getDefaultVolume() {
        return this.getPreferenceStore().getDefaultInt(PREF_VOLUME);
    }

    public static AudioCore getInstance() {
        if (instance == null) {
            instance = new AudioCore();
        }
        return instance;
    }

    protected IPreferenceStore getPreferenceStore() {
        return ServerUIPlugin.getInstance().getPreferenceStore();
    }

    protected Sound getSound(String id) {
        try {
            return this.sounds.get(id);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Map<String, Sound> getSounds() {
        return this.sounds;
    }

    protected Map<String, IPath> getUserSoundMap() {
        if (this.userSoundMap == null) {
            this.loadSoundMap();
        }
        return this.userSoundMap;
    }

    protected IPath getUserSoundPath(String id) {
        try {
            IPath path;
            if (this.userSoundMap == null) {
                this.loadSoundMap();
            }
            if ((path = this.userSoundMap.get(id)) != null) {
                return path;
            }
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Could not get sound URL: " + id, e);
        }
        return null;
    }

    public int getVolume() {
        return this.getPreferenceStore().getInt(PREF_VOLUME);
    }

    public static void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(PREF_VOLUME, 18);
    }

    public boolean isCategoryEnabled(String id) {
        if (id == null) {
            return false;
        }
        if (this.disabledCategories == null) {
            this.loadDisabledLists();
        }
        return !this.disabledCategories.contains(id);
    }

    public boolean isSoundEnabled() {
        return this.getPreferenceStore().getBoolean(PREF_SOUND_ENABLED);
    }

    public boolean isSoundEnabled(String id) {
        if (id == null) {
            return false;
        }
        if (this.disabledSounds == null) {
            this.loadDisabledLists();
        }
        return !this.disabledSounds.contains(id);
    }

    private void loadDisabledLists() {
        block20: {
            String filename = ServerUIPlugin.getInstance().getStateLocation().append(DISABLED_FILE).toOSString();
            FileInputStream in = null;
            this.disabledCategories = new ArrayList<String>();
            this.disabledSounds = new ArrayList<String>();
            try {
                try {
                    in = new FileInputStream(filename);
                    IMemento memento = XMLMemento.loadMemento(in);
                    IMemento cat = memento.getChild("categories");
                    IMemento[] children = cat.getChildren("category");
                    int size = children.length;
                    int i = 0;
                    while (i < size) {
                        try {
                            IMemento child = children[i];
                            String id = child.getString("id");
                            this.disabledCategories.add(id);
                        }
                        catch (Exception ex) {
                            Trace.trace((byte)3, "Error reading URL map ", ex);
                        }
                        ++i;
                    }
                    IMemento sound = memento.getChild("sounds");
                    children = sound.getChildren("sound");
                    size = children.length;
                    int i2 = 0;
                    while (i2 < size) {
                        try {
                            IMemento child = children[i2];
                            String id = child.getString("id");
                            this.disabledSounds.add(id);
                        }
                        catch (Exception ex) {
                            Trace.trace((byte)3, "Error reading URL map ", ex);
                        }
                        ++i2;
                    }
                }
                catch (Exception exception) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void loadExtensionPoints() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.ui", "audio");
        int size = cf.length;
        this.categories = new HashMap<String, String>();
        this.sounds = new HashMap<String, Sound>();
        int i = 0;
        while (i < size) {
            try {
                String elementName = cf[i].getName();
                String id = cf[i].getAttribute("id");
                String name = cf[i].getAttribute("name");
                if ("category".equals(elementName)) {
                    this.categories.put(id, name);
                } else if ("sound".equals(elementName)) {
                    String category = cf[i].getAttribute("category");
                    String location = cf[i].getAttribute("location");
                    URL realURL = null;
                    if (location != null && location.length() > 0) {
                        String pluginId = cf[i].getDeclaringExtension().getContributor().getName();
                        URL url = FileLocator.find((Bundle)Platform.getBundle((String)pluginId), (IPath)new Path(location), null);
                        realURL = FileLocator.resolve((URL)url);
                    }
                    Sound sound = new Sound(id, category, name, realURL);
                    this.sounds.put(id, sound);
                }
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "Could not load audio: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
    }

    private void loadSoundMap() {
        block17: {
            String filename = ServerUIPlugin.getInstance().getStateLocation().append(SOUNDS_FILE).toOSString();
            FileInputStream in = null;
            this.userSoundMap = new HashMap<String, IPath>();
            try {
                try {
                    in = new FileInputStream(filename);
                    IMemento memento = XMLMemento.loadMemento(in);
                    IMemento[] children = memento.getChildren("map");
                    int size = children.length;
                    int i = 0;
                    while (i < size) {
                        try {
                            IMemento child = children[i];
                            String id = child.getString("id");
                            String pathStr = child.getString("path");
                            Path path = new Path(pathStr);
                            this.userSoundMap.put(id, (IPath)path);
                        }
                        catch (Exception ex) {
                            Trace.trace((byte)3, "Error reading URL map ", ex);
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void playSound(String id) {
        if (!this.isSoundEnabled()) {
            return;
        }
        if (!this.isSoundEnabled(id)) {
            return;
        }
        try {
            Sound sound = this.sounds.get(id);
            String category = sound.getCategory();
            if (category != null && this.categories.containsKey(category) && !this.isCategoryEnabled(category)) {
                return;
            }
            URL url = sound.getLocation();
            IPath path = this.getUserSoundPath(id);
            if (path != null) {
                url = path.toFile().toURL();
            }
            AudioCore.playSound(url, this.getVolume());
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error playing audio: " + id, e);
        }
    }

    protected static void playSound(URL url, final int volume) {
        try {
            Trace.trace((byte)4, "playSound");
            if (url == null || volume <= 0) {
                return;
            }
            final Clip clip = AudioCore.getClip(url);
            if (clip == null) {
                return;
            }
            Trace.trace((byte)4, "playing");
            Thread t = new Thread("Sound Thread"){

                public void run() {
                    FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                    double value = (double)volume / 20.0;
                    float dB = (float)(Math.log(value == 0.0 ? 1.0E-4 : value) / Math.log(10.0) * 20.0);
                    gainControl.setValue(dB);
                    Trace.trace((byte)4, "start");
                    clip.start();
                    try {
                        1.sleep(99L);
                    }
                    catch (Exception exception) {}
                    while (clip.isActive()) {
                        try {
                            1.sleep(99L);
                        }
                        catch (Exception exception) {
                            break;
                        }
                    }
                    clip.stop();
                    clip.close();
                    Trace.trace((byte)4, "stop");
                }
            };
            t.setDaemon(true);
            t.start();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error playing audio: " + url, e);
        }
    }

    private void saveDisabledLists() {
        block16: {
            String filename = ServerUIPlugin.getInstance().getStateLocation().append(DISABLED_FILE).toOSString();
            FileOutputStream fout = null;
            try {
                try {
                    XMLMemento memento = XMLMemento.createWriteRoot("disabled");
                    IMemento cat = memento.createChild("categories");
                    Iterator<String> iterator = this.disabledCategories.iterator();
                    while (iterator.hasNext()) {
                        IMemento child = cat.createChild("category");
                        String id = iterator.next();
                        child.putString("id", id);
                    }
                    IMemento sound = memento.createChild("sounds");
                    iterator = this.disabledSounds.iterator();
                    while (iterator.hasNext()) {
                        IMemento child = sound.createChild("sound");
                        String id = iterator.next();
                        child.putString("id", id);
                    }
                    fout = new FileOutputStream(filename);
                    memento.save(fout);
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Could not save disabled information", e);
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void saveSoundMap() {
        block15: {
            String filename = ServerUIPlugin.getInstance().getStateLocation().append(SOUNDS_FILE).toOSString();
            FileOutputStream fout = null;
            try {
                try {
                    XMLMemento memento = XMLMemento.createWriteRoot("sound-map");
                    Iterator<String> iterator = this.userSoundMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        IMemento child = memento.createChild("map");
                        String id = iterator.next();
                        child.putString("id", id);
                        IPath path = this.userSoundMap.get(id);
                        child.putString("path", path.toString());
                    }
                    fout = new FileOutputStream(filename);
                    memento.save(fout);
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Could not save URL map information", e);
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setCategoryEnabled(String id, boolean b) {
        if (id == null) {
            return;
        }
        if (this.disabledCategories == null) {
            this.loadDisabledLists();
        }
        if (b) {
            if (this.disabledCategories.contains(id)) {
                this.disabledCategories.remove(id);
                this.saveDisabledLists();
            }
        } else if (!this.disabledCategories.contains(id)) {
            this.disabledCategories.add(id);
            this.saveDisabledLists();
        }
    }

    public void setSoundEnabled(String id, boolean b) {
        if (id == null) {
            return;
        }
        if (this.disabledSounds == null) {
            this.loadDisabledLists();
        }
        if (b) {
            if (this.disabledSounds.contains(id)) {
                this.disabledSounds.remove(id);
                this.saveDisabledLists();
            }
        } else if (!this.disabledSounds.contains(id)) {
            this.disabledSounds.add(id);
            this.saveDisabledLists();
        }
    }

    public void setSoundsEnabled(boolean enabled) {
        this.getPreferenceStore().setValue(PREF_SOUND_ENABLED, enabled);
    }

    protected void setSoundURL(String id, IPath path) {
        if (id == null || path == null) {
            return;
        }
        try {
            if (this.userSoundMap == null) {
                this.loadSoundMap();
            }
            this.userSoundMap.put(id, path);
            this.saveSoundMap();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Could not get sound URL: " + id, e);
        }
    }

    protected void setUserSoundMap(Map<String, IPath> map) {
        if (map != null) {
            this.userSoundMap = map;
            this.saveSoundMap();
        }
    }

    public void setVolume(int volume) {
        this.getPreferenceStore().setValue(PREF_VOLUME, volume);
    }
}

