/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.actionhandler.IActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.OutputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.ReportId;
import org.eclipse.birt.report.soapengine.api.ReportIdType;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateData;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class AbstractBaseActionHandler
implements IActionHandler {
    protected IContext context = null;
    protected Operation operation = null;
    protected GetUpdatedObjectsResponse response = null;

    protected abstract void __execute() throws Exception;

    public AbstractBaseActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        this.context = context;
        this.operation = operation;
        this.response = response;
        this.updateTaskId();
    }

    public void execute() throws RemoteException {
        try {
            this.__execute();
        }
        catch (Exception e) {
            throw BirtUtility.makeAxisFault(e);
        }
    }

    protected boolean isValidPageNumber(HttpServletRequest request, long pageNumber, String documentName) throws RemoteException, ReportServiceException {
        InputOptions options = new InputOptions();
        options.setOption("request", request);
        return pageNumber > 0L && pageNumber <= this.getReportService().getPageCount(documentName, options, new OutputOptions());
    }

    protected long getPageNumber(HttpServletRequest request, Oprand[] params, String documentName) throws RemoteException, ReportServiceException {
        long pageNumber = -1L;
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (!"__page".equalsIgnoreCase(params[i].getName())) continue;
                try {
                    pageNumber = Integer.parseInt(params[i].getValue());
                }
                catch (NumberFormatException e) {
                    pageNumber = -1L;
                }
                InputOptions options = new InputOptions();
                options.setOption("request", request);
                long totalPageNumber = this.getReportService().getPageCount(documentName, options, new OutputOptions());
                if (pageNumber > 0L && pageNumber <= totalPageNumber) break;
                AxisFault fault = new AxisFault();
                fault.setFaultCode(new QName("DocumentProcessor.getPageNumber( )"));
                fault.setFaultString(BirtResources.getMessage("birt.viewer.actionException.INVALID_PAGE_NUMBER", new Object[]{pageNumber, totalPageNumber}));
                throw fault;
            }
        }
        return pageNumber;
    }

    protected String getBookmark(Oprand[] params, BaseAttributeBean bean) {
        assert (bean != null);
        String bookmark = null;
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (!"__bookmark".equalsIgnoreCase(params[i].getName())) continue;
                bookmark = ParameterAccessor.htmlDecode(params[i].getValue());
                break;
            }
        }
        if (bookmark == null || bookmark.length() <= 0) {
            bookmark = bean.getBookmark();
        }
        return bookmark;
    }

    protected boolean isToc(Oprand[] params, BaseAttributeBean bean) {
        assert (bean != null);
        String tocFlag = null;
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (!"__istoc".equalsIgnoreCase(params[i].getName())) continue;
                tocFlag = ParameterAccessor.htmlDecode(params[i].getValue());
                break;
            }
        }
        if (tocFlag == null || tocFlag.length() <= 0) {
            return bean.isToc();
        }
        return "true".equalsIgnoreCase(tocFlag);
    }

    protected ReportId[] parseReportId(ArrayList activeIds) throws RemoteException {
        if (activeIds == null || activeIds.size() <= 0) {
            return null;
        }
        Vector<ReportId> ids = new Vector<ReportId>();
        for (int i = 0; i < activeIds.size(); ++i) {
            String type;
            String id = (String)activeIds.get(i);
            int firstComma = id.indexOf(44);
            if (firstComma == -1) {
                AxisFault fault = new AxisFault();
                fault.setFaultCode(new QName("DocumentProcessor.parseReportId( )"));
                fault.setFaultString(BirtResources.getMessage("birt.viewer.actionException.INVALID_ID_FORMAT", new String[]{id}));
                throw fault;
            }
            int secondComma = id.indexOf(44, firstComma + 1);
            if (secondComma == -1) {
                secondComma = id.length();
            }
            if (!"Document".equalsIgnoreCase(type = id.substring(firstComma + 1, secondComma)) && !"Table".equalsIgnoreCase(type) && !"Chart".equalsIgnoreCase(type) && !"Extended".equalsIgnoreCase(type) && !"Label".equalsIgnoreCase(type) && !"Group".equalsIgnoreCase(type) && !"ColoumnInfo".equalsIgnoreCase(type)) continue;
            ReportId reportId = new ReportId();
            reportId.setId(id.substring(0, id.indexOf(44)));
            if ("Document".equalsIgnoreCase(type)) {
                reportId.setType(ReportIdType.Document);
            } else if ("Table".equalsIgnoreCase(type)) {
                reportId.setType(ReportIdType.Table);
            } else if ("Chart".equalsIgnoreCase(type) || "Extended".equalsIgnoreCase(type)) {
                reportId.setType(ReportIdType.Chart);
            } else if ("Label".equalsIgnoreCase(type)) {
                reportId.setType(ReportIdType.Label);
            } else if ("Group".equalsIgnoreCase(type)) {
                reportId.setType(ReportIdType.Group);
            } else if ("ColoumnInfo".equalsIgnoreCase(type)) {
                reportId.setType(ReportIdType.ColumnInfo);
            }
            try {
                reportId.setRptElementId(Long.parseLong(id.substring(secondComma + 1)));
            }
            catch (Exception e) {
                reportId.setRptElementId(null);
            }
            ids.add(reportId);
        }
        ReportId[] reportIds = new ReportId[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            reportIds[i] = (ReportId)ids.get(i);
        }
        return reportIds;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    public void undo() {
    }

    public void redo() {
    }

    public boolean prepare() {
        return true;
    }

    protected abstract IViewerReportService getReportService();

    protected void appendUpdate(GetUpdatedObjectsResponse response, Update update) {
        Update[] oldUpdates = response.getUpdate();
        if (oldUpdates == null || oldUpdates.length == 0) {
            response.setUpdate(new Update[]{update});
        } else {
            Update[] newUpdates = new Update[oldUpdates.length + 1];
            for (int idx = 0; idx < oldUpdates.length; ++idx) {
                newUpdates[idx] = oldUpdates[idx];
            }
            newUpdates[oldUpdates.length] = update;
            response.setUpdate(newUpdates);
        }
    }

    protected Update createUpdateData(String target, Data data) {
        UpdateData updateData = new UpdateData();
        updateData.setTarget(target);
        updateData.setData(data);
        Update update = new Update();
        update.setUpdateData(updateData);
        return update;
    }

    protected boolean getSVGFlag(Oprand[] params) {
        boolean flag = false;
        HttpServletRequest request = this.context.getRequest();
        if (ParameterAccessor.isReportParameterExist(request, "__svg")) {
            return ParameterAccessor.getSVGFlag(request);
        }
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (!"__svg".equalsIgnoreCase(params[i].getName())) continue;
                flag = "true".equalsIgnoreCase(params[i].getValue());
                break;
            }
        }
        return flag;
    }

    protected void updateTaskId() {
        if (this.operation == null) {
            return;
        }
        Oprand[] oprands = this.operation.getOprand();
        if (oprands == null) {
            return;
        }
        for (int i = 0; i < oprands.length; ++i) {
            String paramName = oprands[i].getName();
            String paramValue = oprands[i].getValue();
            if (!"__taskid".equalsIgnoreCase(paramName)) continue;
            this.context.getBean().setTaskId(paramValue);
            break;
        }
    }

    protected InputOptions createInputOptions(BaseAttributeBean bean, boolean svgFlag) {
        InputOptions options = new InputOptions();
        options.setOption("locale", bean.getLocale());
        options.setOption("timeZone", bean.getTimeZone());
        options.setOption("request", this.context.getRequest());
        options.setOption("emitterId", bean.getEmitterId());
        options.setOption("format", bean.getFormat());
        options.setOption("svgFlag", svgFlag);
        options.setOption("isMasterPageContent", bean.isMasterPageContent());
        options.setOption("isDesigner", bean.isDesigner());
        options.setOption("pageOverflow", ParameterAccessor.getPageOverflow(this.context.getRequest()));
        return options;
    }
}

