/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.birt.report.taglib.component.ParamValueField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterField
extends ParamValueField
implements Serializable {
    private static final long serialVersionUID = -8597978146893976259L;
    public static final String DEFAULT_DELIMITER = "|";
    private String name;
    private String pattern;
    private String isLocale;
    private String delimiter = "|";
    private List<Object> externalValues = new ArrayList<Object>();
    private List<String> externalDisplayTexts = new ArrayList<String>();
    private List<Object> attributeValues = null;
    private List<String> attributeDisplayTexts = null;

    public boolean validate() {
        return this.name != null && this.name.length() > 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isLocale() {
        if (this.isLocale != null) {
            return Boolean.valueOf(this.isLocale);
        }
        return this.pattern != null;
    }

    public void setLocale(String isLocale) {
        this.isLocale = isLocale;
    }

    public void setDelim(String delim) {
        this.delimiter = delim == null || delim.length() < 1 ? DEFAULT_DELIMITER : delim;
    }

    public String getDelim() {
        return this.delimiter;
    }

    public void addValue(ParamValueField valueField) {
        this.attributeValues = null;
        this.attributeDisplayTexts = null;
        this.externalValues.add(valueField.getValue());
        this.externalDisplayTexts.add(valueField.getDisplayText());
    }

    public Collection<Object> getValues() {
        if (!this.externalValues.isEmpty()) {
            return this.externalValues;
        }
        if (this.attributeValues == null) {
            this.attributeValues = this.extractValues(this.getValue());
        }
        return this.attributeValues;
    }

    public Collection<String> getDisplayTexts() {
        if (!this.externalDisplayTexts.isEmpty()) {
            return this.externalDisplayTexts;
        }
        if (this.attributeDisplayTexts == null) {
            this.attributeDisplayTexts = this.extractStringValues(this.getDisplayText());
        }
        return this.attributeDisplayTexts;
    }

    @Override
    public void setDisplayText(String displayText) {
        this.attributeDisplayTexts = null;
        super.setDisplayText(displayText);
    }

    @Override
    public void setValue(Object value) {
        this.attributeValues = null;
        super.setValue(value);
    }

    private List<Object> extractValues(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof String) {
            String valueString = (String)value;
            return Arrays.asList((Object[])valueString.split(Pattern.quote(this.getDelim())));
        }
        return Collections.singletonList(value);
    }

    private List<String> extractStringValues(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof String[]) {
            return Arrays.asList((String[])value);
        }
        if (value instanceof String) {
            String valueString = (String)value;
            return Arrays.asList(valueString.split(Pattern.quote(this.getDelim())));
        }
        return Collections.singletonList((String)value);
    }
}

