/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.style;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.dtd.core.internal.provisional.contenttype.ContentTypeIdForDTD;
import org.eclipse.wst.dtd.ui.internal.DTDUIPlugin;
import org.eclipse.wst.dtd.ui.internal.style.LineStyleProviderForDTD;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class LineStyleProviderForDTDSubSet
extends AbstractLineStyleProvider
implements LineStyleProvider {
    private IStructuredModel fInternalModel = null;
    private LineStyleProviderForDTD fInternalProvider = new LineStyleProviderForDTD();
    private StyleRange[] fInternalRanges = new StyleRange[0];
    private String fPartitioning = "org.eclipse.wst.sse.core.default_structured_text_partitioning";

    private void addStyleRanges(int lineRequestStart, int lineRequestLength, Collection holdResults, int adjustment) {
        int lineRequestEnd = lineRequestStart + lineRequestLength;
        int i = 0;
        while (i < this.fInternalRanges.length) {
            int adjustedStyleRangeStart = adjustment + this.fInternalRanges[i].start;
            int adjustedStyleRangeEnd = adjustedStyleRangeStart + this.fInternalRanges[i].length;
            if (adjustedStyleRangeEnd >= lineRequestStart && lineRequestEnd >= adjustedStyleRangeStart) {
                int end = Math.min(adjustedStyleRangeEnd, lineRequestEnd);
                StyleRange range = new StyleRange();
                range.start = Math.max(adjustedStyleRangeStart, lineRequestStart);
                range.length = end - range.start;
                range.fontStyle = this.fInternalRanges[i].fontStyle;
                range.foreground = this.fInternalRanges[i].foreground;
                range.background = this.fInternalRanges[i].background;
                holdResults.add(range);
            }
            ++i;
        }
    }

    protected TextAttribute getAttributeFor(ITextRegion region) {
        TextAttribute ta = null;
        String prefString = this.getColorPreferences().getString("dtdDefault");
        String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
        if (stylePrefs != null) {
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            boolean bold = Boolean.valueOf(stylePrefs[2]);
            ta = this.createTextAttribute(foreground, background, bold);
        }
        return ta;
    }

    protected IPreferenceStore getColorPreferences() {
        return DTDUIPlugin.getDefault().getPreferenceStore();
    }

    private IStructuredDocument getInternalDocument() {
        if (this.fInternalModel == null) {
            this.fInternalModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForDTD.ContentTypeID_DTD);
        }
        return this.fInternalModel.getStructuredDocument();
    }

    public boolean prepareRegions(ITypedRegion typedRegion, int lineRequestStart, int lineRequestLength, Collection holdResults) {
        if (!"org.eclipse.wst.dtd.DEFAULT".equals(typedRegion.getType())) {
            ITextRegion dtdContentRegion = null;
            IStructuredDocumentRegion doctype = this.fDocument.getRegionAtCharacterOffset(typedRegion.getOffset());
            if (doctype != null) {
                dtdContentRegion = doctype.getRegionAtCharacterOffset(typedRegion.getOffset());
            }
            String contents = dtdContentRegion != null ? doctype.getFullText(dtdContentRegion) : null;
            IStructuredDocument document = this.getInternalDocument();
            if (document == null) {
                return false;
            }
            this.updateStyleRanges(document, contents);
            this.addStyleRanges(lineRequestStart, lineRequestLength, holdResults, doctype.getStartOffset(dtdContentRegion));
            return true;
        }
        return false;
    }

    public void release() {
        super.release();
        if (this.fInternalProvider != null) {
            this.fInternalProvider.release();
        }
    }

    private void updateStyleRanges(IStructuredDocument document, String contents) {
        if (!document.get().equals(contents)) {
            document.set(contents);
            try {
                ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)this.getInternalDocument(), (String)this.fPartitioning, (int)0, (int)document.getLength(), (boolean)false);
                ArrayList ranges = new ArrayList();
                this.fInternalProvider.init(this.getInternalDocument(), this.fRecHighlighter);
                int i = 0;
                while (i < regions.length) {
                    this.fInternalProvider.prepareRegions(regions[i], regions[i].getOffset(), regions[i].getLength(), ranges);
                    ++i;
                }
                this.fInternalRanges = ranges.toArray(new StyleRange[0]);
            }
            catch (BadLocationException badLocationException) {
                this.fInternalRanges = new StyleRange[0];
            }
        }
    }

    protected void loadColors() {
        this.fInternalProvider.loadColors();
    }
}

