/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.engine.IContentProcessor;
import org.eclipse.birt.report.engine.internal.executor.wrap.WrappedReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.wrap.WrappedReportItemExecutor;

public class ReportExtensionExecutor
extends WrappedReportExecutor {
    ExecutionContext context;
    IReportContent reportContent;
    IContentProcessor[] processors;

    public ReportExtensionExecutor(ExecutionContext context, IReportExecutor executor, IContentProcessor[] processors) {
        super(executor);
        this.context = context;
        this.processors = processors;
    }

    public IReportContent execute() throws BirtException {
        this.reportContent = this.reportExecutor.execute();
        this.startReportProcess(this.reportContent);
        return this.reportContent;
    }

    public void close() throws BirtException {
        this.endReportProcess(this.reportContent);
        super.close();
    }

    protected IReportItemExecutor createWrappedExecutor(IReportItemExecutor executor) {
        return new ReportExtensionItemExecutor(executor);
    }

    void startReportProcess(IReportContent report) {
        if (report != null) {
            IContentProcessor[] iContentProcessorArray = this.processors;
            int n = this.processors.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProcessor processor = iContentProcessorArray[n2];
                try {
                    processor.start(report);
                }
                catch (EngineException ex) {
                    this.context.addException(ex);
                }
                ++n2;
            }
        }
    }

    void endReportProcess(IReportContent report) {
        if (report != null) {
            IContentProcessor[] iContentProcessorArray = this.processors;
            int n = this.processors.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProcessor processor = iContentProcessorArray[n2];
                try {
                    processor.end(report);
                }
                catch (EngineException ex) {
                    this.context.addException(ex);
                }
                ++n2;
            }
        }
    }

    void startItemProcess(IContent content) {
        if (content != null) {
            IContentProcessor[] iContentProcessorArray = this.processors;
            int n = this.processors.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProcessor processor = iContentProcessorArray[n2];
                try {
                    processor.startContent(content);
                }
                catch (EngineException ex) {
                    this.context.addException(ex);
                }
                ++n2;
            }
        }
    }

    void endItemProcess(IContent content) {
        if (content != null) {
            IContentProcessor[] iContentProcessorArray = this.processors;
            int n = this.processors.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProcessor processor = iContentProcessorArray[n2];
                try {
                    processor.endContent(content);
                }
                catch (EngineException ex) {
                    this.context.addException(ex);
                }
                ++n2;
            }
        }
    }

    class ReportExtensionItemExecutor
    extends WrappedReportItemExecutor {
        IContent content;

        ReportExtensionItemExecutor(IReportItemExecutor executor) {
            super(ReportExtensionExecutor.this, executor);
        }

        public IContent execute() throws BirtException {
            this.content = super.execute();
            ReportExtensionExecutor.this.startItemProcess(this.content);
            return this.content;
        }

        public void close() throws BirtException {
            ReportExtensionExecutor.this.endItemProcess(this.content);
            super.close();
        }
    }
}

