/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;

public class PageIndexReader {
    IDocArchiveReader reader;
    protected HashMap pages = new HashMap();
    long offset = 0L;

    public PageIndexReader(IDocArchiveReader reader) throws IOException {
        this.reader = reader;
    }

    protected long getOffset(String masterPage) {
        Object value = this.pages.get(masterPage);
        if (value != null && value instanceof Long) {
            return (Long)value;
        }
        return -1L;
    }

    public long getPageOffset(String masterPage) throws IOException {
        Object value;
        block15: {
            value = this.pages.get(masterPage);
            if (value != null && value instanceof Long) {
                return (Long)value;
            }
            RAInputStream indexStream = null;
            try {
                indexStream = this.reader.getStream("/content/page.idx");
                DataInputStream input = new DataInputStream((InputStream)indexStream);
                while (true) {
                    String masterPageName = IOUtil.readString((DataInputStream)input);
                    long pageOffset = IOUtil.readLong((DataInputStream)input);
                    this.pages.put(masterPageName, new Long(pageOffset));
                }
            }
            catch (EOFException eOFException) {
                if (indexStream == null) break block15;
                try {
                    indexStream.close();
                }
                catch (IOException iOException) {}
                indexStream = null;
            }
            catch (IOException ex) {
                try {
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (indexStream != null) {
                        try {
                            indexStream.close();
                        }
                        catch (IOException iOException) {}
                        indexStream = null;
                    }
                    throw throwable;
                }
            }
        }
        if ((value = this.pages.get(masterPage)) != null && value instanceof Long) {
            return (Long)value;
        }
        Iterator iterator = this.pages.values().iterator();
        if (iterator.hasNext()) {
            return (Long)iterator.next();
        }
        return 0L;
    }

    public void close() {
    }
}

