/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.ibm.icu.text.Bidi;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.nLayout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;

public class TextArea
extends AbstractArea
implements ITextArea {
    protected String text;
    protected String cachedText = null;
    protected int runLevel;
    protected TextStyle style;
    protected int textLength;
    protected int offset;
    protected boolean lineBreak;
    protected boolean blankLine = false;
    protected int maxWidth;
    protected int whiteSpaceNumber;

    TextArea(TextArea area) {
        super(area);
        this.text = area.text;
        this.runLevel = area.runLevel;
        this.style = area.style;
        this.textLength = area.textLength;
        this.offset = area.offset;
    }

    public int getBaseLine() {
        if (this.style != null) {
            return this.style.getFontInfo().getBaseline();
        }
        return super.getBaseLine();
    }

    public TextArea(String text, TextStyle style) {
        this.text = text;
        this.style = style;
        this.height = (int)(style.getFontInfo().getWordHeight() * 1000.0f);
    }

    public TextArea(TextStyle style) {
        this.style = style;
        this.height = (int)(style.getFontInfo().getWordHeight() * 1000.0f);
    }

    public void setRunLevel(int runLevel) {
        this.runLevel = runLevel;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(boolean lineBreak) {
        this.lineBreak = lineBreak;
    }

    public int getTextLength() {
        return this.textLength;
    }

    private String calculateText() {
        if (this.blankLine || this.text == null) {
            return "";
        }
        return this.text.substring(this.offset, this.offset + this.textLength);
    }

    public void addWord(int textLength, float wordWidth) {
        this.textLength += textLength;
        this.width = (int)((float)this.width + wordWidth);
    }

    public void addWordSpacing(int wordSpacing) {
        this.width += wordSpacing;
    }

    public boolean hasSpace(int width) {
        return this.maxWidth - this.width > width;
    }

    public boolean isEmpty() {
        return this.textLength == 0;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setStyle(TextStyle style) {
        this.style = style;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public String getLogicalOrderText() {
        return this.calculateText();
    }

    public String getText() {
        if (this.cachedText == null) {
            this.cachedText = (this.runLevel & 1) == 0 ? this.calculateText() : this.flip(this.calculateText());
        }
        return this.cachedText;
    }

    public void setText(String text) {
        this.cachedText = text;
    }

    public void setTextLength(int textLength) {
        this.textLength = textLength;
    }

    private String flip(String text) {
        return Bidi.writeReverse((String)text, (int)18);
    }

    public int getRunLevel() {
        return this.runLevel;
    }

    public TextStyle getTextStyle() {
        return this.style;
    }

    public void accept(IAreaVisitor visitor) {
        visitor.visitText(this);
    }

    public int getWidth() {
        int fontStyle = this.style.getFontInfo().getFontStyle();
        if (this.style.getFontInfo().getSimulation() && (2 == fontStyle || 3 == fontStyle)) {
            this.width = (int)((float)this.width + (float)this.height * EmitterUtil.getItalicHorizontalCoefficient());
        }
        return this.width;
    }

    public int getTextWidth(String text) {
        FontInfo fontInfo = this.style.getFontInfo();
        if (fontInfo != null) {
            return (int)(this.style.getFontInfo().getWordWidth(text) * 1000.0f);
        }
        return 0;
    }

    public TextArea cloneArea() {
        return new TextArea(this);
    }

    public int getWhiteSpaceNumber() {
        return this.whiteSpaceNumber;
    }

    public void setWhiteSpaceNumber(int whiteSpaceNumber) {
        this.whiteSpaceNumber = whiteSpaceNumber;
    }
}

