/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.internal.impl.PartImpl;
import org.eclipse.wst.wsdl.ui.internal.commands.AddXSDElementDeclarationCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;

public final class AddPartCommand
extends WSDLElementCommand {
    private Message message;
    private String name;
    private Part part;
    private Part originalPart;
    private QName typeOrElementName;
    private boolean useType = true;

    public AddPartCommand(Message message, String name) {
        this.message = message;
        this.name = name;
    }

    public AddPartCommand(Message message, String name, String namespace, String localName, boolean useType) {
        this.message = message;
        this.name = name;
        this.useType = useType;
        this.typeOrElementName = new QName(namespace, localName);
    }

    public AddPartCommand(Message message, Part originalPart, String name) {
        this.message = message;
        this.name = name;
        this.originalPart = originalPart;
    }

    public AddPartCommand(Message message, String name, String namespace, String localName) {
        this.message = message;
        this.name = name;
        this.typeOrElementName = new QName(namespace, localName);
    }

    public void setName(String name) {
        this.name = name;
    }

    public WSDLElement getWSDLElement() {
        return this.part;
    }

    public void run() {
        if (this.typeOrElementName == null) {
            this.typeOrElementName = this.createDefaultTypeName();
        }
        this.addNamespaceDeclaration();
        this.part = WSDLFactory.eINSTANCE.createPart();
        this.part.setName(this.name);
        if (this.originalPart == null) {
            if (this.useType) {
                this.part.setTypeName(this.typeOrElementName);
            } else {
                this.part.setElementName(this.typeOrElementName);
            }
        } else {
            if (this.originalPart.getTypeName() != null) {
                this.part.setTypeName(this.originalPart.getTypeName());
            }
            String newElementName = null;
            if (this.originalPart.getElementName() != null) {
                boolean createNewElement = true;
                if (this.originalPart.getElementDeclaration() != null && this.originalPart.getElementDeclaration().getElement() != null && !(this.originalPart.getElementDeclaration().getElement() instanceof IDOMNode)) {
                    createNewElement = false;
                }
                if (createNewElement) {
                    newElementName = this.getNewNameHelper(this.name, this.originalPart.getEnclosingDefinition(), false);
                    this.part.setElementName(new QName(this.originalPart.getElementName().getNamespaceURI(), newElementName));
                    if (this.originalPart.getEnclosingDefinition() != null) {
                        if (newElementName == null) {
                            newElementName = this.getNewNameHelper(this.name, this.originalPart.getEnclosingDefinition(), false);
                        }
                        AddXSDElementDeclarationCommand elementAction = new AddXSDElementDeclarationCommand(this.originalPart.getEnclosingDefinition(), newElementName);
                        elementAction.run();
                    }
                } else {
                    this.part.setElementName(new QName(this.originalPart.getElementName().getNamespaceURI(), this.originalPart.getElementName().getLocalPart()));
                }
            }
        }
        this.part.setEnclosingDefinition(this.message.getEnclosingDefinition());
        ((PartImpl)this.part).reconcileReferences(false);
        this.message.addPart((javax.wsdl.Part)this.part);
    }

    private void addNamespaceDeclaration() {
        Definition definition = this.message.getEnclosingDefinition();
        if (!definition.getNamespaces().containsValue(this.typeOrElementName.getNamespaceURI())) {
            definition.addNamespace("p", this.typeOrElementName.getNamespaceURI());
        }
    }

    private QName createDefaultTypeName() {
        QName qname = new QName("http://www.w3.org/2001/XMLSchema", "string");
        return qname;
    }

    private String getNewNameHelper(String base, Definition def, boolean isType) {
        Iterator xsdsIterator;
        XSDSchemaExtensibilityElement xsdElement;
        XSDSchema schema;
        EList xsdsList;
        String name = base;
        int count = 0;
        List elementList = null;
        if (def.getETypes() != null && (xsdsList = def.getETypes().getEExtensibilityElements()) != null && (schema = (xsdElement = (XSDSchemaExtensibilityElement)(xsdsIterator = xsdsList.iterator()).next()).getSchema()) != null) {
            elementList = schema.getElementDeclarations();
        }
        if (elementList != null) {
            int index = 0;
            while (index < elementList.size()) {
                XSDElementDeclaration elementDeclaration = (XSDElementDeclaration)elementList.get(index);
                if (name.equals(elementDeclaration.getName())) {
                    name = String.valueOf(name) + ++count;
                    index = 0;
                    continue;
                }
                ++index;
            }
        }
        return name;
    }
}

