/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.properties.sections;

import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11ParameterForPart;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorCSHelpIds;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.ParameterSection;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.ReferenceEditManagerHelper;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;

public class W11ParameterSection
extends ParameterSection {
    protected Button typeRadio;
    protected Button elementRadio;
    protected ComponentReferenceEditManager refManager;

    public void createControlArea() {
        super.createControlArea();
        CLabel referenceKindLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_REFERENCE_KIND);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        referenceKindLabel.setLayoutData((Object)data);
        Composite comp = this.getWidgetFactory().createComposite(this.composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginRight = 5;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.typeRadio = this.getWidgetFactory().createButton(comp, Messages._UI_LABEL_TYPE_RADIO, 16);
        this.elementRadio = this.getWidgetFactory().createButton(comp, Messages._UI_LABEL_ELEMENT_RADIO, 16);
        this.typeRadio.addSelectionListener((SelectionListener)this);
        this.elementRadio.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.typeRadio, ASDEditorCSHelpIds.PROPERTIES_PART_TYPE_RADIO);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.elementRadio, ASDEditorCSHelpIds.PROPERTIES_PART_ELEMENT_RADIO);
    }

    public void doWidgetSelected(SelectionEvent e) {
        W11ParameterForPart parameter = (W11ParameterForPart)this.getModel();
        Part part = (Part)parameter.getTarget();
        if (e.widget == this.typeRadio && this.typeRadio.getSelection()) {
            this.comboLabel.setText(Messages._UI_LABEL_TYPE);
            ComponentReferenceUtil.setComponentReference(part, true, null);
            super.refreshCombo();
        } else if (e.widget == this.elementRadio && this.elementRadio.getSelection()) {
            this.comboLabel.setText(Messages._UI_LABEL_ELEMENT);
            ComponentReferenceUtil.setComponentReference(part, false, null);
            this.refreshElementCombo();
        }
        this.composite.layout();
    }

    protected void handleComboSelection() {
        if (this.elementRadio.getSelection()) {
            String value = this.combo.getItem(this.combo.getSelectionIndex());
            W11ParameterForPart parameter = (W11ParameterForPart)this.getModel();
            if (value.equals(NEW_STRING)) {
                Command command = parameter.getSetElementCommand("SetTypeAction_AddType");
                command.execute();
            } else if (value.equals(BROWSE_STRING)) {
                Command command = parameter.getSetElementCommand("SetTypeAction_ExistingType");
                command.execute();
            } else {
                ComponentReferenceEditManager editManager = this.getElementComponentReferenceEditManager();
                ComponentSpecification spec = this.getComponentSpecificationForValue(value);
                if (spec != null) {
                    editManager.modifyComponentReference((Object)parameter, spec);
                }
            }
        } else if (this.handleTypeScenario) {
            super.handleComboSelection();
        }
    }

    protected void refreshElementCombo() {
        int index;
        IParameter param = null;
        Object model = this.getModel();
        this.setListenerEnabled(false);
        if (model instanceof IParameter) {
            param = (IParameter)model;
        }
        String name = "";
        String elementName = "ParameterSection.java";
        if (param != null) {
            name = param.getName();
            elementName = param.getComponentName();
        }
        if (!this.nameText.isFocusControl()) {
            this.nameText.setText(name);
        }
        this.combo.removeAll();
        this.combo.add(BROWSE_STRING);
        this.combo.add(NEW_STRING);
        ComponentReferenceEditManager editManager = this.getElementComponentReferenceEditManager();
        if (editManager != null) {
            ComponentSpecification[] specs = editManager.getQuickPicks();
            index = 0;
            while (index < specs.length) {
                this.combo.add(specs[index].getName());
                ++index;
            }
        }
        String[] items = this.combo.getItems();
        index = 0;
        while (index < items.length) {
            if (items[index].equals(elementName)) break;
            ++index;
        }
        if (index < items.length) {
            this.combo.select(index);
        } else {
            this.combo.setText(elementName);
        }
        this.setListenerEnabled(true);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Object model = this.getModel();
        if (model instanceof W11ParameterForPart) {
            W11ParameterForPart param = (W11ParameterForPart)model;
            Part part = (Part)param.getTarget();
            if (part.getTypeDefinition() != null) {
                this.typeRadio.setSelection(true);
                this.elementRadio.setSelection(false);
                this.comboLabel.setText(Messages._UI_LABEL_TYPE);
                this.handleTypeScenario = true;
            } else if (part.getElementDeclaration() != null) {
                this.typeRadio.setSelection(false);
                this.elementRadio.setSelection(true);
                this.comboLabel.setText(Messages._UI_LABEL_ELEMENT);
                this.handleTypeScenario = false;
                this.refreshElementCombo();
            } else {
                this.typeRadio.setSelection(false);
                this.elementRadio.setSelection(true);
            }
        }
        this.setControlForegroundColor((Control)this.elementRadio);
        this.setControlForegroundColor((Control)this.typeRadio);
        super.refresh();
        this.setListenerEnabled(true);
    }

    protected ComponentReferenceEditManager getElementComponentReferenceEditManager() {
        if (this.refManager != null) {
            return this.refManager;
        }
        this.refManager = ReferenceEditManagerHelper.getXSDElementReferenceEditManager((IASDObject)this.getModel());
        return this.refManager;
    }
}

