/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.config;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.wst.xsl.launching.config.LaunchAttribute;
import org.eclipse.wst.xsl.launching.config.LaunchPipeline;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchTransform {
    public static final String RESOURCE_TYPE = "resource";
    public static final String EXTERNAL_TYPE = "external";
    private final String stylesheet;
    private final String pathType;
    private String resolver;
    private final Set<LaunchAttribute> parameters = new HashSet<LaunchAttribute>();
    private LaunchPipeline pipeline;

    public LaunchTransform(String path, String pathType) {
        this.stylesheet = path;
        this.pathType = pathType;
    }

    public Set<LaunchAttribute> getParameters() {
        return this.parameters;
    }

    public void addParameter(LaunchAttribute parameter) {
        this.parameters.add(parameter);
    }

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public IPath getPath() throws CoreException {
        String substitutedValue = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.stylesheet);
        return Path.fromPortableString((String)substitutedValue);
    }

    public String getPathType() {
        return this.pathType;
    }

    public IPath getLocation() throws CoreException {
        IPath partialPath = this.getPath();
        IPath fullPath = null;
        if (RESOURCE_TYPE.equals(this.pathType)) {
            IFile file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(partialPath);
            fullPath = file.getLocation();
        } else if (EXTERNAL_TYPE.equals(this.pathType)) {
            fullPath = partialPath;
        }
        return fullPath;
    }

    public Element asXML(Document doc) {
        Element tdefEl = doc.createElement("Transform");
        tdefEl.setAttribute("path", this.stylesheet);
        tdefEl.setAttribute("pathType", this.pathType);
        if (this.resolver != null) {
            tdefEl.setAttribute("uriResolver", this.resolver);
        }
        Element paramsEl = doc.createElement("Parameters");
        tdefEl.appendChild(paramsEl);
        for (LaunchAttribute param : this.parameters) {
            Element propEl = doc.createElement("Parameter");
            propEl.setAttribute("name", param.uri);
            propEl.setAttribute("value", param.value);
            paramsEl.appendChild(propEl);
        }
        return tdefEl;
    }

    public static LaunchTransform fromXML(Element transformEl) {
        String path = transformEl.getAttribute("path");
        String pathType = transformEl.getAttribute("pathType");
        LaunchTransform tdef = new LaunchTransform(path, pathType);
        String uriResolver = transformEl.getAttribute("uriResolver");
        tdef.setResolver(uriResolver);
        Element paramsEl = (Element)transformEl.getElementsByTagName("Parameters").item(0);
        NodeList paramEls = paramsEl.getElementsByTagName("Parameter");
        int i = 0;
        while (i < paramEls.getLength()) {
            Element paramEl = (Element)paramEls.item(i);
            String name = paramEl.getAttribute("name");
            String type = paramEl.getAttribute("type");
            String value = paramEl.getAttribute("value");
            tdef.addParameter(new LaunchAttribute(name, type, value));
            ++i;
        }
        return tdef;
    }

    public void setPipeline(LaunchPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public LaunchPipeline getPipeline() {
        return this.pipeline;
    }
}

