/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.core.model.JavaScriptDebugModel;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptExceptionBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;

public class JavaScriptPreferencesManager
implements IEclipsePreferences.IPreferenceChangeListener {
    private static IJavaScriptLoadBreakpoint allLoadsBreakpoint = null;
    private static JavaScriptExceptionBreakpoint allExceptions = null;

    public void start() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.wst.jsdt.debug.core");
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (node.getBoolean("org.eclipse.wst.jsdt.debug.core.suspend_on_all_script_loads", false)) {
            allLoadsBreakpoint = this.createSuspendOnAllLoads();
        }
        if (node.getBoolean("org.eclipse.wst.jsdt.debug.core.suspend_on_thrown_exceptions", false)) {
            allExceptions = this.createSuspendOnException();
        }
    }

    public void stop() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.wst.jsdt.debug.core");
        if (node != null) {
            node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        try {
            if (allLoadsBreakpoint != null) {
                allLoadsBreakpoint.delete();
            }
            if (allExceptions != null) {
                allExceptions.delete();
            }
        }
        catch (CoreException e) {
            JavaScriptDebugPlugin.log(e);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("org.eclipse.wst.jsdt.debug.core.suspend_on_all_script_loads")) {
            if (event.getNewValue().equals(Boolean.TRUE.toString()) && allLoadsBreakpoint == null) {
                allLoadsBreakpoint = this.createSuspendOnAllLoads();
            } else {
                this.deleteSuspendOnAllLoads();
            }
        }
        if (event.getKey().equals("org.eclipse.wst.jsdt.debug.core.suspend_on_thrown_exceptions")) {
            if (event.getNewValue().equals(Boolean.TRUE.toString())) {
                allExceptions = this.createSuspendOnException();
            } else {
                this.deleteSuspendOnException();
            }
        }
    }

    private JavaScriptExceptionBreakpoint createSuspendOnException() {
        try {
            JavaScriptExceptionBreakpoint breakpoint = new JavaScriptExceptionBreakpoint(new HashMap());
            IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (targets[i] instanceof JavaScriptDebugTarget) {
                    ((JavaScriptDebugTarget)targets[i]).breakpointAdded(breakpoint);
                }
                ++i;
            }
            return breakpoint;
        }
        catch (DebugException de) {
            JavaScriptDebugPlugin.log(de);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteSuspendOnException() {
        if (allExceptions == null) return;
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof JavaScriptDebugTarget) {
                ((JavaScriptDebugTarget)targets[i]).breakpointRemoved(allExceptions, null);
            }
            ++i;
        }
        try {
            try {
                allExceptions.delete();
            }
            catch (CoreException e) {
                JavaScriptDebugPlugin.log(e);
            }
            Object var3_6 = null;
            allExceptions = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            allExceptions = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteSuspendOnAllLoads() {
        if (allLoadsBreakpoint == null) return;
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof JavaScriptDebugTarget) {
                ((JavaScriptDebugTarget)targets[i]).breakpointRemoved(allLoadsBreakpoint, null);
            }
            ++i;
        }
        try {
            try {
                allLoadsBreakpoint.delete();
            }
            catch (CoreException e) {
                JavaScriptDebugPlugin.log(e);
            }
            Object var3_6 = null;
            allLoadsBreakpoint = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            allLoadsBreakpoint = null;
            throw throwable;
        }
    }

    private IJavaScriptLoadBreakpoint createSuspendOnAllLoads() {
        IJavaScriptLoadBreakpoint breakpoint = null;
        try {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("org.eclipse.wst.jsdt.debug.core.global_suspend", Boolean.TRUE);
            breakpoint = JavaScriptDebugModel.createScriptLoadBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), -1, -1, map, false);
        }
        catch (DebugException e) {
            JavaScriptDebugPlugin.log(e);
        }
        if (breakpoint != null) {
            IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (targets[i] instanceof JavaScriptDebugTarget) {
                    ((JavaScriptDebugTarget)targets[i]).breakpointAdded(breakpoint);
                }
                ++i;
            }
        }
        return breakpoint;
    }

    public static void setGlobalSuspendOn(String scriptpath) {
        if (allLoadsBreakpoint != null) {
            try {
                allLoadsBreakpoint.getMarker().setAttribute("org.eclipse.wst.jsdt.debug.core.script_path", (Object)scriptpath);
            }
            catch (CoreException e) {
                JavaScriptDebugPlugin.log(e);
            }
        }
    }

    public static IJavaScriptBreakpoint[] getAllManagedBreakpoints() {
        ArrayList<IJavaScriptBreakpoint> breakpoints = new ArrayList<IJavaScriptBreakpoint>();
        if (allLoadsBreakpoint != null) {
            breakpoints.add(allLoadsBreakpoint);
        }
        if (allExceptions != null) {
            breakpoints.add(allExceptions);
        }
        return breakpoints.toArray(new IJavaScriptBreakpoint[breakpoints.size()]);
    }
}

