/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.ExprUtil;

public class BindingIOUtil {
    public static void saveBinding(DataOutputStream dos, IBinding binding) throws DataException {
        int type = binding.getDataType();
        String name = binding.getBindingName();
        String function = binding.getAggrFunction();
        IBaseExpression expr = binding.getExpression();
        IBaseExpression filter = binding.getFilter();
        List arguments = binding.getArguments();
        List aggregateOn = binding.getAggregatOns();
        try {
            IOUtil.writeInt((OutputStream)dos, (int)type);
            IOUtil.writeString((DataOutputStream)dos, (String)name);
            IOUtil.writeString((DataOutputStream)dos, (String)function);
            ExprUtil.saveBaseExpr(dos, expr);
            ExprUtil.saveBaseExpr(dos, filter);
            IOUtil.writeInt((OutputStream)dos, (int)arguments.size());
            int i = 0;
            while (i < arguments.size()) {
                ExprUtil.saveBaseExpr(dos, (IBaseExpression)arguments.get(i));
                ++i;
            }
            IOUtil.writeInt((OutputStream)dos, (int)aggregateOn.size());
            i = 0;
            while (i < aggregateOn.size()) {
                IOUtil.writeString((DataOutputStream)dos, (String)aggregateOn.get(i).toString());
                ++i;
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public static IBinding loadBinding(DataInputStream dis) throws IOException, DataException {
        int type = IOUtil.readInt((InputStream)dis);
        String name = IOUtil.readString((DataInputStream)dis);
        String function = IOUtil.readString((DataInputStream)dis);
        IBaseExpression expr = ExprUtil.loadBaseExpr(dis);
        IBaseExpression filter = ExprUtil.loadBaseExpr(dis);
        Binding binding = new Binding(name);
        binding.setAggrFunction(function);
        binding.setDataType(type);
        binding.setExpression(expr);
        binding.setFilter(filter);
        int argSize = IOUtil.readInt((InputStream)dis);
        int i = 0;
        while (i < argSize) {
            binding.addArgument(ExprUtil.loadBaseExpr(dis));
            ++i;
        }
        int aggrSize = IOUtil.readInt((InputStream)dis);
        int i2 = 0;
        while (i2 < aggrSize) {
            binding.addAggregateOn(IOUtil.readString((DataInputStream)dis));
            ++i2;
        }
        return binding;
    }
}

