/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import com.ibm.icu.util.ULocale;
import java.util.Hashtable;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.PropertySecurity;
import org.eclipse.birt.data.engine.odaconsumer.DataSetCapabilities;
import org.eclipse.birt.data.engine.odaconsumer.ExceptionHandler;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection
extends ExceptionHandler {
    private String m_dataSourceId;
    private IConnection m_connection;
    private Hashtable<String, DataSetCapabilities> m_cachedDsMetaData;
    private static String sm_className = Connection.class.getName();

    Connection(IConnection connection, String dataSourceId) throws OdaException {
        super(sm_className);
        if (Connection.getLogger().isLoggingEnterExitLevel()) {
            Connection.getLogger().entering(sm_className, "Connection", new Object[]{connection, dataSourceId});
        }
        assert (connection != null && connection.isOpen());
        this.m_dataSourceId = dataSourceId;
        this.m_connection = connection;
        Connection.getLogger().exiting(sm_className, "Connection", this);
    }

    public boolean isOpen() throws DataException {
        Connection.getLogger().entering(sm_className, "isOpen");
        try {
            boolean ret = this.m_connection.isOpen();
            Connection.getLogger().exiting(sm_className, "isOpen", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotCheckOpenConnection", "isOpen");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException(ex, "odaconsumer.CannotCheckOpenConnection", "isOpen");
        }
        return false;
    }

    public int getMaxQueries() throws DataException {
        Connection.getLogger().entering(sm_className, "getMaxQueries");
        try {
            int ret = this.m_connection.getMaxQueries();
            Connection.getLogger().exiting(sm_className, "getMaxQueries", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotGetMaxStatements", "getMaxQueries");
        }
        catch (UnsupportedOperationException ex) {
            Connection.getLogger().logp(Level.INFO, sm_className, "getMaxQueries", "Cannot get max queries.", ex);
        }
        return 0;
    }

    public DataSetCapabilities getMetaData(String dataSetType) throws DataException {
        Connection.getLogger().entering(sm_className, "getMetaData", dataSetType);
        String cachedKey = dataSetType == null ? this.getDataSourceId() : dataSetType;
        DataSetCapabilities capabilities = this.getCachedDsMetaData().get(cachedKey);
        if (capabilities == null) {
            IDataSetMetaData dsMetaData = null;
            try {
                dsMetaData = this.m_connection.getMetaData(dataSetType);
            }
            catch (OdaException ex) {
                this.throwException((Throwable)ex, "odaconsumer.CannotGetDataSetMetaData", dataSetType, "getMetaData");
            }
            catch (UnsupportedOperationException ex) {
                this.throwException((Throwable)ex, "odaconsumer.CannotGetDataSetMetaData", dataSetType, "getMetaData");
            }
            capabilities = new DataSetCapabilities(dsMetaData);
            this.getCachedDsMetaData().put(cachedKey, capabilities);
        }
        Connection.getLogger().exiting(sm_className, "getMetaData", capabilities);
        return capabilities;
    }

    public PreparedStatement prepareStatement(String query, String dataSetType) throws DataException {
        return this.prepareStatement(query, dataSetType, null);
    }

    public PreparedStatement prepareStatement(String query, String dataSetType, QuerySpecification querySpec) throws DataException {
        if (Connection.getLogger().isLoggingEnterExitLevel()) {
            Connection.getLogger().entering(sm_className, "prepareStatement(String,String,QuerySpecification)", new Object[]{query, dataSetType});
        }
        IQuery statement = this.prepareOdaQuery(query, dataSetType, querySpec);
        PreparedStatement ret = new PreparedStatement(statement, dataSetType, this, query);
        Connection.getLogger().exiting(sm_className, "prepareStatement(String,String,QuerySpecification)", ret);
        return ret;
    }

    public void setLocale(ULocale locale) throws DataException {
        Connection.getLogger().entering(sm_className, "setLocale(ULocale)");
        try {
            this.m_connection.setLocale(locale);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotSetConnectionLocale", locale, "setLocale(ULocale)");
        }
        catch (UnsupportedOperationException ex) {
            Connection.getLogger().logp(Level.WARNING, sm_className, "setLocale(ULocale)", "Unable to set locale: " + locale + ". Using default locale instead.", ex);
        }
        Connection.getLogger().exiting(sm_className, "setLocale(ULocale)");
    }

    public void close() throws DataException {
        Connection.getLogger().entering(sm_className, "close");
        try {
            this.m_connection.close();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotCloseConnection", "close");
        }
        catch (UnsupportedOperationException ex) {
            Connection.getLogger().logp(Level.WARNING, sm_className, "close", "Cannot close connection.", ex);
        }
        Connection.getLogger().exiting(sm_className, "close");
    }

    private Hashtable<String, DataSetCapabilities> getCachedDsMetaData() {
        if (this.m_cachedDsMetaData == null) {
            this.m_cachedDsMetaData = PropertySecurity.createHashtable();
        }
        return this.m_cachedDsMetaData;
    }

    String getDataSourceId() {
        return this.m_dataSourceId;
    }

    IQuery prepareOdaQuery(String query, String dataSetType, QuerySpecification querySpec) throws DataException {
        if (Connection.getLogger().isLoggingEnterExitLevel()) {
            Connection.getLogger().entering(sm_className, "prepareOdaQuery", new Object[]{query, dataSetType, querySpec});
        }
        try {
            assert (this.m_connection.isOpen());
            IQuery statement = this.m_connection.newQuery(dataSetType);
            this.setOdaQuerySpec(statement, querySpec);
            statement.prepare(query);
            Connection.getLogger().exiting(sm_className, "prepareOdaQuery", statement);
            return statement;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotPrepareStatement", new Object[]{query, dataSetType}, "prepareOdaQuery");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotPrepareStatement", new Object[]{query, dataSetType}, "prepareOdaQuery");
        }
        return null;
    }

    private void setOdaQuerySpec(IQuery statement, QuerySpecification querySpec) throws OdaException {
        Connection.getLogger().entering(sm_className, "setOdaQuerySpec", querySpec);
        try {
            if (querySpec != null) {
                statement.setSpecification(querySpec);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Connection.getLogger().logp(Level.FINE, sm_className, "setOdaQuerySpec", "Ignoring the UnsupportedOperationException thrown by ODA driver (" + this.getDataSourceId() + ") on IQuery#setSpecification.  This call is optional and does not affect query processing.");
        }
        Connection.getLogger().exiting(sm_className, "setOdaQuerySpec");
    }
}

