/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.olap.data.document.IRandomDataAccessObject;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;

public abstract class AbstractBufferedRandomAccessObject
implements IRandomDataAccessObject {
    private static Logger logger = Logger.getLogger(AbstractBufferedRandomAccessObject.class.getName());
    protected FileBufferStruct currBuf;
    protected FileBufferStruct altBuf;

    public AbstractBufferedRandomAccessObject(int bufferSize) throws IOException {
        if (bufferSize < 1) {
            throw new Error("Buffer size must be at least 1");
        }
        this.currBuf = new FileBufferStruct();
        this.altBuf = new FileBufferStruct();
        this.currBuf.bytes = new byte[bufferSize];
        this.currBuf.modified = false;
        this.altBuf.bytes = new byte[bufferSize];
        this.altBuf.filePos = -1L;
    }

    protected abstract long delegateGetFilePointer() throws IOException;

    public void setLength(long newLength) throws IOException {
        this.delegateSetLength(newLength);
        if (newLength < this.currBuf.filePos) {
            this.currBuf.filePos = newLength;
            this.currBuf.pos = 0;
            this.currBuf.dataLen = 0;
        } else if (newLength < this.currBuf.filePos + (long)this.currBuf.dataLen) {
            this.currBuf.dataLen = (int)(newLength - this.currBuf.filePos);
            if (this.currBuf.dataLen > this.currBuf.pos) {
                this.currBuf.pos = this.currBuf.dataLen;
            }
        }
    }

    protected abstract void delegateSetLength(long var1) throws IOException;

    public long getFilePointer() {
        return this.currBuf.filePos + (long)this.currBuf.pos;
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b & 0xFF;
    }

    public byte readByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public Date readDate() throws IOException {
        return new Date(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    break;
                }
                default: {
                    input.append((char)c);
                }
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public BigDecimal readBigDecimal() throws IOException {
        String str = this.readUTF();
        return new BigDecimal(str);
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    public void writeByte(int b) throws IOException {
        this.write(b);
    }

    public void writeShort(int s) throws IOException {
        this.write(s >>> 8 & 0xFF);
        this.write(s >>> 0 & 0xFF);
    }

    public void writeChar(int ch) throws IOException {
        this.writeShort(ch);
    }

    public void writeInt(int i) throws IOException {
        this.write(i >>> 24 & 0xFF);
        this.write(i >>> 16 & 0xFF);
        this.write(i >>> 8 & 0xFF);
        this.write(i >>> 0 & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    public void writeDate(Date date) throws IOException {
        this.writeLong(date.getTime());
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double f) throws IOException {
        this.writeLong(Double.doubleToLongBits(f));
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws IOException {
        this.writeUTF(bigDecimal.toString());
    }

    public void writeUTF(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(utflen >>> 8 & 0xFF);
        this.write(utflen >>> 0 & 0xFF);
        i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
            } else {
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int pos, int len) throws IOException {
        int n = 0;
        while (n < len) {
            int count = this.read(b, pos + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    public void writeBytes(String s) throws IOException {
        byte[] b = s.getBytes();
        this.write(b, 0, b.length);
    }

    public void writeChars(String s) throws IOException {
        int clen = s.length();
        int blen = 2 * clen;
        byte[] b = new byte[blen];
        char[] c = new char[clen];
        s.getChars(0, clen, c, 0);
        int i = 0;
        int j = 0;
        while (i < clen) {
            b[j++] = (byte)(c[i] >>> 8);
            b[j++] = (byte)(c[i] >>> 0);
            ++i;
        }
        this.write(b, 0, blen);
    }

    public long length() throws IOException {
        long fileLen = this.delegateLength();
        if (this.currBuf.filePos + (long)this.currBuf.dataLen > fileLen) {
            return this.currBuf.filePos + (long)this.currBuf.dataLen;
        }
        return fileLen;
    }

    public void writeObject(Object o) throws IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(buff);
        oo.writeObject(o);
        oo.close();
        byte[] bytes = buff.toByteArray();
        this.writeBytes(new Bytes(bytes));
    }

    public Object readObject() throws IOException {
        byte[] bytes = this.readBytes().bytesValue();
        final ClassLoader loader = DataEngineSession.getCurrentClassLoader();
        ObjectInputStream oo = new ObjectInputStream(new ByteArrayInputStream(bytes)){

            protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return Class.forName(desc.getName(), false, loader);
            }
        };
        Object obValue = null;
        try {
            obValue = oo.readObject();
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Failed to read object", e);
        }
        return obValue;
    }

    protected abstract long delegateLength() throws IOException;

    public int read() throws IOException {
        if (this.currBuf.pos < this.currBuf.dataLen) {
            return this.currBuf.bytes[this.currBuf.pos++] & 0xFF;
        }
        this.syncBuffer(this.currBuf.filePos + (long)this.currBuf.pos);
        if (this.currBuf.dataLen == 0) {
            throw new EOFException();
        }
        return this.read();
    }

    public Bytes readBytes() throws IOException {
        byte[] b = new byte[this.readInt()];
        this.read(b, 0, b.length);
        return new Bytes(b);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int pos, int len) throws IOException {
        if (this.currBuf.pos + len <= this.currBuf.dataLen) {
            System.arraycopy(this.currBuf.bytes, this.currBuf.pos, b, pos, len);
            this.currBuf.pos += len;
            return len;
        }
        this.syncBuffer(this.currBuf.filePos + (long)this.currBuf.pos);
        if (this.currBuf.dataLen < this.currBuf.bytes.length) {
            int readLen = Math.min(len, this.currBuf.dataLen);
            if (readLen == 0) {
                return -1;
            }
            System.arraycopy(this.currBuf.bytes, this.currBuf.pos, b, pos, readLen);
            this.currBuf.pos += readLen;
            return readLen;
        }
        if (this.currBuf.dataLen >= len) {
            return this.read(b, pos, len);
        }
        this.delegateSeek(this.currBuf.filePos);
        int readLen = this.delegateRead(b, pos, len);
        this.currBuf.filePos += (long)readLen;
        this.currBuf.dataLen = 0;
        this.currBuf.pos = 0;
        return readLen;
    }

    protected abstract void delegateSeek(long var1) throws IOException;

    protected abstract int delegateRead(byte[] var1, int var2, int var3) throws IOException;

    protected abstract int delegateRead(byte[] var1) throws IOException;

    public void seek(long pos) throws IOException {
        long newBufPos = pos - this.currBuf.filePos;
        if (newBufPos >= 0L && newBufPos < (long)this.currBuf.dataLen) {
            this.currBuf.pos = (int)newBufPos;
        } else {
            this.syncBuffer(pos);
        }
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skipBytes((long)n);
    }

    public long skipBytes(long n) throws IOException {
        try {
            this.seek(this.currBuf.filePos + (long)this.currBuf.pos + n);
            return n;
        }
        catch (EOFException eOFException) {
            return -1L;
        }
    }

    public void writeBytes(Bytes b) throws IOException {
        this.writeInt(b.bytesValue().length);
        this.write(b.bytesValue(), 0, b.bytesValue().length);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int pos, int len) throws IOException {
        if (this.currBuf.pos + len <= this.currBuf.bytes.length) {
            System.arraycopy(b, pos, this.currBuf.bytes, this.currBuf.pos, len);
            this.currBuf.pos += len;
            this.currBuf.modified = true;
            if (this.currBuf.pos > this.currBuf.dataLen) {
                this.currBuf.dataLen = this.currBuf.pos;
            }
        } else if (len <= this.currBuf.bytes.length) {
            this.syncBuffer(this.currBuf.filePos + (long)this.currBuf.pos);
            this.write(b, pos, len);
        } else {
            this.delegateSeek(this.currBuf.filePos + (long)this.currBuf.pos);
            this.delegateWrite(b, pos, len);
            this.syncBuffer(this.currBuf.filePos + (long)this.currBuf.pos + (long)len);
        }
    }

    protected abstract void delegateWrite(byte[] var1, int var2, int var3) throws IOException;

    public void write(int b) throws IOException {
        if (this.currBuf.pos < this.currBuf.bytes.length) {
            this.currBuf.bytes[this.currBuf.pos++] = (byte)b;
            this.currBuf.modified = true;
            if (this.currBuf.pos > this.currBuf.dataLen) {
                ++this.currBuf.dataLen;
            }
        } else {
            this.syncBuffer(this.currBuf.filePos + (long)this.currBuf.pos);
            this.write(b);
        }
    }

    public void flush() throws IOException {
        this.commitBuffer();
    }

    public void close() throws IOException {
        this.flush();
        this.delegateClose();
    }

    protected abstract void delegateClose() throws IOException;

    protected int syncBuffer(long new_FP) throws IOException {
        this.commitBuffer();
        this.delegateSeek(new_FP);
        this.currBuf.filePos = new_FP;
        this.fillBuffer();
        return this.currBuf.dataLen;
    }

    protected void fillBuffer() throws IOException {
        this.currBuf.filePos = this.delegateGetFilePointer();
        this.currBuf.dataLen = this.delegateRead(this.currBuf.bytes);
        this.currBuf.pos = 0;
        if (this.currBuf.dataLen < 0) {
            this.currBuf.dataLen = 0;
        }
    }

    protected void commitBuffer() throws IOException {
        if (this.currBuf.modified) {
            this.delegateSeek(this.currBuf.filePos);
            this.delegateWrite(this.currBuf.bytes, 0, this.currBuf.dataLen);
            this.currBuf.modified = false;
        }
    }

    protected class FileBufferStruct {
        public byte[] bytes;
        public int pos;
        public int dataLen;
        public boolean modified;
        public long filePos;

        protected FileBufferStruct() {
        }
    }
}

