/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import org.eclipse.birt.data.engine.aggregation.AggregationUtil;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.ColumnInfo;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.FacttableRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IAggregationCalculator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFacttableFilterEvalHelper;

public abstract class BaseAggregationCalculator
implements IAggregationCalculator {
    protected Accumulator[] accumulators;
    protected int[] measureIndexes;
    protected FacttableRow facttableRow;
    protected int[] keyLevelIndex;
    protected IAggregationResultSet aggrResultSet;
    protected AggregationDefinition aggregation;
    protected ColumnInfo[] paraInfo;

    BaseAggregationCalculator(AggregationDefinition aggregation, IAggregationResultSet aggrResultSet) throws DataException, IOException {
        this.aggregation = aggregation;
        this.aggrResultSet = aggrResultSet;
        this.getParameterColIndex();
        this.initParaInfo();
        this.createAccumulators();
    }

    protected void initParaInfo() throws DataException, IOException {
        AggregationFunctionDefinition[] aggregationFunctions = this.aggregation.getAggregationFunctions();
        if (aggregationFunctions != null) {
            this.measureIndexes = new int[aggregationFunctions.length];
            int i = 0;
            while (i < aggregationFunctions.length) {
                IAggrFunction aggregationFunc = AggregationManager.getInstance().getAggregation(aggregationFunctions[i].getFunctionName());
                if (this.aggregation == null) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.UnsupportedFunction")) + aggregationFunctions[i].getFunctionName());
                }
                if (!AggregationUtil.needDataField(aggregationFunc)) {
                    this.paraInfo[i] = null;
                }
                String measureName = aggregationFunctions[i].getMeasureName();
                this.measureIndexes[i] = this.aggrResultSet.getAggregationIndex(measureName);
                if (this.measureIndexes[i] == -1 && measureName != null) {
                    throw new DataException("data.olap.measureNameNotFound", measureName);
                }
                ++i;
            }
        }
    }

    protected void createAccumulators() throws DataException {
        AggregationFunctionDefinition[] aggregationFunctions = this.aggregation.getAggregationFunctions();
        if (aggregationFunctions != null) {
            this.accumulators = new Accumulator[aggregationFunctions.length];
            int i = 0;
            while (i < aggregationFunctions.length) {
                IAggrFunction aggregationFunc = AggregationManager.getInstance().getAggregation(aggregationFunctions[i].getFunctionName());
                if (aggregationFunc == null) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.UnsupportedFunction")) + aggregationFunctions[i].getFunctionName());
                }
                this.accumulators[i] = aggregationFunc.newAccumulator();
                this.accumulators[i].start();
                ++i;
            }
        }
    }

    protected void getParameterColIndex() throws DataException {
        AggregationFunctionDefinition[] functions = this.aggregation.getAggregationFunctions();
        if (functions == null || functions.length == 0) {
            return;
        }
        this.paraInfo = new ColumnInfo[functions.length];
        int j = 0;
        while (j < functions.length) {
            DimColumn paraCol = functions[j].getParaCol();
            if (paraCol != null) {
                this.paraInfo[j] = this.findColumnIndex(paraCol);
            }
            ++j;
        }
    }

    private ColumnInfo findColumnIndex(DimColumn paraColumn) {
        ColumnInfo paraInfo;
        int levelIndex = this.aggrResultSet.getLevelIndex(new DimLevel(paraColumn.getDimensionName(), paraColumn.getLevelName()));
        int columnIndex = this.aggrResultSet.getLevelKeyIndex(levelIndex, paraColumn.getColumnName());
        if (columnIndex == -1) {
            columnIndex = this.aggrResultSet.getLevelAttributeIndex(levelIndex, paraColumn.getColumnName());
            paraInfo = new ColumnInfo(-1, levelIndex, columnIndex, false);
        } else {
            paraInfo = new ColumnInfo(-1, levelIndex, columnIndex, true);
        }
        return paraInfo;
    }

    protected MeasureInfo[] getMeasureInfo() throws IOException {
        MeasureInfo[] measureInfos = new MeasureInfo[this.aggrResultSet.getAggregationCount()];
        int i = 0;
        while (i < measureInfos.length) {
            measureInfos[i] = new MeasureInfo(this.aggrResultSet.getAggregationName(i), this.aggrResultSet.getAggregationDataType(i));
            ++i;
        }
        return measureInfos;
    }

    protected int[] getKeyLevelIndexs(DimLevel[] keyLevels) throws DataException {
        int[] keyLevelIndexes = new int[keyLevels.length];
        DimLevel[] allLevels = this.aggrResultSet.getAllLevels();
        int i = 0;
        while (i < keyLevels.length) {
            keyLevelIndexes[i] = -1;
            int j = 0;
            while (j < allLevels.length) {
                if (keyLevels[i].equals(allLevels[j])) {
                    keyLevelIndexes[i] = j;
                }
                ++j;
            }
            if (keyLevelIndexes[i] == -1) {
                throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentLevel")) + keyLevels[i].getLevelName());
            }
            ++i;
        }
        return keyLevelIndexes;
    }

    protected void onRow(IAggregationResultRow row) throws DataException {
        if (this.accumulators == null) {
            return;
        }
        int i = 0;
        while (i < this.accumulators.length) {
            if (this.getFilterResult(row, i)) {
                this.accumulators[i].onRow(this.getAccumulatorParameter(this.aggregation.getAggregationFunctions()[i], row, i));
            }
            ++i;
        }
    }

    protected Object[] getAccumulatorParameter(AggregationFunctionDefinition function, IAggregationResultRow row, int funcIndex) throws DataException {
        Object[] parameters = null;
        if (this.paraInfo[funcIndex] == null || this.paraInfo[funcIndex].getLevelIndex() == -1) {
            if (this.getParaNum(funcIndex) <= 1) {
                parameters = new Object[1];
                if (this.measureIndexes[funcIndex] < 0) {
                    return null;
                }
                parameters[0] = row.getAggregationValues()[this.measureIndexes[funcIndex]];
            } else {
                parameters = new Object[2];
                parameters[1] = function.getParaValue();
                if (this.measureIndexes[funcIndex] >= 0) {
                    parameters[0] = row.getAggregationValues()[this.measureIndexes[funcIndex]];
                }
            }
        } else {
            parameters = new Object[2];
            parameters[0] = this.measureIndexes[funcIndex] < 0 ? null : row.getAggregationValues()[this.measureIndexes[funcIndex]];
            Member member = row.getLevelMembers()[this.paraInfo[funcIndex].getLevelIndex()];
            parameters[1] = this.paraInfo[funcIndex].isKey() ? member.getKeyValues()[this.paraInfo[funcIndex].getColumnIndex()] : member.getAttributes()[this.paraInfo[funcIndex].getColumnIndex()];
        }
        return parameters;
    }

    private int getParaNum(int index) throws DataException {
        AggregationFunctionDefinition[] aggregationFunctions = this.aggregation.getAggregationFunctions();
        IAggrFunction aggregationFunc = AggregationManager.getInstance().getAggregation(aggregationFunctions[index].getFunctionName());
        if (aggregationFunc.getParameterDefn() == null) {
            return 0;
        }
        return aggregationFunc.getParameterDefn().length;
    }

    protected boolean getFilterResult(IAggregationResultRow row, int functionNo) throws DataException {
        this.facttableRow.setMeasure(row.getAggregationValues());
        IJSFacttableFilterEvalHelper filterEvalHelper = this.aggregation.getAggregationFunctions()[functionNo].getFilterEvalHelper();
        if (filterEvalHelper == null) {
            return true;
        }
        return filterEvalHelper.evaluateFilter(this.facttableRow);
    }

    protected AggregationResultRow newAggregationResultRow(IAggregationResultRow row) throws DataException, IOException {
        AggregationResultRow resultObj = new AggregationResultRow();
        if (this.keyLevelIndex != null && this.keyLevelIndex.length > 0) {
            Member[] members = new Member[this.keyLevelIndex.length];
            int i = 0;
            while (i < this.keyLevelIndex.length) {
                members[i] = row.getLevelMembers()[this.keyLevelIndex[i]];
                ++i;
            }
            resultObj.setLevelMembers(members);
        }
        resultObj.setAggregationValues(new Object[this.accumulators.length]);
        return resultObj;
    }

    protected String[][] getKeyNames() {
        if (this.keyLevelIndex == null) {
            return null;
        }
        String[][] result = new String[this.keyLevelIndex.length][];
        int i = 0;
        while (i < this.keyLevelIndex.length) {
            String[][] keyNames = this.aggrResultSet.getKeyNames();
            if (keyNames != null && keyNames.length > this.keyLevelIndex[i]) {
                result[i] = keyNames[this.keyLevelIndex[i]];
            }
            ++i;
        }
        return result;
    }

    protected String[][] getAttributeNames() {
        if (this.keyLevelIndex == null) {
            return null;
        }
        String[][] result = new String[this.keyLevelIndex.length][];
        int i = 0;
        while (i < this.keyLevelIndex.length) {
            String[][] attributeNames = this.aggrResultSet.getAttributeNames();
            if (attributeNames != null && attributeNames.length > this.keyLevelIndex[i]) {
                result[i] = attributeNames[this.keyLevelIndex[i]];
            }
            ++i;
        }
        return result;
    }
}

