/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivider;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivision;

public class FactTable {
    private String name;
    private DimensionDivider.DimensionPositionSeeker.DimensionInfo[] dimensionInfo;
    private MeasureInfo[] measureInfo;
    private int segmentCount;
    private DimensionDivision[] dimensionDivision;
    private IDocumentManager documentManager;
    private DimensionDivider.CombinedPositionContructor combinedPositionCalculator;
    private static Logger logger = Logger.getLogger(FactTable.class.getName());

    FactTable(String name, IDocumentManager documentManager, DimensionDivider.DimensionPositionSeeker.DimensionInfo[] dimensionInfo, MeasureInfo[] measureInfo, int segmentCount, DimensionDivision[] dimensionDivision) {
        Object[] params = new Object[]{name, documentManager, dimensionInfo, measureInfo, new Integer(segmentCount), dimensionDivision};
        logger.entering(FactTable.class.getName(), "FactTable", params);
        this.name = name;
        this.dimensionInfo = dimensionInfo;
        this.measureInfo = measureInfo;
        this.segmentCount = segmentCount;
        this.dimensionDivision = dimensionDivision;
        this.documentManager = documentManager;
        this.combinedPositionCalculator = new DimensionDivider.CombinedPositionContructor(dimensionDivision);
        logger.exiting(FactTable.class.getName(), "FactTable");
    }

    public DimensionDivision[] getDimensionDivision() {
        return this.dimensionDivision;
    }

    public DimensionDivider.CombinedPositionContructor getCombinedPositionCalculator() {
        return this.combinedPositionCalculator;
    }

    public DimensionDivider.DimensionPositionSeeker.DimensionInfo[] getDimensionInfo() {
        return this.dimensionInfo;
    }

    public MeasureInfo[] getMeasureInfo() {
        return this.measureInfo;
    }

    public String[] getMeasureNames() {
        String[] measureNames = new String[this.measureInfo.length];
        int i = 0;
        while (i < measureNames.length) {
            measureNames[i] = this.measureInfo[i].getMeasureName();
            ++i;
        }
        return measureNames;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public DimensionDivision[] getSubDimensions() {
        return this.dimensionDivision;
    }

    public IDocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public int getDimensionIndex(String dimensionName) {
        int i = 0;
        while (i < this.dimensionInfo.length) {
            if (this.dimensionInfo[i].dimensionName.equals(dimensionName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getMeasureIndex(String measureName) {
        int i = 0;
        while (i < this.measureInfo.length) {
            if (this.measureInfo[i].getMeasureName().equals(measureName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }
}

