/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.ICollectionConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.util.TempPathManager;
import org.eclipse.birt.data.engine.olap.util.ComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.filter.AggrMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.BaseDimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IAggrMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFacttableFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.JSFacttableFilterEvalHelper;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeQueryExecutor {
    private ICubeQueryDefinition defn;
    private Scriptable scope;
    private DataEngineSession session;
    private DataEngineContext context;
    private String queryResultsId;
    private IBaseQueryResults outResults;
    private List<IJSFilterHelper> dimensionFilterEvalHelpers;
    private List<IAggrMeasureFilterEvalHelper> aggrMeasureFilterEvalHelpers;
    private List<IJSFacttableFilterEvalHelper> advancedFacttableBasedFilterEvalHelper;
    private static final int DIMENSION_FILTER = 0;
    private static final int AGGR_MEASURE_FILTER = 1;
    private static final int FACTTABLE_FILTER = 2;

    public CubeQueryExecutor(IBaseQueryResults outResults, ICubeQueryDefinition defn, DataEngineSession session, Scriptable scope, DataEngineContext context) throws DataException {
        this.defn = defn;
        this.scope = scope;
        this.context = context;
        this.session = session;
        TempPathManager.setTempPath(session.getTempDir());
        this.outResults = outResults;
        this.dimensionFilterEvalHelpers = new ArrayList<IJSFilterHelper>();
        this.aggrMeasureFilterEvalHelpers = new ArrayList<IAggrMeasureFilterEvalHelper>();
        this.advancedFacttableBasedFilterEvalHelper = new ArrayList<IJSFacttableFilterEvalHelper>();
        if (context.getMode() != 2 || defn.getQueryResultsID() == null) {
            this.populateFilterHelpers();
        }
    }

    private void populateFilterHelpers() throws DataException {
        List filters = this.defn.getFilters();
        new ArrayList();
        Set<DimLevel> dimLevelInCubeQuery = this.getDimLevelsDefinedInCubeQuery();
        int i = 0;
        while (i < filters.size()) {
            IFilterDefinition filter = (IFilterDefinition)filters.get(i);
            switch (this.getFilterType(filter, dimLevelInCubeQuery)) {
                case 0: {
                    this.dimensionFilterEvalHelpers.add(BaseDimensionFilterEvalHelper.createFilterHelper(this.outResults, this.scope, this.defn, filter, this.session.getEngineContext().getScriptContext()));
                    break;
                }
                case 1: {
                    this.aggrMeasureFilterEvalHelpers.add(new AggrMeasureFilterEvalHelper(this.outResults, this.scope, this.defn, filter, this.session.getEngineContext().getScriptContext()));
                    break;
                }
                default: {
                    this.advancedFacttableBasedFilterEvalHelper.add(new JSFacttableFilterEvalHelper(this.scope, this.session.getEngineContext().getScriptContext(), filter, this.outResults, this.defn));
                }
            }
            ++i;
        }
    }

    private int getFilterType(IFilterDefinition filter, Set<DimLevel> dimLevelInCubeQuery) throws DataException {
        if (!(filter instanceof ICubeFilterDefinition)) {
            if (filter.getExpression() instanceof ICollectionConditionalExpression) {
                Collection<IScriptExpression> exprs = ((ICollectionConditionalExpression)((Object)filter.getExpression())).getExpr();
                HashSet<String> dimensionSet = new HashSet<String>();
                Iterator<IScriptExpression> exprsIterator = exprs.iterator();
                while (exprsIterator.hasNext()) {
                    Iterator dimLevels = OlapExpressionCompiler.getReferencedDimLevel(exprsIterator.next(), this.defn.getBindings()).iterator();
                    while (dimLevels.hasNext()) {
                        dimensionSet.add(((DimLevel)dimLevels.next()).getDimensionName());
                    }
                }
                if (dimensionSet.size() == 1) {
                    return 0;
                }
                return 2;
            }
            return 0;
        }
        ICubeFilterDefinition cubeFilter = (ICubeFilterDefinition)filter;
        if (cubeFilter.getTargetLevel() != null) {
            return 0;
        }
        String measure = OlapExpressionCompiler.getReferencedScriptObject(filter.getExpression(), "measure");
        if (measure != null) {
            return 2;
        }
        List bindingName = ExpressionCompilerUtil.extractColumnExpression(filter.getExpression(), "data");
        if (CubeQueryExecutor.existAggregationBinding(bindingName, this.defn.getBindings())) {
            return 1;
        }
        return 2;
    }

    private static boolean existAggregationBinding(List bindingName, List bindings) throws DataException {
        int i = 0;
        while (i < bindingName.size()) {
            int j = 0;
            while (j < bindings.size()) {
                IBinding binding = (IBinding)bindings.get(j);
                if (bindingName.get(i).equals(binding.getBindingName()) && OlapExpressionUtil.isAggregationBinding(binding)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public List<IJSFilterHelper> getDimensionFilterEvalHelpers() throws DataException {
        return this.dimensionFilterEvalHelpers;
    }

    public List<IAggrMeasureFilterEvalHelper> getMeasureFilterEvalHelpers() throws DataException {
        return this.aggrMeasureFilterEvalHelpers;
    }

    public List<IJSFacttableFilterEvalHelper> getFacttableBasedFilterHelpers() throws DataException {
        return this.advancedFacttableBasedFilterEvalHelper;
    }

    private Set<DimLevel> getDimLevelsDefinedInCubeQuery() {
        HashSet<DimLevel> dimLevelDefinedInCube = new HashSet<DimLevel>();
        this.populateDimLevelInEdge(dimLevelDefinedInCube, 2);
        this.populateDimLevelInEdge(dimLevelDefinedInCube, 1);
        this.populateDimLevelInEdge(dimLevelDefinedInCube, 3);
        return dimLevelDefinedInCube;
    }

    private void populateDimLevelInEdge(Set<DimLevel> dimLevelDefinedInCube, int i) {
        IEdgeDefinition edge = this.defn.getEdge(i);
        if (edge == null) {
            return;
        }
        List<IDimensionDefinition> dims = edge.getDimensions();
        for (IDimensionDefinition dim : dims) {
            List<ILevelDefinition> levels = dim.getHierarchy().get(0).getLevels();
            for (ILevelDefinition level : levels) {
                dimLevelDefinedInCube.add(new DimLevel(dim.getName(), level.getName()));
            }
        }
    }

    public IComputedMeasureHelper getComputedMeasureHelper() throws DataException {
        if (this.defn.getComputedMeasures() != null && this.defn.getComputedMeasures().size() > 0) {
            return new ComputedMeasureHelper(this.scope, this.session.getEngineContext().getScriptContext(), this.defn.getComputedMeasures());
        }
        return null;
    }

    public ICubeQueryDefinition getCubeQueryDefinition() {
        return this.defn;
    }

    public DataEngineSession getSession() {
        return this.session;
    }

    public DataEngineContext getContext() {
        return this.context;
    }

    public List getColumnEdgeSort() {
        return this.getEdgeSort(2);
    }

    public List getRowEdgeSort() {
        return this.getEdgeSort(1);
    }

    public List getPageEdgeSort() {
        return this.getEdgeSort(3);
    }

    public String getQueryResultsId() {
        return this.queryResultsId;
    }

    public void setQueryResultsId(String id) {
        this.queryResultsId = id;
    }

    public IBaseQueryResults getOuterResults() {
        return this.outResults;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    private List getEdgeSort(int edgeType) {
        List l = this.defn.getSorts();
        ArrayList<ICubeSortDefinition> result = new ArrayList<ICubeSortDefinition>();
        int i = 0;
        while (i < l.size()) {
            ICubeSortDefinition sort = (ICubeSortDefinition)l.get(i);
            if (this.defn.getEdge(edgeType) != null && sort.getTargetLevel() != null && this.defn.getEdge(edgeType).getDimensions().contains(sort.getTargetLevel().getHierarchy().getDimension())) {
                result.add(sort);
            }
            ++i;
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int level2;
                int level1 = ((ICubeSortDefinition)arg0).getTargetLevel().getHierarchy().getLevels().indexOf(((ICubeSortDefinition)arg0).getTargetLevel());
                if (level1 == (level2 = ((ICubeSortDefinition)arg1).getTargetLevel().getHierarchy().getLevels().indexOf(((ICubeSortDefinition)arg1).getTargetLevel()))) {
                    return 0;
                }
                if (level1 < level2) {
                    return -1;
                }
                return 1;
            }
        });
        return result;
    }
}

