/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.utils;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class XmlUtils {
    private static Logger logger = LoggerFactory.getLogger(XmlUtils.class);
    private static String dataTypeString = "STRING";
    private static String dataTypeList = "LIST";

    public static Document getDocumentFromStrBuffer(StringBuffer strBufferContent) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(strBufferContent.toString().getBytes("UTF-8"));
            InputSource inputSource = new InputSource(bais);
            doc = db.parse(inputSource);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return doc;
    }

    public static String extractByConfFile(StringBuffer strBufferContent, String xpath, String dataType) {
        Document doc = XmlUtils.getDocumentFromStrBuffer(strBufferContent);
        String data = null;
        try {
            if (dataType == null || dataType.equals("") || dataType.equalsIgnoreCase(dataTypeString)) {
                data = XPathAPI.eval((Node)doc, (String)xpath).toString();
            } else if (dataType != null && dataType.equalsIgnoreCase(dataTypeList)) {
                Node n;
                data = "";
                NodeIterator nl = XPathAPI.selectNodeIterator((Node)doc, (String)xpath);
                while ((n = nl.nextNode()) != null) {
                    data = String.valueOf(data) + n.getTextContent() + " ";
                }
            }
            logger.debug("=>" + data + "<=\n");
        }
        catch (TransformerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return data;
    }
}

