/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event;

import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.event.EventHandlerWrapper;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class EventHandlerTracker
extends ServiceTracker
implements EventDispatcher {
    private final LogService log;
    private final List globalWildcard;
    private final Map partialWildcard;
    private final Map topicName;
    static /* synthetic */ Class class$0;

    public EventHandlerTracker(BundleContext context, LogService log) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.event.EventHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz.getName(), null);
        this.log = log;
        this.globalWildcard = new ArrayList();
        this.partialWildcard = new HashMap();
        this.topicName = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        EventHandlerWrapper wrapper = new EventHandlerWrapper(reference, this.context, this.log);
        EventHandlerTracker eventHandlerTracker = this;
        synchronized (eventHandlerTracker) {
            if (wrapper.init()) {
                this.bucket(wrapper);
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference reference, Object service) {
        EventHandlerWrapper wrapper = (EventHandlerWrapper)service;
        EventHandlerTracker eventHandlerTracker = this;
        synchronized (eventHandlerTracker) {
            this.unbucket(wrapper);
            if (wrapper.init()) {
                this.bucket(wrapper);
                return;
            }
        }
        wrapper.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        EventHandlerWrapper wrapper = (EventHandlerWrapper)service;
        EventHandlerTracker eventHandlerTracker = this;
        synchronized (eventHandlerTracker) {
            this.unbucket(wrapper);
        }
        wrapper.flush();
    }

    private void bucket(EventHandlerWrapper wrapper) {
        String[] topics = wrapper.getTopics();
        int length = topics == null ? 0 : topics.length;
        int i = 0;
        while (i < length) {
            String topic = topics[i];
            if (topic.equals("*")) {
                this.globalWildcard.add(wrapper);
            } else if (topic.endsWith("/*")) {
                String key = topic.substring(0, topic.length() - 2);
                ArrayList<EventHandlerWrapper> wrappers = (ArrayList<EventHandlerWrapper>)this.partialWildcard.get(key);
                if (wrappers == null) {
                    wrappers = new ArrayList<EventHandlerWrapper>();
                    this.partialWildcard.put(key, wrappers);
                }
                wrappers.add(wrapper);
            } else {
                ArrayList<EventHandlerWrapper> wrappers = (ArrayList<EventHandlerWrapper>)this.topicName.get(topic);
                if (wrappers == null) {
                    wrappers = new ArrayList<EventHandlerWrapper>();
                    this.topicName.put(topic, wrappers);
                }
                wrappers.add(wrapper);
            }
            ++i;
        }
    }

    private void unbucket(EventHandlerWrapper wrapper) {
        String[] topics = wrapper.getTopics();
        int length = topics == null ? 0 : topics.length;
        int i = 0;
        while (i < length) {
            String topic = topics[i];
            if (topic.equals("*")) {
                this.globalWildcard.remove(wrapper);
            } else if (topic.endsWith("/*")) {
                String key = topic.substring(0, topic.length() - 2);
                List wrappers = (List)this.partialWildcard.get(key);
                if (wrappers != null) {
                    wrappers.remove(wrapper);
                    if (wrappers.size() == 0) {
                        this.partialWildcard.remove(key);
                    }
                }
            } else {
                List wrappers = (List)this.topicName.get(topic);
                if (wrappers != null) {
                    wrappers.remove(wrapper);
                    if (wrappers.size() == 0) {
                        this.topicName.remove(topic);
                    }
                }
            }
            ++i;
        }
    }

    public synchronized Set getHandlers(String topic) {
        List wrappers;
        HashSet handlers = new HashSet();
        handlers.addAll(this.globalWildcard);
        if (this.partialWildcard.size() > 0) {
            int index = topic.length();
            while (index >= 0) {
                String subTopic = topic.substring(0, index);
                List wrappers2 = (List)this.partialWildcard.get(subTopic);
                if (wrappers2 != null) {
                    handlers.addAll(wrappers2);
                }
                index = subTopic.lastIndexOf(47);
            }
        }
        if ((wrappers = (List)this.topicName.get(topic)) != null) {
            handlers.addAll(wrappers);
        }
        return handlers;
    }

    public void dispatchEvent(Object eventListener, Object listenerObject, int eventAction, Object eventObject) {
        ((EventHandlerWrapper)eventListener).handleEvent((Event)eventObject, (Permission)listenerObject);
    }
}

