/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.MailFile;
import com.sun.mail.mbox.Mailbox;
import com.sun.mail.mbox.UNIXFolder;
import com.sun.mail.mbox.UNIXInbox;
import java.io.File;

public class SolarisMailbox
extends Mailbox {
    private String home = System.getProperty("user.home");
    private String user = System.getProperty("user.name");

    @Override
    public MailFile getMailFile(String user, String folder) {
        if (folder.equalsIgnoreCase("INBOX")) {
            return new UNIXInbox(user, this.filename(user, folder));
        }
        return new UNIXFolder(this.filename(user, folder));
    }

    @Override
    public String filename(String user, String folder) {
        try {
            switch (folder.charAt(0)) {
                case '/': {
                    return folder;
                }
                case '~': {
                    int i = folder.indexOf(File.separatorChar);
                    String tail = "";
                    if (i > 0) {
                        tail = folder.substring(i);
                        folder = folder.substring(0, i);
                    }
                    if (folder.length() == 1) {
                        return String.valueOf(this.home) + tail;
                    }
                    return "/home/" + folder.substring(1) + tail;
                }
            }
            if (folder.equalsIgnoreCase("INBOX")) {
                if (user == null) {
                    user = this.user;
                }
                return "/var/mail/" + user;
            }
            return String.valueOf(this.home) + File.separator + folder;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return folder;
        }
    }
}

