/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.mail;

import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.ebpm.connectors.mail.MailParameters;
import org.eclipse.ebpm.connectors.mail.PollingTask;
import org.eclipse.ebpm.connectors.mail.marshaler.AbstractMailMarshaler;
import org.eclipse.ebpm.connectors.mail.marshaler.DefaultMailMarshaler;
import org.eclipse.ebpm.connectors.mail.utils.MailConnectionConfiguration;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailPollerComponent
extends AbstractSpagicConnector {
    protected Logger log = LoggerFactory.getLogger(MailPollerComponent.class);
    public static final String PROPERTY_MARSHALER = "marshaler";
    public static final String PROPERTY_CUSTOMTRUSTMANAGER = "customTrustManagers";
    public static final String PROPERTY_MAXFETCHSIZE = "maxFetchSize";
    public static final String PROPERTY_PROCESSONLYUNSEENMESSAGES = "processOnlyUnseenMessages";
    public static final String PROPERTY_DELETEPROCESSEDMESSAGES = "deleteProcessedMessages";
    public static final String PROPERTY_DEBUGMODE = "debugMode";
    public static final String PROPERTY_STARTTLS = "startTLS";
    public static final String PROPERTY_PERIOD = "period";
    private MailParameters mailParams;
    private Timer timerService;

    public void init() {
        AbstractMailMarshaler abstractMailMarshaler;
        this.mailParams = new MailParameters();
        if (this.propertyConfigurator.getString(PROPERTY_MARSHALER) != null && !this.propertyConfigurator.getString(PROPERTY_MARSHALER).equals("")) {
            try {
                Class<?> classe = Class.forName(this.propertyConfigurator.getString(PROPERTY_MARSHALER));
                Constructor<?> c = classe.getConstructor(new Class[0]);
                abstractMailMarshaler = (AbstractMailMarshaler)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                this.log.error("The selected mail Marshaler is invalid: " + this.propertyConfigurator.getString(PROPERTY_MARSHALER) + " the defaul one will be used ", (Throwable)e);
                abstractMailMarshaler = new DefaultMailMarshaler();
            }
        } else {
            abstractMailMarshaler = new DefaultMailMarshaler();
        }
        this.setMarshaler(abstractMailMarshaler);
        String host = this.propertyConfigurator.getString("host");
        String password = this.propertyConfigurator.getString("password");
        String protocol = this.propertyConfigurator.getString("protocol");
        String username = this.propertyConfigurator.getString("username");
        int port = this.propertyConfigurator.getInteger("port", Integer.valueOf(-1));
        boolean startTLS = this.propertyConfigurator.getBoolean(PROPERTY_STARTTLS, Boolean.valueOf(false));
        String folderName = this.propertyConfigurator.getString("folderName", "INBOX");
        MailConnectionConfiguration config = new MailConnectionConfiguration(host, password, protocol, username, startTLS, folderName, port);
        this.setMailConnectionConfiguration(config);
        this.setCustomTrustManagers(this.propertyConfigurator.getString(PROPERTY_CUSTOMTRUSTMANAGER, null));
        this.setConnection(config);
        this.setMaxFetchSize(this.propertyConfigurator.getInteger(PROPERTY_MAXFETCHSIZE, Integer.valueOf(5)));
        this.setPeriod(this.propertyConfigurator.getLong(PROPERTY_PERIOD, Long.valueOf(10000L)));
        this.setProcessOnlyUnseenMessages(this.propertyConfigurator.getBoolean(PROPERTY_PROCESSONLYUNSEENMESSAGES, Boolean.valueOf(true)));
        this.setDeleteProcessedMessages(this.propertyConfigurator.getBoolean(PROPERTY_DELETEPROCESSEDMESSAGES, Boolean.valueOf(false)));
        this.setDebugMode(this.propertyConfigurator.getBoolean(PROPERTY_DEBUGMODE, Boolean.valueOf(false)));
        this.setStartTLS(this.propertyConfigurator.getBoolean(PROPERTY_STARTTLS, Boolean.valueOf(false)));
    }

    public void start() throws Exception {
        super.start();
        this.timerService = new Timer();
        this.timerService.schedule((TimerTask)new PollingTask(this.mailParams, this), new Date(), this.getPeriod());
    }

    public void stop() throws Exception {
        super.stop();
        this.timerService.cancel();
        this.timerService = null;
    }

    public long getPeriod() {
        return this.mailParams.period;
    }

    public void setPeriod(long period) {
        this.mailParams.period = period;
    }

    public boolean isDeleteProcessedMessages() {
        return this.mailParams.deleteProcessedMessages;
    }

    public void setDeleteProcessedMessages(boolean deleteProcessedMessages) {
        this.mailParams.deleteProcessedMessages = deleteProcessedMessages;
    }

    public AbstractMailMarshaler getMarshaler() {
        return this.mailParams.marshaler;
    }

    public void setMarshaler(AbstractMailMarshaler marshaler) {
        this.mailParams.marshaler = marshaler;
    }

    public int getMaxFetchSize() {
        return this.mailParams.maxFetchSize;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.mailParams.maxFetchSize = maxFetchSize;
    }

    public boolean isProcessOnlyUnseenMessages() {
        return this.mailParams.processOnlyUnseenMessages;
    }

    public void setProcessOnlyUnseenMessages(boolean processOnlyUnseenMessages) {
        this.mailParams.processOnlyUnseenMessages = processOnlyUnseenMessages;
    }

    public String getConnection() {
        return this.mailParams.connection;
    }

    public void setConnection(MailConnectionConfiguration config) {
        String connStr = String.valueOf(config.getProtocol()) + "://" + config.getHost();
        connStr = String.valueOf(connStr) + (config.getPort() != -1 ? ":" + config.getPort() : "");
        connStr = String.valueOf(connStr) + (config.getFolderName() != "" ? "/" + config.getFolderName() : "");
        this.mailParams.connection = connStr = String.valueOf(connStr) + "?user=" + config.getUsername() + ";password=" + config.getPassword();
    }

    public void setMailConnectionConfiguration(MailConnectionConfiguration config) {
        this.mailParams.config = config;
    }

    public boolean isDebugMode() {
        return this.mailParams.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.mailParams.debugMode = debugMode;
    }

    public String getCustomTrustManagers() {
        return this.mailParams.customTrustManagers;
    }

    public void setCustomTrustManagers(String customTrustManagers) {
        this.mailParams.customTrustManagers = customTrustManagers;
    }

    public boolean isStartTLS() {
        return this.mailParams.startTLS;
    }

    public void setStartTLS(boolean startTLS) {
        this.mailParams.startTLS = startTLS;
    }

    public void process(Exchange exchange) {
        if (!exchange.getStatus().equals((Object)Status.Done)) {
            throw new IllegalStateException("Error unexppected message status: " + exchange.getStatus().name());
        }
    }

    public Exchange getExchange() {
        return this.createInOnlyExchange();
    }

    protected void sendMessage(Exchange exchange) {
        this.log.debug("Sending message ");
        this.send(exchange);
    }
}

