/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.IServiceTypeEvent;
import org.eclipse.ecf.discovery.IServiceTypeListener;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;

public class ServiceTypeListener
implements IServiceTypeListener {
    private final IDiscoveryLocator discovery;
    private final IServiceTypeID[] serviceTypeIDs;
    final IServiceListener serviceListener;
    private final String[] requiredProperties;

    public ServiceTypeListener(IDiscoveryLocator discovery, IServiceListener serviceListener, IServiceTypeID[] serviceTypeIDs, String[] requiredProperties) {
        this.discovery = discovery;
        Assert.isNotNull((Object)this.discovery);
        this.serviceListener = serviceListener;
        Assert.isNotNull((Object)this.serviceListener);
        this.serviceTypeIDs = serviceTypeIDs;
        this.requiredProperties = requiredProperties;
    }

    public ServiceTypeListener(IDiscoveryLocator discovery, IServiceListener serviceListener, IServiceTypeID serviceTypeID, String[] requiredProperties) {
        this(discovery, serviceListener, new IServiceTypeID[]{serviceTypeID}, requiredProperties);
    }

    public ServiceTypeListener(IDiscoveryLocator discovery, IServiceListener serviceListener, IServiceTypeID serviceTypeID) {
        this(discovery, serviceListener, new IServiceTypeID[]{serviceTypeID}, null);
    }

    public ServiceTypeListener(IDiscoveryLocator discovery, IServiceListener serviceListener) {
        this(discovery, serviceListener, (IServiceTypeID[])null, (String[])null);
    }

    public final void serviceTypeAdded(IServiceTypeEvent event) {
        IServiceTypeID remoteServiceTypeID = event.getServiceTypeID();
        if (this.hasRequiredTypeID(remoteServiceTypeID)) {
            this.discovery.addServiceListener(remoteServiceTypeID, this.serviceListener);
        }
    }

    private boolean hasRequiredTypeID(IServiceTypeID remoteServiceTypeID) {
        if (this.serviceTypeIDs == null) {
            return true;
        }
        int i = 0;
        while (i < this.serviceTypeIDs.length) {
            if (remoteServiceTypeID.equals((Object)this.serviceTypeIDs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean hasRequiredProperties(IServiceProperties serviceProperties) {
        if (this.requiredProperties == null) {
            return true;
        }
        int i = 0;
        while (i < this.requiredProperties.length) {
            if (serviceProperties.getProperty(this.requiredProperties[i]) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void serviceTypeDiscovered(IServiceTypeEvent event) {
        IServiceTypeID remoteServiceTypeID = event.getServiceTypeID();
        if (this.hasRequiredTypeID(remoteServiceTypeID)) {
            this.discovery.addServiceListener(remoteServiceTypeID, this.serviceListener);
        }
    }

    class ServiceListener
    implements IServiceListener {
        ServiceListener() {
        }

        public void serviceDiscovered(IServiceEvent anEvent) {
            IServiceInfo svcInfo = anEvent.getServiceInfo();
            if (ServiceTypeListener.this.hasRequiredProperties(svcInfo.getServiceProperties())) {
                ServiceTypeListener.this.serviceListener.serviceDiscovered(anEvent);
            }
        }

        public void serviceUndiscovered(IServiceEvent anEvent) {
            IServiceInfo svcInfo = anEvent.getServiceInfo();
            if (ServiceTypeListener.this.hasRequiredProperties(svcInfo.getServiceProperties())) {
                ServiceTypeListener.this.serviceListener.serviceUndiscovered(anEvent);
            }
        }
    }
}

