/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.releng.p2.to.maven;

public class MavenReference {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;

    public MavenReference(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null);
    }

    public MavenReference(String groupId, String artifactId, String version, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
    }

    public MavenReference() {
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return String.valueOf(this.groupId) + ":" + this.artifactId + ":" + this.version + ":" + this.classifier;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String toFileName() {
        return this.toFileName(null);
    }

    public String toFileName(String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.artifactId);
        sb.append('-');
        sb.append(this.version);
        if (this.classifier != null) {
            sb.append('-');
            sb.append(this.classifier);
        }
        sb.append(".jar");
        if (suffix != null) {
            sb.append('.');
            sb.append(suffix);
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenReference other = (MavenReference)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

