/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.validation;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.ui.validation.ECPValidationResultService;

public class ECPValidationResultServiceImpl
implements ECPValidationResultService {
    private final Set<ECPValidationResultService.ECPValidationResultServiceListener> listener = new LinkedHashSet<ECPValidationResultService.ECPValidationResultServiceListener>();
    private final Map<EClassifier, Set<ECPValidationResultService.ECPValidationResultServiceListener>> classifierToListenerMap = new LinkedHashMap<EClassifier, Set<ECPValidationResultService.ECPValidationResultServiceListener>>();
    private final Map<ECPValidationResultService.ECPValidationResultServiceListener, Set<EClassifier>> listenerToClassifierMap = new LinkedHashMap<ECPValidationResultService.ECPValidationResultServiceListener, Set<EClassifier>>();

    @Override
    public void setResult(Diagnostic[] diagnostic) {
        LinkedHashSet<EClassifier> classifiers = new LinkedHashSet<EClassifier>();
        Diagnostic[] diagnosticArray = diagnostic;
        int n = diagnostic.length;
        int n2 = 0;
        while (n2 < n) {
            Diagnostic d = diagnosticArray[n2];
            this.extractClassifier(classifiers, d);
            ++n2;
        }
        this.notifyListener(diagnostic, classifiers);
    }

    @Override
    public void setResult(Diagnostic diagnostic) {
        LinkedHashSet<EClassifier> classifiers = new LinkedHashSet<EClassifier>();
        this.extractClassifier(classifiers, diagnostic);
        this.notifyListener(diagnostic, classifiers);
    }

    @Override
    public void setResult(List<Diagnostic> diagnostic) {
        LinkedHashSet<EClassifier> classifiers = new LinkedHashSet<EClassifier>();
        for (Diagnostic d : diagnostic) {
            this.extractClassifier(classifiers, d);
        }
        this.notifyListener(diagnostic, classifiers);
    }

    private void extractClassifier(Set<EClassifier> classifiers, Diagnostic d) {
        if (d.getData().size() == 0 || !(d.getData().get(0) instanceof EObject)) {
            return;
        }
        EObject object = (EObject)d.getData().get(0);
        classifiers.add((EClassifier)object.eClass());
    }

    private void notifyListener(Object diagnostic, Set<EClassifier> classifiers) {
        this.notifyListenerFromSet(diagnostic, this.listener);
        for (EClassifier c : classifiers) {
            Set<ECPValidationResultService.ECPValidationResultServiceListener> set = this.classifierToListenerMap.get(c);
            if (set == null) continue;
            this.notifyListenerFromSet(diagnostic, set);
        }
    }

    private void notifyListenerFromSet(Object diagnostic, Set<ECPValidationResultService.ECPValidationResultServiceListener> listener) {
        Iterator<ECPValidationResultService.ECPValidationResultServiceListener> iterator = listener.iterator();
        while (iterator.hasNext()) {
            iterator.next().resultChanged(diagnostic);
        }
    }

    @Override
    public void register(ECPValidationResultService.ECPValidationResultServiceListener listener) {
        this.listener.add(listener);
        this.removeFromSpecificMap(listener);
    }

    @Override
    public void register(ECPValidationResultService.ECPValidationResultServiceListener listener, Set<EClassifier> classifiersOfInterest) {
        this.listener.remove(listener);
        LinkedHashSet<EClassifier> currentlyRegisteredClassifiers = this.listenerToClassifierMap.containsKey(listener) ? this.listenerToClassifierMap.get(listener) : new LinkedHashSet<EClassifier>();
        LinkedHashSet<EClassifier> classifiersToRemove = new LinkedHashSet<EClassifier>();
        for (EClassifier classifier : currentlyRegisteredClassifiers) {
            if (classifiersOfInterest.contains(classifier)) continue;
            classifiersToRemove.add(classifier);
            this.classifierToListenerMap.get(classifier).remove(listener);
        }
        currentlyRegisteredClassifiers.removeAll(classifiersToRemove);
        for (EClassifier classifier : classifiersOfInterest) {
            currentlyRegisteredClassifiers.add(classifier);
            this.addToClassifierToListenerMap(classifier, listener);
        }
        this.listenerToClassifierMap.put(listener, currentlyRegisteredClassifiers);
    }

    private void addToClassifierToListenerMap(EClassifier classifier, ECPValidationResultService.ECPValidationResultServiceListener listener) {
        if (!this.classifierToListenerMap.containsKey(classifier)) {
            this.classifierToListenerMap.put(classifier, new LinkedHashSet());
        }
        this.classifierToListenerMap.get(classifier).add(listener);
    }

    private void removeFromSpecificMap(ECPValidationResultService.ECPValidationResultServiceListener listener) {
        if (!this.listenerToClassifierMap.containsKey(listener)) {
            return;
        }
        Set<EClassifier> classifiers = this.listenerToClassifierMap.get(listener);
        for (EClassifier c : classifiers) {
            this.classifierToListenerMap.get(c).remove(listener);
        }
        this.listenerToClassifierMap.remove(listener);
    }

    @Override
    public void deregister(ECPValidationResultService.ECPValidationResultServiceListener listener) {
        this.listener.remove(listener);
        this.removeFromSpecificMap(listener);
    }
}

