/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.testserver;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Set;

public class SocketUtil {
    private static final Set<Integer> usedPorts = new HashSet<Integer>(10);

    private SocketUtil() {
    }

    public static synchronized int findOpenPort(int port, int maxAttempts, int maxPortsToTry) throws IOException {
        IOException lastEx = null;
        int portToTry = port;
        while (portToTry < port + maxPortsToTry) {
            if (usedPorts.contains(portToTry)) {
                ++maxPortsToTry;
            } else {
                int attemptsOnThisSocket = 0;
                while (attemptsOnThisSocket < maxAttempts) {
                    try {
                        new ServerSocket(portToTry).close();
                        return portToTry;
                    }
                    catch (IOException iox) {
                        lastEx = iox;
                        ++attemptsOnThisSocket;
                    }
                }
            }
            ++portToTry;
        }
        throw lastEx;
    }

    public static void reservePort(int port) {
        usedPorts.add(port);
    }

    public static void freePort(int port) {
        usedPorts.remove(port);
    }
}

