/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.lookup;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.serialization.CachingObjectStore;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.FileSystemObjectStore;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.SerializationException;

public class PreviewObjectStore
extends FileSystemObjectStore
implements CachingObjectStore {
    private Map<String, EObject> cache = new HashMap<String, EObject>();

    public PreviewObjectStore(File root, IEnvironment env) {
        super(root, env);
    }

    public PreviewObjectStore(File root, IEnvironment env, String storageFormat) {
        super(root, env, storageFormat);
    }

    public PreviewObjectStore(File root, IEnvironment env, String storageFormat, String fileExtension) {
        super(root, env, storageFormat, fileExtension);
    }

    public void primRemove(String key) {
        super.primRemove(key);
        String normKey = key.toUpperCase().toLowerCase();
        this.cache.remove(normKey);
    }

    public void put(String key, EObject obj) throws SerializationException {
        super.put(key, obj);
        if (obj != null) {
            String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
            this.cache.put(normKey, obj);
        }
    }

    public EObject get(String key) throws DeserializationException {
        String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
        EObject value = this.cache.get(normKey);
        if (value == null && (value = super.get(key)) != null) {
            this.cache.put(normKey, value);
        }
        return value;
    }

    public EObject getFromCache(String key) {
        String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
        return this.cache.get(normKey);
    }

    public void addToCache(String key, EObject object) {
        String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
        this.cache.put(normKey, object);
    }

    public void clearCache() {
        this.cache.clear();
    }
}

