/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization.xml;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EEnum;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.impl.Dynamic;
import org.eclipse.edt.mof.impl.DynamicEClass;
import org.eclipse.edt.mof.impl.DynamicEObject;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Deserializer;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ProxyEObject;
import org.eclipse.edt.mof.utils.EList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLDeserializer
extends DefaultHandler
implements Deserializer {
    private static final String Attr_eClass = "eClass";
    private static final String Attr_ID = "ID";
    private static final String Attr_IDREF = "IDREF";
    private static final String Attr_href = "href";
    private static final String Element_entry = "entry";
    XMLReader parser;
    MofFactory mof = MofFactory.INSTANCE;
    Object object;
    Stack<Object> stack = new Stack();
    Map<String, EObject> eobjects = new HashMap<String, EObject>();
    InputSource input = null;
    IEnvironment env;
    EType datatype;
    EType listDatatype;
    boolean newList = true;
    boolean isPopEntry = false;
    StringBuilder charBuf;

    public XMLDeserializer(InputStream input, IEnvironment env) throws UnsupportedEncodingException {
        this.input = new InputSource(input);
        this.env = env;
    }

    @Override
    public EObject deserialize() throws DeserializationException {
        if (this.input == null) {
            throw new DeserializationException("No input to process");
        }
        this.parser = this.createParser();
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        try {
            this.parser.parse(this.input);
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
        return (EObject)this.object;
    }

    private XMLReader createParser() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void startElement(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        EObject result;
        block19: {
            String typeSignature;
            block22: {
                block24: {
                    block25: {
                        EClass eClass;
                        block23: {
                            block21: {
                                EType type;
                                block20: {
                                    String idref;
                                    block18: {
                                        this.checkCharacters();
                                        result = null;
                                        if (localName == null || localName.length() == 0) {
                                            localName = qName;
                                        }
                                        typeSignature = attrs.getValue("", Attr_eClass);
                                        idref = attrs.getValue("", Attr_IDREF);
                                        String href = attrs.getValue("", Attr_href);
                                        if (href == null) break block18;
                                        result = this.resolveTypeReference(href, true);
                                        break block19;
                                    }
                                    if (idref == null) break block20;
                                    result = this.eobjects.get(idref);
                                    if (result == null) {
                                        result = new ProxyEObject();
                                        this.eobjects.put(idref, result);
                                    }
                                    break block19;
                                }
                                if (!localName.equals(Element_entry) || this.listDatatype == null) break block21;
                                if (this.newList) {
                                    this.stack.push(new EList());
                                    this.newList = false;
                                }
                                if ((type = ((EGenericType)this.listDatatype).getETypeArguments().get(0)) instanceof EGenericType) {
                                    this.listDatatype = type;
                                } else {
                                    this.datatype = type;
                                    if (this.datatype instanceof EDataType) {
                                        this.stack.push("");
                                    }
                                    this.isPopEntry = !(this.datatype instanceof EClass);
                                }
                                break block19;
                            }
                            if (typeSignature != null) break block22;
                            EObject obj = (EObject)this.stack.peek();
                            if (obj == null) {
                                throw new SAXException("No type specified for element: " + localName);
                            }
                            eClass = obj.getEClass();
                            if (!(eClass instanceof DynamicEClass)) break block23;
                            this.stack.push("");
                            this.datatype = eClass;
                            break block19;
                        }
                        EField field = eClass.getEField(localName);
                        if (field == null) {
                            this.stack.push(null);
                        }
                        if (field == null || !field.getEType().getEClassifier().equals(this.mof.getEListEDataType())) break block24;
                        this.datatype = ((EGenericType)field.getEType()).getETypeArguments().get(0);
                        if (!this.datatype.getEClassifier().equals(this.mof.getEListEDataType())) break block25;
                        this.listDatatype = this.datatype;
                        this.datatype = null;
                        break block19;
                    }
                    if (!(this.datatype instanceof EDataType)) break block19;
                    this.stack.push("");
                    break block19;
                }
                throw new SAXException("No type specified for element: " + localName);
            }
            EClass eClass = (EClass)this.resolveTypeReference(typeSignature, false);
            result = eClass.newInstance(true, false);
            int i = 0;
            while (i < attrs.getLength()) {
                String attr = attrs.getLocalName(i);
                if (attr == null || attr.length() == 0) {
                    attr = attrs.getQName(i);
                }
                if (attr.equals(Attr_ID)) {
                    EObject proxy = this.eobjects.get(attrs.getValue(i));
                    if (proxy instanceof ProxyEObject) {
                        ((ProxyEObject)proxy).updateReferences(result);
                    }
                    this.eobjects.put(attrs.getValue(i), result);
                } else if (!(attr.equals(Attr_eClass) || attr.equals(Attr_ID) || attr.equals(Attr_IDREF))) {
                    if (eClass instanceof Dynamic) {
                        result.eSet(attr, (Object)attrs.getValue(i));
                    } else {
                        EField field = eClass.getEField(attr);
                        if (field != null) {
                            Object value = this.valueFromString(field.getEType(), attrs.getValue(i));
                            result.eSet(field, value);
                        }
                    }
                }
                ++i;
            }
        }
        if (result != null) {
            this.stack.push(result);
        }
    }

    @Override
    public void endElement(String nsURI, String localName, String qName) throws SAXException {
        Object source;
        this.checkCharacters();
        if (localName == null || localName.length() == 0) {
            localName = qName;
        }
        this.datatype = null;
        if (localName.equals(Element_entry)) {
            if (this.isPopEntry) {
                this.isPopEntry = false;
            } else {
                return;
            }
        }
        if ((source = this.stack.pop()) == null) {
            return;
        }
        if (this.stack.isEmpty()) {
            this.object = source;
        } else {
            Object target = this.stack.peek();
            if (target instanceof List) {
                ((List)target).add(source);
                if (localName.equals(Element_entry) && source instanceof List) {
                    this.newList = true;
                }
            } else if (target instanceof DynamicEObject) {
                EList<Object> list = (EList<Object>)((DynamicEObject)target).eGet(localName);
                if (list == null) {
                    list = new EList<Object>();
                    ((DynamicEObject)target).eSet(localName, list);
                }
                list.add(source);
            } else {
                EObject etarget = (EObject)target;
                EField field = etarget.getEClass().getEField(localName);
                if (field.getEType().getEClassifier() == this.mof.getEListEDataType()) {
                    if ((List)etarget.eGet(field) == null && this.isNullableListType(field)) {
                        etarget.eSet(field, new EList());
                    }
                    ((List)etarget.eGet(field)).add(source);
                    if (source instanceof List) {
                        this.newList = true;
                    }
                } else {
                    etarget.eSet(field, source);
                }
            }
        }
    }

    private boolean isNullableListType(EField field) {
        if (!field.isNullable()) {
            return false;
        }
        if (field.getEType() != null && field.getEType().getEClassifier() != null) {
            return field.getEType().getEClassifier().equals(MofFactory.INSTANCE.getEListEDataType());
        }
        return false;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.charBuf == null) {
            this.charBuf = new StringBuilder(length);
        }
        this.charBuf.append(ch, start, length);
    }

    private void checkCharacters() throws SAXException {
        if (this.charBuf != null) {
            if (this.datatype != null && (this.datatype instanceof EDataType || this.datatype instanceof DynamicEClass)) {
                String string = this.charBuf.toString();
                this.stack.pop();
                Object value = this.datatype instanceof DynamicEClass ? ((DynamicEClass)this.datatype).getEncodedValue(string) : this.valueFromString(this.datatype, string);
                this.stack.push(value);
                this.datatype = null;
            }
            this.charBuf = null;
        }
    }

    private Object valueFromString(EType type, String input) throws SAXException {
        if (type == this.mof.getEIntEDataType()) {
            return Integer.parseInt(input);
        }
        if (type == this.mof.getEBooleanEDataType()) {
            return Boolean.parseBoolean(input);
        }
        if (type instanceof EEnum) {
            try {
                Class<?> enumClass = Class.forName(type.getETypeSignature());
                return Enum.valueOf(enumClass, input);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return ((EEnum)type).getEEnumLiteral(input);
            }
        }
        if (type instanceof EClass && (type == this.mof.getMofReferenceTypeClass() || ((EClass)type).isSubClassOf(this.mof.getMofReferenceTypeClass()))) {
            try {
                return this.resolveTypeReference(input, true);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        return input;
    }

    private EObject resolveTypeReference(String href, boolean useProxies) throws SAXException {
        try {
            EObject obj = this.env.find(href, useProxies);
            if (obj == null) {
                throw new SAXException("Object not found: " + href);
            }
            return obj;
        }
        catch (DeserializationException e) {
            throw new SAXException(e);
        }
        catch (MofObjectNotFoundException e1) {
            throw new SAXException(e1);
        }
    }
}

