/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.egl.templates;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.StringTokenizer;
import org.eclipse.edt.gen.egl.Context;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;

public class CommonUtilities {
    public static String getValidEGLName(String str) {
        StringTokenizer toks = new StringTokenizer(str, ".");
        StringBuilder retPkg = new StringBuilder();
        while (toks.hasMoreTokens()) {
            if (retPkg.length() > 0) {
                retPkg.append('.');
            }
            retPkg.append(CommonUtilities.validateEGLName(toks.nextToken()));
        }
        return retPkg.toString();
    }

    private static String validateEGLName(String javaName) {
        return javaName;
    }

    static Method getSetter(String fieldName, Type fieldType, Class<?> parent) {
        String methodName = CommonUtilities.buildMethodName("set", fieldName);
        Method[] methodArray = parent.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equalsIgnoreCase(methodName) && method.getParameterTypes() != null && method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getGenericReturnType()) && CommonUtilities.compare(method.getParameterTypes()[0], fieldType)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    static Method getGetter(String fieldName, Class<?> fieldType, Class<?> parent) {
        String methodName = CommonUtilities.buildMethodName(Boolean.TYPE.equals(fieldType) ? "is" : "get", fieldName);
        Method[] methodArray = parent.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equalsIgnoreCase(methodName) && (method.getParameterTypes() == null || method.getParameterTypes().length == 0) && !Void.TYPE.equals(method.getGenericReturnType()) && CommonUtilities.compare(method.getGenericReturnType(), fieldType)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static String buildMethodName(String prefix, String fieldName) {
        StringBuilder methodName = new StringBuilder(prefix);
        methodName.append(fieldName);
        if (fieldName.length() > 0 && Character.isLetter(fieldName.charAt(0))) {
            methodName.setCharAt(prefix.length(), Character.toUpperCase(methodName.charAt(prefix.length())));
        }
        return methodName.toString();
    }

    private static boolean compare(Type methodType, Type fieldType) {
        return methodType.equals(fieldType);
    }

    public static boolean isNullable(Type type) {
        if (Boolean.TYPE.equals(type)) {
            return false;
        }
        if (Byte.TYPE.equals(type)) {
            return false;
        }
        if (Character.TYPE.equals(type)) {
            return false;
        }
        if (Double.TYPE.equals(type)) {
            return false;
        }
        if (Float.TYPE.equals(type)) {
            return false;
        }
        if (Integer.TYPE.equals(type)) {
            return false;
        }
        if (Long.TYPE.equals(type)) {
            return false;
        }
        return !Short.TYPE.equals(type);
    }

    public static Annotation getAnnotation(Context ctx, String key) throws MofObjectNotFoundException, DeserializationException {
        EObject eObject = Environment.getCurrentEnv().find(key);
        if (eObject instanceof StereotypeType && (eObject = ((StereotypeType)eObject).newInstance()) instanceof Annotation) {
            return (Annotation)eObject;
        }
        if (eObject instanceof AnnotationType && (eObject = ((AnnotationType)eObject).newInstance()) instanceof Annotation) {
            return (Annotation)eObject;
        }
        return null;
    }

    static org.eclipse.edt.mof.egl.Type findType(Context ctx, String className) throws MofObjectNotFoundException, DeserializationException {
        org.eclipse.edt.mof.egl.Type eType = null;
        String nativeType = ctx.getNativeMapping(className);
        if (nativeType != null) {
            eType = TypeUtils.getType((String)("egl:" + nativeType));
        } else {
            EObject eObject = Environment.getCurrentEnv().find("egl:" + CommonUtilities.getValidEGLName(className), true);
            if (eObject instanceof org.eclipse.edt.mof.egl.Type) {
                eType = (org.eclipse.edt.mof.egl.Type)eObject;
            }
        }
        return eType;
    }
}

