/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLVariableDotProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.jface.text.ITextViewer;

public class EGLSettingsBlockFieldReferenceCompletion
extends EGLAbstractReferenceCompletion {
    @Override
    protected void precompileContexts() {
        this.addContext("package a; handler a {");
        this.addContext("package a; handler a a atype{");
        this.addContext("package a; handler a function a() new a{");
        this.addContext("package a; handler a function a() new a{a=a,");
        this.addContext("package a; handler a function a() a{");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        final ArrayList proposals = new ArrayList();
        this.getBoundASTNode(viewer, documentOffset, new String[]{"", "a};", "a", "};", "}};"}, new EGLAbstractReferenceCompletion.CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                return astNode instanceof SettingsBlock;
            }
        }, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node boundNode) {
                Type type = this.getTypeFromNode(boundNode);
                if (type != null) {
                    proposals.addAll(new EGLVariableDotProposalHandler(viewer, documentOffset, prefix, EGLSettingsBlockFieldReferenceCompletion.this.editor, type, true).getProposals(false, this.getFieldsAlreadySpecified(boundNode)));
                }
            }

            private List<Field> getFieldsAlreadySpecified(Node node) {
                final ArrayList<Field> list = new ArrayList<Field>();
                if (node instanceof SettingsBlock) {
                    node.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(SettingsBlock settingsBlock) {
                            return true;
                        }

                        public boolean visit(Assignment assignment) {
                            Member mbr = assignment.getLeftHandSide().resolveMember();
                            if (mbr instanceof Field) {
                                list.add((Field)mbr);
                            }
                            return false;
                        }

                        public boolean visit(SetValuesExpression setValuesExpression) {
                            Member mbr = setValuesExpression.getExpression().resolveMember();
                            if (mbr instanceof Field) {
                                list.add((Field)mbr);
                            }
                            return false;
                        }
                    });
                }
                return list;
            }

            private Type getTypeFromNode(Node node) {
                if (node == null) {
                    return null;
                }
                if (node instanceof NewExpression) {
                    return ((NewExpression)node).getType().resolveType();
                }
                if (node instanceof SetValuesExpression) {
                    return ((SetValuesExpression)node).getExpression().resolveType();
                }
                if (node instanceof StructureItem) {
                    return ((StructureItem)node).getType().resolveType();
                }
                if (node instanceof ClassDataDeclaration) {
                    return ((ClassDataDeclaration)node).getType().resolveType();
                }
                if (node instanceof Part) {
                    return ((Part)node).getName().resolveType();
                }
                if (node instanceof EnumerationField) {
                    return null;
                }
                if (node instanceof NestedFunction) {
                    return null;
                }
                if (node instanceof Constructor) {
                    return null;
                }
                return this.getTypeFromNode(node.getParent());
            }
        });
        return proposals;
    }
}

