/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.ide.ui.internal.editor.IAnnotation;
import org.eclipse.edt.ide.ui.internal.editor.ReportedProblem;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;

public class ProblemAnnotation
extends Annotation
implements IAnnotationPresentation,
IAnnotation {
    private List fOverlaids;
    private ReportedProblem fProblem;
    private Image fImage;
    private boolean fImagesInitialized = false;
    private int fLayer = 0;
    private static final int WARNING_LAYER;
    private static final int ERROR_LAYER;

    static {
        AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
        WARNING_LAYER = ProblemAnnotation.computeLayer("org.eclipse.ui.workbench.texteditor.warning", lookup);
        ERROR_LAYER = ProblemAnnotation.computeLayer("org.eclipse.ui.workbench.texteditor.error", lookup);
    }

    private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
        Annotation annotation = new Annotation(annotationType, false, null);
        AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
        if (preference != null) {
            return preference.getPresentationLayer() + 1;
        }
        return 1;
    }

    public ProblemAnnotation(ReportedProblem problem) {
        this.fProblem = problem;
        if (this.fProblem.getSeverity() == 2) {
            this.setType("org.eclipse.ui.workbench.texteditor.error");
            this.fLayer = ERROR_LAYER;
        } else if (this.fProblem.getSeverity() == 1) {
            this.setType("org.eclipse.ui.workbench.texteditor.warning");
            this.fLayer = WARNING_LAYER;
        }
    }

    @Override
    public boolean hasOverlay() {
        return false;
    }

    @Override
    public IAnnotation getOverlay() {
        return null;
    }

    @Override
    public void addOverlaid(IAnnotation annotation) {
        if (this.fOverlaids == null) {
            this.fOverlaids = new ArrayList(1);
        }
        this.fOverlaids.add(annotation);
    }

    @Override
    public void removeOverlaid(IAnnotation annotation) {
        if (this.fOverlaids != null) {
            this.fOverlaids.remove(annotation);
            if (this.fOverlaids.size() == 0) {
                this.fOverlaids = null;
            }
        }
    }

    @Override
    public Iterator getOverlaidIterator() {
        if (this.fOverlaids != null) {
            return this.fOverlaids.iterator();
        }
        return null;
    }

    @Override
    public String getText() {
        return this.fProblem.getMessage();
    }

    @Override
    public boolean isProblem() {
        return this.fProblem.getSeverity() == 2 || this.fProblem.getSeverity() == 1;
    }

    public int getLayer() {
        return this.fLayer;
    }

    @Override
    public Integer getProblemKind() {
        return this.fProblem.getProblemKind();
    }

    @Override
    public boolean isEGLMarkerAnnotation() {
        return false;
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        this.initializeImages();
        if (this.fImage != null) {
            ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000, (int)128);
        }
    }

    private void initializeImages() {
        if (!this.fImagesInitialized) {
            String name = null;
            if (this.isProblem()) {
                switch (this.fProblem.getSeverity()) {
                    case 1: {
                        name = "IMG_OBJS_WARN_TSK";
                        break;
                    }
                    case 2: {
                        name = "IMG_OBJS_ERROR_TSK";
                    }
                }
                this.fImagesInitialized = true;
                if (name != null) {
                    this.fImage = PlatformUI.getWorkbench().getSharedImages().getImage(name);
                }
            }
            this.fImagesInitialized = true;
        }
    }
}

