/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers.wizards;

import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.ui.editor.EGLCodeFormatterUtil;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.HandlerConfiguration;
import org.eclipse.edt.ide.ui.wizards.PartOperation;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class HandlerOperation
extends PartOperation {
    protected String codeTemplateId;
    protected Object contentObj;

    public HandlerOperation(HandlerConfiguration configuration, String templateID, Object contentsObj) {
        super(configuration);
        this.codeTemplateId = templateID;
        this.contentObj = contentsObj;
    }

    public HandlerOperation(HandlerConfiguration configuration, String templateID, Object contentsObj, ISchedulingRule rule) {
        super(configuration, rule);
        this.codeTemplateId = templateID;
        this.contentObj = contentsObj;
    }

    @Override
    public String getFileContents() throws PartTemplateException {
        String contents = null;
        if (this.contentObj != null) {
            contents = this.contentObj.toString();
        } else {
            HandlerConfiguration configuration = (HandlerConfiguration)this.configuration;
            if (this.codeTemplateId == null && configuration.getHandlerType() == 0) {
                this.codeTemplateId = "org.eclipse.edt.ide.ui.templates.basic_handler_part";
            }
            String partName = configuration.getHandlerName();
            contents = this.getFileContents("handler", this.codeTemplateId, new String[]{"${handlerName}"}, new String[]{partName});
        }
        try {
            Document doc = new Document();
            doc.set(contents);
            TextEdit edit = EGLCodeFormatterUtil.format((IDocument)doc, null);
            edit.apply((IDocument)doc);
            contents = doc.get();
        }
        catch (Exception exception) {}
        return contents;
    }
}

