/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.search.IEGLSearchConstants;
import org.eclipse.edt.ide.core.search.IEGLSearchResultCollector;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchMessages;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchResult;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class EGLSearchQuery
implements ISearchQuery,
IEGLSearchConstants {
    private ISearchResult fResult;
    private String fSearchString;
    private boolean fCaseSensitive;
    private int fSearchFor;
    private int fLimitTo;
    private IEGLSearchScope fScope;
    private String fScopeDescription;
    private boolean forceQualification;

    public EGLSearchQuery(String sPattern, boolean isCaseSensitive, int searchFor, int limitTo, IEGLSearchScope scope, String scopeDescription, boolean forceQualification) {
        this.fSearchString = sPattern;
        this.fCaseSensitive = isCaseSensitive;
        this.fSearchFor = searchFor;
        this.fLimitTo = limitTo;
        this.fScope = scope;
        this.fScopeDescription = scopeDescription;
        this.forceQualification = forceQualification;
    }

    public IStatus run(final IProgressMonitor monitor) {
        final EGLSearchResult textResult = (EGLSearchResult)this.getSearchResult();
        textResult.removeAll();
        IEGLSearchResultCollector collector = new IEGLSearchResultCollector(){

            public IProgressMonitor getProgressMonitor() {
                return monitor;
            }

            public void aboutToStart() {
            }

            public void accept(IResource resource, int start, int end, IEGLElement enclosingElement, int accuracy) {
                if (start < 0) {
                    start = 0;
                }
                if (end < start) {
                    end = start;
                }
                textResult.addMatch(new Match((Object)resource, start, end - start));
            }

            public void done() {
            }

            public void accept(IEGLElement element, int start, int end, IResource resource, int accuracy) throws CoreException {
                if (start < 0) {
                    start = 0;
                }
                if (end < start) {
                    end = start;
                }
                textResult.addMatch(new Match((Object)element, start, end - start));
            }
        };
        try {
            SearchEngine engine = new SearchEngine();
            engine.search(EDTUIPlugin.getWorkspace(), SearchEngine.createSearchPattern((String)this.fSearchString, (int)this.fSearchFor, (int)this.fLimitTo, (boolean)this.fCaseSensitive), this.fScope, false, this.forceQualification, collector);
        }
        catch (EGLModelException ex) {
            System.out.println("EGLSearchQuery" + (Object)((Object)ex));
        }
        catch (NullPointerException e) {
            System.out.println("EGLSearchQuery" + e);
        }
        String message = EGLSearchMessages.EGLSearchQueryStatusOkMessage;
        MessageFormat.format(message, new Integer(textResult.getMatchCount()));
        return new Status(0, EDTUIPlugin.getPluginId(), 0, message, null);
    }

    public String getLabel() {
        if (this.fLimitTo == 1) {
            return EGLSearchMessages.EGLSearchQuerySearchfor_references;
        }
        if (this.fLimitTo == 0) {
            return EGLSearchMessages.EGLSearchQuerySearchfor_declarations;
        }
        return EGLSearchMessages.EGLSearchQuerySearch_label;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new EGLSearchResult(this);
            new SearchResultUpdater((AbstractTextSearchResult)this.fResult);
        }
        return this.fResult;
    }

    String getSingularLabel() {
        Object[] args = new String[]{this.fSearchString, this.fScopeDescription};
        return EGLSearchMessages.bind((String)EGLSearchMessages.FileSearchQuery_singularLabel, (Object[])args);
    }

    String getPluralPattern() {
        Object[] args = new String[]{this.fSearchString, "{0}", this.fScopeDescription};
        return EGLSearchMessages.bind((String)EGLSearchMessages.FileSearchQuery_pluralPattern, (Object[])args);
    }
}

