/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.wizards.EGLContainerConfiguration;

public class CoreUtility {
    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                CoreUtility.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public static String getValidProjectName(String toValidate) {
        String validatedString = toValidate;
        char replacementChar = '_';
        char[] invalidCharacters = new char[]{'.', ' ', ',', '\'', ';', '!', '@', '#', '%', '^', '&', '(', ')', '+', '=', '[', ']', '{', '}'};
        int i = 0;
        while (i < invalidCharacters.length) {
            if (validatedString.indexOf(invalidCharacters[i]) != -1) {
                validatedString = validatedString.replace(invalidCharacters[i], replacementChar);
            }
            ++i;
        }
        if (validatedString.charAt(0) >= '0' && validatedString.charAt(0) <= '9') {
            validatedString = String.valueOf('a') + validatedString;
        }
        return validatedString;
    }

    public static String getCamelCaseString(String itemName) {
        String alias = null;
        if (itemName.contains(" ")) {
            String[] names = itemName.split(" ");
            boolean isFirstItem = true;
            StringBuilder builder = new StringBuilder();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                alias = "";
                if (isFirstItem) {
                    builder.append(name);
                    isFirstItem = false;
                } else if (name.trim() != null) {
                    builder.append(CoreUtility.makeFirstCharUpper(name));
                }
                ++n2;
            }
            alias = builder.toString();
        }
        return alias;
    }

    public static String makeFirstCharUpper(String str) {
        if (str.length() > 0 && Character.isLetter(str.charAt(0))) {
            StringBuffer buf = new StringBuffer(str);
            buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
            return buf.toString();
        }
        return str;
    }

    public static IFile getExistingEGLDDFileHandle(EGLContainerConfiguration config) {
        Path sourcePath = new Path(config.getContainerName());
        String fileName = CoreUtility.getValidProjectName(config.getProjectName());
        IFile eglddFile = null;
        if (fileName != null && fileName.trim().length() > 0) {
            sourcePath = sourcePath.append(fileName);
            sourcePath = sourcePath.addFileExtension("egldd");
            eglddFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)sourcePath);
        }
        return eglddFile;
    }

    public static List<IFile> getExistingEGLDDFileHandle(IEGLFile eglFile) throws EGLModelException, CoreException {
        ArrayList<IFile> allDDFile = new ArrayList<IFile>();
        ArrayList<IFolder> sourceFolders = new ArrayList<IFolder>();
        IProject project = eglFile.getEGLProject().getProject();
        IResource[] resources = project.members(false);
        IEGLPathEntry[] entries = eglFile.getEGLProject().getRawEGLPath();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (file.getName().endsWith("egldd")) {
                    allDDFile.add(file);
                }
            } else if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IEGLPathEntry[] iEGLPathEntryArray = entries;
                int n3 = entries.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEGLPathEntry entry = iEGLPathEntryArray[n4];
                    IPath sourcePath = entry.getPath();
                    if (sourcePath.toOSString().contains(folder.getName())) {
                        sourceFolders.add(folder);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        for (IFolder sourceFolder : sourceFolders) {
            allDDFile.addAll(CoreUtility.getExistingEGLDDWithinFolder(sourceFolder));
        }
        return allDDFile;
    }

    private static List<IFile> getExistingEGLDDWithinFolder(IFolder containingFolder) throws CoreException {
        IResource[] resources;
        ArrayList<IFile> allDDFile = new ArrayList<IFile>();
        IResource[] iResourceArray = resources = containingFolder.members(false);
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (file.getName().endsWith("egldd")) {
                    allDDFile.add(file);
                }
            } else if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                allDDFile.addAll(CoreUtility.getExistingEGLDDWithinFolder(folder));
            }
            ++n2;
        }
        return allDDFile;
    }

    public static IFile getOrCreateEGLDDFileHandle(EGLContainerConfiguration config) {
        IFile eglddFile = CoreUtility.getExistingEGLDDFileHandle(config);
        if (eglddFile == null || !eglddFile.exists()) {
            String encodingName = EGLBasePlugin.getPlugin().getPreferenceStore().getString("outputCodeset");
            EGLDDRootHelper.createNewEGLDDFile(eglddFile, encodingName);
        }
        return eglddFile;
    }
}

