/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.ExtractInterfaceWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.EGLFileOperation;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceConfiguration;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceOperation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class ExtractInterfaceWizard
extends EGLPartWizard {
    public ExtractInterfaceWizard() {
        this.setDefaultPageImageDescriptor(PluginImages.DESC_WIZBAN_NEWEGLINTERFACE);
    }

    @Override
    public EGLPackageConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ExtractInterfaceConfiguration();
        }
        return this.configuration;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.getConfiguration().init(workbench, selection);
        this.setWindowTitle(NewWizardMessages.NewEGLPartCreationWizardTitle);
    }

    @Override
    public void addPages() {
        this.addPage((IWizardPage)new ExtractInterfaceWizardPage("WIZPAGENAME_ExtractInterfaceWizardPage"));
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        boolean success = this.runExtractInterfaceOp();
        return success;
    }

    protected boolean runExtractInterfaceOp() {
        boolean success = true;
        try {
            this.getContainer().run(this.canRunForked(), true, (IRunnableWithProgress)this.getOperation());
        }
        catch (InterruptedException e) {
            EGLLogger.log((Object)this, e);
            success = false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                EGLLogger.log((Object)this, e);
            }
            success = false;
        }
        this.openResource(this.configuration.getFile());
        return success;
    }

    private EGLFileOperation getOperation() {
        ISchedulingRule rule = this.getCurrentSchedulingRule();
        ExtractInterfaceOperation operation = null;
        operation = rule != null ? new ExtractInterfaceOperation((ExtractInterfaceConfiguration)this.getConfiguration(), rule) : new ExtractInterfaceOperation((ExtractInterfaceConfiguration)this.getConfiguration());
        return operation;
    }
}

